/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.xp;

import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.XpUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketDrainPlayerXP
extends MessageTileEntity<TileEntity>
implements IMessageHandler<PacketDrainPlayerXP, IMessage> {
    private static boolean isRegistered = false;
    int targetLevel;
    boolean isContainerLevel;

    public static void register() {
        if (!isRegistered) {
            PacketHandler.INSTANCE.registerMessage(PacketDrainPlayerXP.class, PacketDrainPlayerXP.class, PacketHandler.nextID(), Side.SERVER);
            isRegistered = true;
        }
    }

    public PacketDrainPlayerXP() {
    }

    public PacketDrainPlayerXP(TileEntity tile, int targetLevel, boolean isContainerLevel) {
        super(tile);
        this.targetLevel = targetLevel;
        this.isContainerLevel = isContainerLevel;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort((int)((short)this.targetLevel));
        buf.writeBoolean(this.isContainerLevel);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.targetLevel = buf.readShort();
        this.isContainerLevel = buf.readBoolean();
    }

    public IMessage onMessage(PacketDrainPlayerXP message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        TileEntity tile = message.getTileEntity(player.field_70170_p);
        if (tile instanceof IHaveExperience) {
            IHaveExperience xpTile = (IHaveExperience)tile;
            if (player.field_71075_bZ.field_75098_d && message.isContainerLevel) {
                xpTile.getContainer().addExperience(XpUtil.getExperienceForLevel(message.targetLevel));
            } else if (message.isContainerLevel) {
                xpTile.getContainer().drainPlayerXpToReachContainerLevel((EntityPlayer)player, message.targetLevel);
            } else {
                xpTile.getContainer().drainPlayerXpToReachPlayerLevel((EntityPlayer)player, message.targetLevel);
            }
        }
        return null;
    }

    protected boolean isValidTile(TileEntity tile) {
        return tile != null;
    }
}

