/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import crazypants.enderio.config.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

public class IoUtil {
    public static String copyConfigFromJar(String fileName, boolean replaceIfExists) throws IOException {
        if (replaceIfExists || !IoUtil.getConfigFile(fileName).exists()) {
            IOUtils.copy((InputStream)IoUtil.class.getResourceAsStream(IoUtil.getConfigResourcePath(fileName)), (OutputStream)new FileOutputStream(IoUtil.getConfigFile(fileName)));
        }
        return IOUtils.toString((Reader)new FileReader(IoUtil.getConfigFile(fileName)));
    }

    public static String readConfigFile(String fileName) throws IOException {
        return IOUtils.toString((Reader)new FileReader(IoUtil.getConfigFile(fileName)));
    }

    public static String readConfigFileFromClassPath(String fileName) throws IOException {
        return IoUtil.readFileFromClassPath(IoUtil.getConfigResourcePath(fileName));
    }

    public static String getConfigResourcePath(String name) {
        return "/assets/enderio/config/" + name;
    }

    public static File getConfigFile(String name) {
        return new File(Config.configDirectory, name);
    }

    public static String readFileFromClassPath(String fileName) throws IOException {
        InputStream in = IoUtil.class.getResourceAsStream(fileName);
        if (in == null) {
            throw new IOException("Could find resource " + fileName + " in classpath. ");
        }
        return IOUtils.toString((InputStream)in);
    }
}

