/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.opencomputers;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import extracells.15_09_2024__02_32_46.bha;
import extracells.15_09_2024__02_32_46.k\u043ck;
import extracells.15_09_2024__02_32_46.l\u0441m;
import extracells.15_09_2024__02_32_46.t\u043d\u0435;
import extracells.15_09_2024__02_32_46.v\u0441u;
import extracells.15_09_2024__02_32_46.x\u0435\u043e;
import extracells.15_09_2024__02_32_46.\u0435el;
import extracells.15_09_2024__02_32_46.\u0443kf;
import extracells.part.PartFluidExport;
import extracells.part.PartGasExport;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import extracells.util.FluidUtil;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.Block;
import li.cil.oc.api.driver.EnvironmentAware;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import li.cil.oc.server.network.Component;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DriverFluidExportBus
implements Block,
EnvironmentAware {
    public DriverFluidExportBus() {
        DriverFluidExportBus driverFluidExportBus;
    }

    public boolean worksWith(World world, int n, int n2, int n3) {
        return DriverFluidExportBus.getExportBus(world, n, n2, n3, ForgeDirection.UNKNOWN) != null;
    }

    public ManagedEnvironment createEnvironment(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity == null || !(tileEntity instanceof IPartHost)) {
            return null;
        }
        return  .new Enviroment((IPartHost)tileEntity);
    }

    private static PartFluidExport getExportBus(World world, int n, int n2, int n3, ForgeDirection forgeDirection2) {
        ForgeDirection forgeDirection2;
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity == null || !(tileEntity instanceof IPartHost)) {
            return null;
        }
        IPartHost \u000a\u000a\u000a\u000a2 = (IPartHost)tileEntity;
        if (forgeDirection2 == null || forgeDirection2 == ForgeDirection.UNKNOWN) {
            for (ForgeDirection forgeDirection3 : ForgeDirection.VALID_DIRECTIONS) {
                IPart iPart = \u000a\u000a\u000a\u000a2.getPart(forgeDirection3);
                if (iPart == null || !(iPart instanceof PartFluidExport) || iPart instanceof PartGasExport) continue;
                return (PartFluidExport)iPart;
            }
            return null;
        }
        IPart \u000a\u000a\u000a\u000a3 = \u000a\u000a\u000a\u000a2.getPart(forgeDirection2);
        return \u000a\u000a\u000a\u000a3 == null ? null : (\u000a\u000a\u000a\u000a3 instanceof PartGasExport ? null : (PartFluidExport)\u000a\u000a\u000a\u000a3);
    }

    public Class<? extends Environment> providedEnvironment(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.func_77973_b() == ItemEnum.PARTITEM.getItem() && itemStack.func_77960_j() == PartEnum.FLUIDEXPORT.ordinal()) {
            return Enviroment.class;
        }
        return null;
    }

    public class Enviroment
    extends ManagedEnvironment
    implements NamedBlock {
        protected final TileEntity tile;
        protected final IPartHost host;

        public Enviroment(IPartHost iPartHost) {
            
            .tile = (TileEntity)iPartHost;
            
            .host = iPartHost;
            
            .setNode(Network.newNode((Environment)
            , (Visibility)Visibility.Network).withComponent(x\u0435\u043e." dzy").create());
        }

        @Callback(doc="function(side:number, [ slot:number]):table -- Get the configuration of the fluid export bus pointing in the specified direction.")
        public Object[] getFluidExportConfiguration(Context context, Arguments arguments) {
            ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)arguments.checkInteger(0));
            if (forgeDirection == null || forgeDirection == ForgeDirection.UNKNOWN) {
                return new Object[]{null, \u0435el."m x\u0435"};
            }
            PartFluidExport  2 = DriverFluidExportBus.getExportBus( .tile.func_145831_w(),  .tile.field_145851_c,  .tile.field_145848_d,  .tile.field_145849_e, forgeDirection);
            if ( 2 == null) {
                return new Object[]{null, \u0435el."\u0445 fu"};
            }
            int  3 = arguments.optInteger(1, 4);
            try {
                Fluid fluid =  2.filterFluids[ 3];
                if (fluid == null) {
                    return new Object[]{null};
                }
                return new Object[]{new FluidStack(fluid, 1000)};
            }
            catch (Throwable throwable) {
                return new Object[]{null, k\u043ck."mi q"};
            }
        }

        @Callback(doc="function(side:number[, slot:number][, database:address, entry:number]):boolean -- Configure the fluid export bus pointing in the specified direction to export fluid stacks matching the specified descriptor.")
        public Object[] setFluidExportConfiguration(Context context2, Arguments arguments) {
            Enviroment enviroment;
            int  4;
            int  3;
            String string;
            ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)arguments.checkInteger(0));
            if (forgeDirection == null || forgeDirection == ForgeDirection.UNKNOWN) {
                return new Object[]{null, \u0435el."m x\u0435"};
            }
            PartFluidExport  2 = DriverFluidExportBus.getExportBus(enviroment.tile.func_145831_w(), enviroment.tile.field_145851_c, enviroment.tile.field_145848_d, enviroment.tile.field_145849_e, forgeDirection);
            if ( 2 == null) {
                return new Object[]{null, \u0435el."\u0445 fu"};
            }
            if (arguments.count() == 3) {
                string = arguments.checkString(1);
                 3 = arguments.checkInteger(2);
                 4 = 4;
            } else {
                if (arguments.count() < 3) {
                    int n = arguments.optInteger(1, 4);
                    try {
                         2.filterFluids[n] = null;
                         2.onInventoryChanged();
                        context2.pause(0.5);
                        return new Object[]{true};
                    }
                    catch (Throwable  5) {
                        return new Object[]{false, v\u0441u."nr \u043c"};
                    }
                }
                 4 = arguments.optInteger(1, 4);
                string = arguments.checkString(2);
                 3 = arguments.checkInteger(3);
            }
            Node  6 = enviroment.node().network().node(string);
            if ( 6 == null) {
                throw new IllegalArgumentException(t\u043d\u0435." ops");
            }
            if (!( 6 instanceof Component)) {
                throw new IllegalArgumentException(t\u043d\u0435." ops");
            }
            Component  7 = (Component) 6;
            Environment  8 =  6.host();
            if (!( 8 instanceof Database)) {
                throw new IllegalArgumentException(bha."n pa");
            }
            Database  9 = (Database) 8;
            try {
                Context context2;
                ItemStack itemStack =  9.getStackInSlot( 3 - 1);
                if (itemStack == null) {
                     2.filterFluids[ 4] = null;
                } else {
                    FluidStack fluidStack = FluidUtil.getFluidFromContainer(itemStack);
                    if (fluidStack == null || fluidStack.getFluid() == null) {
                        return new Object[]{false, l\u0441m." \u0443\u0443q"};
                    }
                     2.filterFluids[ 4] = fluidStack.getFluid();
                }
                 2.onInventoryChanged();
                context2.pause(0.5);
                return new Object[]{true};
            }
            catch (Throwable throwable) {
                return new Object[]{false, v\u0441u."nr \u043c"};
            }
        }

        @Callback(doc="function(side:number, amount:number):boolean -- Make the fluid export bus facing the specified direction perform a single export operation.")
        public Object[] exportFluid(Context $, Arguments $2) {
            Enviroment $3;
            ForgeDirection $4 = ForgeDirection.getOrientation((int)$2.checkInteger(0));
            if ($4 == null || $4 == ForgeDirection.UNKNOWN) {
                return new Object[]{false, \u0435el."m x\u0435"};
            }
            PartFluidExport $5 = DriverFluidExportBus.getExportBus($3.tile.func_145831_w(), $3.tile.field_145851_c, $3.tile.field_145848_d, $3.tile.field_145849_e, $4);
            if ($5 == null) {
                return new Object[]{false, \u0435el."\u0445 fu"};
            }
            if ($5.getFacingTank() == null) {
                return new Object[]{false, \u0443kf."v g\u0443"};
            }
            int $6 = Math.min($2.optInteger(1, 625), 125 + $5.getSpeedState() * 125);
            boolean $7 = $5.doWork($6, 1);
            if ($7) {
                $.pause(0.25);
            }
            return new Object[]{$7};
        }

        public String preferredName() {
            return x\u0435\u043e." dzy";
        }

        public int priority() {
            return 2;
        }
    }
}

