/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.part;

import appeng.api.config.RedstoneMode;
import extracells.gui.GuiFluidEmitter;
import extracells.network.AbstractPacket;
import extracells.part.PartFluidLevelEmitter;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class PacketFluidEmitter
extends AbstractPacket {
    private long wantedAmount;
    private PartFluidLevelEmitter part;
    private RedstoneMode redstoneMode;
    private boolean toggle;

    public PacketFluidEmitter() {
        PacketFluidEmitter packetFluidEmitter;
    }

    public PacketFluidEmitter(boolean bl, PartFluidLevelEmitter partFluidLevelEmitter, EntityPlayer entityPlayer) {
         .mode = (byte)3;
         .toggle = bl;
         .part = partFluidLevelEmitter;
         .player = entityPlayer;
    }

    public PacketFluidEmitter(int n, PartFluidLevelEmitter partFluidLevelEmitter, EntityPlayer entityPlayer) {
         .mode = 0;
         .wantedAmount = n;
         .part = partFluidLevelEmitter;
         .player = entityPlayer;
    }

    public PacketFluidEmitter(long l, EntityPlayer entityPlayer) {
         .mode = (byte)2;
         .wantedAmount = l;
         .player = entityPlayer;
    }

    public PacketFluidEmitter(RedstoneMode redstoneMode, EntityPlayer entityPlayer) {
         .mode = (byte)4;
         .redstoneMode = redstoneMode;
         .player = entityPlayer;
    }

    public PacketFluidEmitter(String string, PartFluidLevelEmitter partFluidLevelEmitter, EntityPlayer entityPlayer) {
         .mode = 1;
         .wantedAmount = string.isEmpty() ? 0L : Long.parseLong(string);
         .part = partFluidLevelEmitter;
         .player = entityPlayer;
    }

    @Override
    public void execute() {
        PacketFluidEmitter packetFluidEmitter;
        switch (packetFluidEmitter.mode) {
            case 0: {
                packetFluidEmitter.part.changeWantedAmount((int)packetFluidEmitter.wantedAmount, packetFluidEmitter.player);
                break;
            }
            case 1: {
                packetFluidEmitter.part.setWantedAmount(packetFluidEmitter.wantedAmount, packetFluidEmitter.player);
                break;
            }
            case 2: {
                if (packetFluidEmitter.player == null || !packetFluidEmitter.player.func_70613_aW() || !((  = Minecraft.func_71410_x().field_71462_r) instanceof GuiFluidEmitter)) break;
                ((GuiFluidEmitter) ).setAmountField(packetFluidEmitter.wantedAmount);
                break;
            }
            case 3: {
                if (packetFluidEmitter.toggle) {
                    packetFluidEmitter.part.toggleMode(packetFluidEmitter.player);
                    break;
                }
                packetFluidEmitter.part.syncClientGui(packetFluidEmitter.player);
                break;
            }
            case 4: {
                if (packetFluidEmitter.player == null || !packetFluidEmitter.player.func_70613_aW() || !((  = Minecraft.func_71410_x().field_71462_r) instanceof GuiFluidEmitter)) break;
                ((GuiFluidEmitter) ).setRedstoneMode(packetFluidEmitter.redstoneMode);
            }
        }
    }

    @Override
    public void readData(ByteBuf byteBuf) {
        switch ( .mode) {
            case 0: {
                 .wantedAmount = byteBuf.readLong();
                 .part = (PartFluidLevelEmitter)PacketFluidEmitter.readPart(byteBuf);
                break;
            }
            case 1: {
                 .wantedAmount = byteBuf.readLong();
                 .part = (PartFluidLevelEmitter)PacketFluidEmitter.readPart(byteBuf);
                break;
            }
            case 2: {
                 .wantedAmount = byteBuf.readLong();
                break;
            }
            case 3: {
                 .toggle = byteBuf.readBoolean();
                 .part = (PartFluidLevelEmitter)PacketFluidEmitter.readPart(byteBuf);
                break;
            }
            case 4: {
                 .redstoneMode = RedstoneMode.values()[byteBuf.readInt()];
            }
        }
    }

    @Override
    public void writeData(ByteBuf byteBuf) {
        switch ( .mode) {
            case 0: {
                byteBuf.writeLong( .wantedAmount);
                if (!Minecraft.func_71410_x().func_71356_B()) break;
                PacketFluidEmitter.writePart( .part, byteBuf);
                break;
            }
            case 1: {
                byteBuf.writeLong( .wantedAmount);
                if (!Minecraft.func_71410_x().func_71356_B()) break;
                PacketFluidEmitter.writePart( .part, byteBuf);
                break;
            }
            case 2: {
                byteBuf.writeLong( .wantedAmount);
                break;
            }
            case 3: {
                if (!Minecraft.func_71410_x().func_71356_B()) break;
                byteBuf.writeBoolean( .toggle);
                PacketFluidEmitter.writePart( .part, byteBuf);
                break;
            }
            case 4: {
                byteBuf.writeInt( .redstoneMode.ordinal());
            }
        }
    }
}

