/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.part;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEFluidStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerFluidTerminal;
import extracells.container.ContainerGasTerminal;
import extracells.gui.GuiFluidTerminal;
import extracells.gui.GuiGasTerminal;
import extracells.integration.Integration;
import extracells.network.AbstractPacket;
import extracells.part.PartFluidTerminal;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PacketFluidTerminal
extends AbstractPacket {
    IItemList<IAEFluidStack> fluidStackList;
    Fluid currentFluid;
    PartFluidTerminal terminalFluid;
    IAEFluidStack fluidDiff;

    public PacketFluidTerminal() {
        PacketFluidTerminal packetFluidTerminal;
    }

    public PacketFluidTerminal(EntityPlayer entityPlayer, Fluid fluid) {
        super(entityPlayer);
         .mode = (byte)2;
         .currentFluid = fluid;
    }

    public PacketFluidTerminal(EntityPlayer entityPlayer, Fluid fluid, PartFluidTerminal partFluidTerminal) {
        super(entityPlayer);
         .mode = 1;
         .currentFluid = fluid;
         .terminalFluid = partFluidTerminal;
    }

    public PacketFluidTerminal(EntityPlayer entityPlayer, IItemList<IAEFluidStack> iItemList) {
        super(entityPlayer);
         .mode = 0;
         .fluidStackList = iItemList;
    }

    public PacketFluidTerminal(EntityPlayer entityPlayer, PartFluidTerminal partFluidTerminal) {
        super(entityPlayer);
         .mode = (byte)3;
         .terminalFluid = partFluidTerminal;
    }

    @Override
    public void execute() {
        PacketFluidTerminal packetFluidTerminal;
        switch (packetFluidTerminal.mode) {
            case 0: {
                packetFluidTerminal.case0();
                break;
            }
            case 1: {
                packetFluidTerminal.terminalFluid.setCurrentFluid(packetFluidTerminal.currentFluid);
                break;
            }
            case 2: {
                packetFluidTerminal.case2();
                break;
            }
            case 3: {
                if (packetFluidTerminal.player != null && packetFluidTerminal.player.field_71070_bA instanceof ContainerFluidTerminal) {
                    ContainerFluidTerminal containerFluidTerminal = (ContainerFluidTerminal)packetFluidTerminal.player.field_71070_bA;
                    containerFluidTerminal.forceFluidUpdate();
                    packetFluidTerminal.terminalFluid.sendCurrentFluid(containerFluidTerminal);
                    break;
                }
                if (packetFluidTerminal.player == null || !Integration.Mods.MEKANISMGAS.isEnabled() || !(packetFluidTerminal.player.field_71070_bA instanceof ContainerGasTerminal)) break;
                ContainerGasTerminal  2 = (ContainerGasTerminal)packetFluidTerminal.player.field_71070_bA;
                 2.forceFluidUpdate();
                packetFluidTerminal.terminalFluid.sendCurrentFluid( 2);
                break;
            }
            case 4: {
                if (packetFluidTerminal.fluidDiff == null || Minecraft.func_71410_x().field_71439_g == null) break;
                if (Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerFluidTerminal) {
                    ContainerFluidTerminal containerFluidTerminal = (ContainerFluidTerminal)Minecraft.func_71410_x().field_71439_g.field_71070_bA;
                    IItemList<IAEFluidStack>  3 = containerFluidTerminal.getFluidStackList();
                     3.add((IAEStack)packetFluidTerminal.fluidDiff);
                    containerFluidTerminal.updateFluidList( 3);
                    break;
                }
                if (!Integration.Mods.MEKANISMGAS.isEnabled() || !(Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerGasTerminal)) break;
                ContainerGasTerminal containerGasTerminal = (ContainerGasTerminal)Minecraft.func_71410_x().field_71439_g.field_71070_bA;
                IItemList<IAEFluidStack>  4 = containerGasTerminal.getFluidStackList();
                 4.add((IAEStack)packetFluidTerminal.fluidDiff);
                containerGasTerminal.updateFluidList( 4);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void case0() {
        PacketFluidTerminal packetFluidTerminal;
        if (packetFluidTerminal.player != null && packetFluidTerminal.player.func_70613_aW()) {
            GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
            if (guiScreen instanceof GuiFluidTerminal) {
                ContainerFluidTerminal containerFluidTerminal = (ContainerFluidTerminal)((GuiFluidTerminal)guiScreen).field_147002_h;
                containerFluidTerminal.updateFluidList(packetFluidTerminal.fluidStackList);
            } else if (guiScreen instanceof GuiGasTerminal) {
                ContainerGasTerminal containerGasTerminal = (ContainerGasTerminal)((GuiGasTerminal)guiScreen).field_147002_h;
                containerGasTerminal.updateFluidList(packetFluidTerminal.fluidStackList);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void case2() {
        PacketFluidTerminal packetFluidTerminal;
        if (packetFluidTerminal.player != null && Minecraft.func_71410_x().field_71462_r instanceof GuiFluidTerminal) {
            GuiFluidTerminal guiFluidTerminal = (GuiFluidTerminal)Minecraft.func_71410_x().field_71462_r;
            ((ContainerFluidTerminal)guiFluidTerminal.getContainer()).receiveSelectedFluid(packetFluidTerminal.currentFluid);
        } else if (packetFluidTerminal.player != null && Minecraft.func_71410_x().field_71462_r instanceof GuiGasTerminal) {
            GuiGasTerminal guiGasTerminal = (GuiGasTerminal)Minecraft.func_71410_x().field_71462_r;
            ((ContainerGasTerminal)guiGasTerminal.getContainer()).receiveSelectedFluid(packetFluidTerminal.currentFluid);
        }
    }

    @Override
    public void readData(ByteBuf byteBuf) {
        switch (\u000a\u000a\u000a
        .mode) {
            case 0: {
                \u000a\u000a\u000a
                .fluidStackList = AEApi.instance().storage().createFluidList();
                while (byteBuf.readableBytes() > 0) {
                    Fluid fluid = PacketFluidTerminal.readFluid(byteBuf);
                    long \u000a\u000a\u000a\u000a2 = byteBuf.readLong();
                    boolean \u000a\u000a\u000a\u000a3 = byteBuf.readBoolean();
                    if (fluid == null || \u000a\u000a\u000a\u000a2 < 0L) continue;
                    IAEFluidStack \u000a\u000a\u000a\u000a4 = AEApi.instance().storage().createFluidStack(new FluidStack(fluid, 1));
                    \u000a\u000a\u000a\u000a4.setStackSize(\u000a\u000a\u000a\u000a2);
                    \u000a\u000a\u000a\u000a4.setCraftable(\u000a\u000a\u000a\u000a3);
                    \u000a\u000a\u000a
                    .fluidStackList.add((IAEStack)\u000a\u000a\u000a\u000a4);
                }
                break;
            }
            case 1: {
                \u000a\u000a\u000a
                .terminalFluid = (PartFluidTerminal)PacketFluidTerminal.readPart(byteBuf);
                \u000a\u000a\u000a
                .currentFluid = PacketFluidTerminal.readFluid(byteBuf);
                break;
            }
            case 2: {
                \u000a\u000a\u000a
                .currentFluid = PacketFluidTerminal.readFluid(byteBuf);
                break;
            }
            case 3: {
                \u000a\u000a\u000a
                .terminalFluid = (PartFluidTerminal)PacketFluidTerminal.readPart(byteBuf);
                break;
            }
            case 4: {
                \u000a\u000a\u000a
                .fluidDiff = (IAEFluidStack)AEFluidStack.create((Object)new FluidStack(PacketFluidTerminal.readFluid(byteBuf), 1)).setStackSize(byteBuf.readLong());
            }
        }
    }

    @Override
    public void writeData(ByteBuf byteBuf) {
        switch (packetFluidTerminal.mode) {
            case 0: {
                for (IAEFluidStack iAEFluidStack : packetFluidTerminal.fluidStackList) {
                    FluidStack fluidStack = iAEFluidStack.getFluidStack();
                    PacketFluidTerminal.writeFluid(fluidStack.getFluid(), byteBuf);
                    byteBuf.writeLong((long)fluidStack.amount);
                    byteBuf.writeBoolean(iAEFluidStack.isCraftable());
                }
                break;
            }
            case 1: {
                PacketFluidTerminal packetFluidTerminal;
                if (Minecraft.func_71410_x().func_71356_B()) {
                    PacketFluidTerminal.writePart(packetFluidTerminal.terminalFluid, byteBuf);
                }
                PacketFluidTerminal.writeFluid(packetFluidTerminal.currentFluid, byteBuf);
                break;
            }
            case 2: {
                PacketFluidTerminal packetFluidTerminal;
                PacketFluidTerminal.writeFluid(packetFluidTerminal.currentFluid, byteBuf);
                break;
            }
            case 3: {
                PacketFluidTerminal packetFluidTerminal;
                PacketFluidTerminal.writePart(packetFluidTerminal.terminalFluid, byteBuf);
            }
        }
    }
}

