/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.p\u043c\u0440;
import extracells.15_09_2024__02_32_46.wso;
import extracells.container.ContainerDrive;
import extracells.gui.GuiDrive;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.PermissionUtil;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class PartDrive
extends PartECBase
implements ICellContainer,
IInventoryUpdateReceiver {
    private int priority = 0;
    private short[] blinkTimers;
    private byte[] cellStatuses = new byte[6];
    List<IMEInventoryHandler> fluidHandlers = new ArrayList<IMEInventoryHandler>();
    List<IMEInventoryHandler> itemHandlers = new ArrayList<IMEInventoryHandler>();
    private ECPrivateInventory inventory;

    public PartDrive() {
        PartDrive $;
        $.inventory = new ECPrivateInventory(wso." \u043csi", 6, 1, $){
            ICellRegistry cellRegistry;
            {
                1 $6;
                super($2, $3, $4, $5);
                $6.cellRegistry = AEApi.instance().registries().cell();
            }

            @Override
            public boolean func_94041_b(int n, ItemStack itemStack) {
                return \u000a\u000a\u000a\u000a
                .cellRegistry.isCellHandled(itemStack);
            }
        };
    }

    @Override
    public void addToWorld() {
        PartDrive partDrive;
        super.addToWorld();
        partDrive.onInventoryChanged();
    }

    public void blinkCell(int $) {
        PartDrive $2;
        if ($ > 0 && $ < $2.blinkTimers.length) {
            $2.blinkTimers[$] = 15;
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 2;
    }

    @Override
    public void getBoxes(IPartCollisionHelper iPartCollisionHelper) {
        iPartCollisionHelper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        iPartCollisionHelper.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel storageChannel) {
        if (! .isActive()) {
            return new ArrayList<IMEInventoryHandler>();
        }
        return storageChannel == StorageChannel.ITEMS ?  .itemHandlers :  .fluidHandlers;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer entityPlayer) {
        return new GuiDrive($ , entityPlayer);
    }

    public int getColorByStatus(int n) {
        switch (n) {
            case 1: {
                return 65280;
            }
            case 2: {
                return 0xFFFF00;
            }
            case 3: {
                return 0xFF0000;
            }
        }
        return 0;
    }

    @Override
    public void getDrops(List<ItemStack> list, boolean bl) {
        if (!bl) {
            for (int i = 0; i <  .inventory.func_70302_i_(); ++i) {
                ItemStack itemStack =  .inventory.func_70301_a(i);
                if (itemStack == null) continue;
                list.add(itemStack);
            }
        }
    }

    public ECPrivateInventory getInventory() {
        PartDrive partDrive;
        return partDrive.inventory;
    }

    public int getPriority() {
        PartDrive partDrive;
        return partDrive.priority;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer entityPlayer) {
        return new ContainerDrive( , entityPlayer);
    }

    @Override
    public boolean onActivate(EntityPlayer entityPlayer, Vec3 vec3) {
        if (entityPlayer.field_70170_p.field_72995_K) {
            return true;
        }
        if (PermissionUtil.hasPermission(entityPlayer, SecurityPermissions.BUILD, \u000a\u000a\u000a
        )) {
            return super.onActivate(entityPlayer, vec3);
        }
        return false;
    }

    @Override
    public void onInventoryChanged() {
        ItemStack itemStack;
        PartDrive partDrive;
        partDrive.itemHandlers = partDrive.updateHandlers(StorageChannel.ITEMS);
        partDrive.fluidHandlers = partDrive.updateHandlers(StorageChannel.FLUIDS);
        for (int i = 0; i < partDrive.cellStatuses.length; ++i) {
            itemStack = partDrive.inventory.func_70301_a(i);
            IMEInventoryHandler  2 = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.ITEMS);
            if ( 2 == null) {
                 2 = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.FLUIDS);
            }
            partDrive.cellStatuses[i] = (  = AEApi.instance().registries().cell().getHandler(itemStack)) == null ||  2 == null ? (byte)0 : (byte) .getStatusForCell(itemStack, (IMEInventory) 2);
        }
        IGridNode iGridNode = partDrive.getGridNode();
        if (iGridNode != null) {
            itemStack = iGridNode.getGrid();
            if (itemStack != null) {
                itemStack.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            partDrive.getHost().markForUpdate();
        }
        partDrive.saveData();
    }

    @MENetworkEventSubscribe
    public void powerChange(MENetworkPowerStatusChange mENetworkPowerStatusChange) {
        IGridNode iGridNode =  .getGridNode();
        if (iGridNode != null && (  = iGridNode.isActive()) !=  .isActive()) {
             .setActive( );
             .onNeighborChanged();
             .getHost().markForUpdate();
        }
        iGridNode.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
         .inventory.readFromNBT(nBTTagCompound.func_150295_c(p\u043c\u0440." elh", 10));
         .onInventoryChanged();
    }

    @Override
    public boolean readFromStream(ByteBuf byteBuf) throws IOException {
        super.readFromStream(byteBuf);
        for (int i = 0; i < \u000a\u000a\u000a
        .cellStatuses.length; ++i) {
            \u000a\u000a\u000a
            .cellStatuses[i] = byteBuf.readByte();
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        IIcon iIcon = TextureManager.DRIVE_SIDE.getTexture();
        IIcon[] \u000a2 = TextureManager.DRIVE_FRONT.getTextures();
        iPartRenderHelper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 15.999f);
        iPartRenderHelper.renderInventoryFace(\u000a2[3], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        iPartRenderHelper.setTexture(iIcon, iIcon, iIcon, \u000a2[0], iIcon, iIcon);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
        iPartRenderHelper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        
        .renderInventoryBusLights(iPartRenderHelper, renderBlocks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int n, int n2, int n3, IPartRenderHelper iPartRenderHelper2, RenderBlocks renderBlocks) {
        IPartRenderHelper iPartRenderHelper2;
        int n4;
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon  2 = TextureManager.DRIVE_SIDE.getTexture();
        IIcon[]  3 = TextureManager.DRIVE_FRONT.getTextures();
        iPartRenderHelper2.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 15.999f);
        iPartRenderHelper2.renderFace(n, n2, n3,  3[3], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper2.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        iPartRenderHelper2.setTexture( 2,  2,  2,  3[0],  2,  2);
        iPartRenderHelper2.renderBlock(n, n2, n3, renderBlocks);
        tessellator.func_78378_d(0xFFFFFF);
        for (n4 = 0; n4 < 2; ++n4) {
            for (  = 0;   < 3; ++ ) {
                if ( .cellStatuses[  + n4 * 3] <= 0) continue;
                if ( .getSide() == ForgeDirection.EAST ||  .getSide() == ForgeDirection.WEST ? n4 == 1 : n4 == 0) {
                    iPartRenderHelper2.setBounds(8.0f, (float)(12 -   * 3), 14.0f, 13.0f, (float)(10 -   * 3), 16.0f);
                } else {
                    iPartRenderHelper2.setBounds(3.0f, (float)(12 -   * 3), 14.0f, 8.0f, (float)(10 -   * 3), 16.0f);
                }
                iPartRenderHelper2.renderFace(n, n2, n3,  3[1], ForgeDirection.SOUTH, renderBlocks);
            }
        }
        for (n4 = 0; n4 < 2; ++n4) {
            for (  = 0;   < 3; ++ ) {
                if ( .getSide() == ForgeDirection.EAST ||  .getSide() == ForgeDirection.WEST ? n4 == 1 : n4 == 0) {
                    iPartRenderHelper2.setBounds(8.0f, (float)(12 -   * 3), 14.0f, 13.0f, (float)(10 -   * 3), 16.0f);
                } else {
                    iPartRenderHelper2.setBounds(3.0f, (float)(12 -   * 3), 14.0f, 8.0f, (float)(10 -   * 3), 16.0f);
                }
                tessellator.func_78378_d( .getColorByStatus( .cellStatuses[  + n4 * 3]));
                tessellator.func_78380_c(0xD000D0);
                iPartRenderHelper2.renderFace(n, n2, n3,  3[2], ForgeDirection.SOUTH, renderBlocks);
            }
        }
        iPartRenderHelper2.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
         .renderStaticBusLights(n, n2, n3, iPartRenderHelper2, renderBlocks);
    }

    public void saveChanges(IMEInventory iMEInventory) {
         .getHost().markForSave();
    }

    @Override
    public void setPartHostInfo(ForgeDirection forgeDirection, IPartHost iPartHost, TileEntity tileEntity) {
        super.setPartHostInfo(forgeDirection, iPartHost, tileEntity);
        \u000a\u000a\u000a
        .onInventoryChanged();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged mENetworkChannelsChanged) {
        IGridNode iGridNode =  .getGridNode();
        if (iGridNode != null && (  = iGridNode.isActive()) !=  .isActive()) {
             .setActive( );
             .onNeighborChanged();
             .getHost().markForUpdate();
        }
        iGridNode.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    private List<IMEInventoryHandler> updateHandlers(StorageChannel $) {
        PartDrive $2;
        ICellRegistry $3 = AEApi.instance().registries().cell();
        ArrayList<IMEInventoryHandler> $4 = new ArrayList<IMEInventoryHandler>();
        for (int $5 = 0; $5 < $2.inventory.func_70302_i_(); ++$5) {
            IMEInventoryHandler $6;
            ItemStack $7 = $2.inventory.func_70301_a($5);
            if (!$3.isCellHandled($7) || ($6 = $3.getCellInventory($7, null, $)) == null) continue;
            $4.add($6);
        }
        return $4;
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        nBTTagCompound.func_74782_a(p\u043c\u0440." elh", (NBTBase)\u000a\u000a
        .inventory.writeToNBT());
    }

    @Override
    public void writeToStream(ByteBuf byteBuf) throws IOException {
        super.writeToStream(byteBuf);
        for (byte by :  .cellStatuses) {
            byteBuf.writeByte((int)by);
        }
    }
}

