/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.bha;
import extracells.15_09_2024__02_32_46.emp;
import extracells.15_09_2024__02_32_46.ewc;
import extracells.15_09_2024__02_32_46.ldx;
import extracells.15_09_2024__02_32_46.lt;
import extracells.15_09_2024__02_32_46.l\u043c\u043e;
import extracells.15_09_2024__02_32_46.l\u0441m;
import extracells.15_09_2024__02_32_46.med;
import extracells.15_09_2024__02_32_46.p\u043c\u0440;
import extracells.15_09_2024__02_32_46.rj\u043e;
import extracells.15_09_2024__02_32_46.sfb;
import extracells.15_09_2024__02_32_46.s\u043c\u0435;
import extracells.15_09_2024__02_32_46.tcx;
import extracells.15_09_2024__02_32_46.t\u0441g;
import extracells.15_09_2024__02_32_46.v\u0441u;
import extracells.15_09_2024__02_32_46.xll;
import extracells.15_09_2024__02_32_46.x\u0445;
import extracells.15_09_2024__02_32_46.y\u0435h;
import extracells.15_09_2024__02_32_46.zwn;
import extracells.15_09_2024__02_32_46.\u0435hv;
import extracells.15_09_2024__02_32_46.\u0435\u0445\u043c;
import extracells.15_09_2024__02_32_46.\u0441dc;
import extracells.15_09_2024__02_32_46.\u0441ud;
import extracells.15_09_2024__02_32_46.\u0443kg;
import extracells.api.IFluidInterface;
import extracells.api.crafting.IFluidCraftingPatternDetails;
import extracells.container.ContainerFluidInterface;
import extracells.container.IContainerListener;
import extracells.crafting.CraftingPattern;
import extracells.crafting.CraftingPattern2;
import extracells.gui.GuiFluidInterface;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.part.PartECBase;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import extracells.render.TextureManager;
import extracells.util.EmptyMeItemMonitor;
import extracells.util.ItemUtils;
import extracells.util.PermissionUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class PartFluidInterface
extends PartECBase
implements IFluidHandler,
IFluidInterface,
IFluidSlotPartOrBlock,
ITileStorageMonitorable,
IStorageMonitorable,
IGridTickable,
ICraftingProvider {
    List<IContainerListener> listeners = new ArrayList<IContainerListener>();
    private List<ICraftingPatternDetails> patternHandlers = new ArrayList<ICraftingPatternDetails>();
    private HashMap<ICraftingPatternDetails, IFluidCraftingPatternDetails> patternConvert = new HashMap();
    private List<IAEItemStack> requestedItems = new ArrayList<IAEItemStack>();
    private List<IAEItemStack> removeList = new ArrayList<IAEItemStack>();
    public final FluidInterfaceInventory inventory;
    private boolean update;
    private List<IAEStack> export;
    private List<IAEStack> removeFromExport;
    private List<IAEStack> addToExport;
    private IAEItemStack toExport;
    private final Item encodedPattern;
    private FluidTank tank;
    private int fluidFilter;
    public boolean doNextUpdate;
    private boolean needBreake;
    private int tickCount;

    public PartFluidInterface() {
        PartFluidInterface partFluidInterface;
        partFluidInterface.inventory = partFluidInterface.new FluidInterfaceInventory();
        partFluidInterface.update = false;
        partFluidInterface.export = new ArrayList<IAEStack>();
        partFluidInterface.removeFromExport = new ArrayList<IAEStack>();
        partFluidInterface.addToExport = new ArrayList<IAEStack>();
        partFluidInterface.toExport = null;
        partFluidInterface.encodedPattern = (Item)AEApi.instance().definitions().items().encodedPattern().maybeItem().orNull();
        partFluidInterface.tank = new FluidTank(10000){

            public FluidTank readFromNBT(NBTTagCompound nBTTagCompound) {
                1  ;
                if (!nBTTagCompound.func_74764_b(\u0435hv." \u0443bc")) {
                    FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound);
                     .setFluid(fluidStack);
                } else {
                     .setFluid(null);
                }
                return  ;
            }
        };
        partFluidInterface.fluidFilter = -1;
        partFluidInterface.doNextUpdate = false;
        partFluidInterface.needBreake = false;
        partFluidInterface.tickCount = 0;
    }

    @Override
    public int cableConnectionRenderTo() {
        return 3;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        FluidStack fluidStack =  .tank.getFluid();
        return fluidStack != null && fluidStack.getFluid() == fluid;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return  .tank.fill(new FluidStack(fluid, 1), false) > 0;
    }

    public FluidStack drain(ForgeDirection $, FluidStack $2, boolean $3) {
        PartFluidInterface $4;
        FluidStack $5 = $4.tank.getFluid();
        if ($2 == null || $5 == null || $5.getFluid() != $2.getFluid()) {
            return null;
        }
        return $4.drain($, $2.amount, $3);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        FluidStack fluidStack = \u000a
        .tank.drain(n, bl);
        if (fluidStack != null) {
            \u000a
            .getHost().markForUpdate();
        }
        \u000a
        .doNextUpdate = true;
        return fluidStack;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null) {
            return 0;
        }
        if (( .tank.getFluid() == null ||  .tank.getFluid().getFluid() == fluidStack.getFluid()) && fluidStack.getFluid() == FluidRegistry.getFluid((int) .fluidFilter)) {
            int n =  .tank.fill(fluidStack.copy(), bl);
            if (n == fluidStack.amount) {
                 .doNextUpdate = true;
                return n;
            }
            n +=  .fillToNetwork(new FluidStack(fluidStack.getFluid(), fluidStack.amount - n), bl);
             .doNextUpdate = true;
            return n;
        }
        int n = 0;
        if ((n +=  .fillToNetwork(fluidStack, bl)) < fluidStack.amount) {
            n +=  .tank.fill(new FluidStack(fluidStack.getFluid(), fluidStack.amount - n), bl);
        }
        if (n > 0) {
             .getHost().markForUpdate();
        }
         .doNextUpdate = true;
        return n;
    }

    public int fillToNetwork(FluidStack fluidStack, boolean bl) {
        IGridNode iGridNode =  .getGridNode(ForgeDirection.UNKNOWN);
        if (iGridNode == null || fluidStack == null) {
            return 0;
        }
        IGrid  2 = iGridNode.getGrid();
        if ( 2 == null) {
            return 0;
        }
        IStorageGrid  3 = (IStorageGrid) 2.getCache(IStorageGrid.class);
        if ( 3 == null) {
            return 0;
        }
        FluidStack  4 = fluidStack.copy();
        IAEFluidStack  5 = bl ? (IAEFluidStack) 3.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(fluidStack), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost) )) : (IAEFluidStack) 3.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(fluidStack), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost) ));
        if ( 5 == null) {
            return fluidStack.amount;
        }
        return (int)((long)fluidStack.amount -  5.getStackSize());
    }

    private void forceUpdate() {
        PartFluidInterface partFluidInterface;
        partFluidInterface.getHost().markForUpdate();
        for (IContainerListener iContainerListener : partFluidInterface.listeners) {
            if (iContainerListener == null) continue;
            iContainerListener.updateContainer();
        }
        partFluidInterface.doNextUpdate = false;
    }

    @Override
    public void getBoxes(IPartCollisionHelper iPartCollisionHelper) {
        iPartCollisionHelper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        iPartCollisionHelper.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer $) {
        PartFluidInterface $2;
        return new GuiFluidInterface($, $2, $2.getSide());
    }

    @SideOnly(value=Side.CLIENT)
    private World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void getDrops(List<ItemStack> list, boolean bl) {
        for (int i = 0; i <  .inventory.func_70302_i_(); ++i) {
            ItemStack itemStack =  .inventory.func_70301_a(i);
            if (itemStack == null) continue;
            list.add(itemStack);
        }
    }

    @Override
    public Fluid getFilter(ForgeDirection forgeDirection) {
        return FluidRegistry.getFluid((int) .fluidFilter);
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        PartFluidInterface partFluidInterface;
        if (partFluidInterface.getGridNode(ForgeDirection.UNKNOWN) == null) {
            return null;
        }
        IGrid  2 = partFluidInterface.getGridNode(ForgeDirection.UNKNOWN).getGrid();
        if ( 2 == null) {
            return null;
        }
        IStorageGrid  3 = (IStorageGrid) 2.getCache(IStorageGrid.class);
        if ( 3 == null) {
            return null;
        }
        return  3.getFluidInventory();
    }

    @Override
    public IFluidTank getFluidTank(ForgeDirection forgeDirection) {
        return  .tank;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return new EmptyMeItemMonitor();
    }

    @Override
    public ItemStack getItemStack(PartItemStack partItemStack) {
        ItemStack itemStack = new ItemStack(ItemEnum.PARTITEM.getItem(), 1, PartEnum.getPartID( ));
        if (partItemStack != PartItemStack.Break) {
            itemStack.func_77982_d( .writeFilter(new NBTTagCompound()));
        }
        return itemStack;
    }

    public IStorageMonitorable getMonitorable(ForgeDirection forgeDirection, BaseActionSource baseActionSource) {
        return \u000a\u000a\u000a\u000a\u000a ;
    }

    @Override
    public IInventory getPatternInventory() {
        PartFluidInterface partFluidInterface;
        return partFluidInterface.inventory;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer entityPlayer) {
        return new ContainerFluidInterface(entityPlayer,  );
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{ .tank.getInfo()};
    }

    public TickingRequest getTickingRequest(IGridNode $) {
        return new TickingRequest(1, 40, false, false);
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound nBTTagCompound, List<String> list) {
        FluidStack fluidStack = null;
        int  2 = -1;
        int  3 = 0;
        if (nBTTagCompound.func_74764_b(xll."b vd") && nBTTagCompound.func_74764_b(ldx." qrj")) {
             2 = nBTTagCompound.func_74762_e(xll."b vd");
             3 = nBTTagCompound.func_74762_e(ldx." qrj");
        }
        if ( 2 != -1) {
            fluidStack = new FluidStack( 2,  3);
        }
        if (fluidStack == null) {
            list.add(StatCollector.func_74838_a((String)\u0435\u0445\u043c."y g\u0435") + v\u0441u." cxe" + StatCollector.func_74838_a((String)y\u0435h." c\u043e\u0430"));
            list.add(StatCollector.func_74838_a((String)l\u0441m." tji") + s\u043c\u0435."g\u0430 h");
        } else {
            list.add(StatCollector.func_74838_a((String)\u0435\u0445\u043c."y g\u0435") + v\u0441u." cxe" + fluidStack.getLocalizedName());
            list.add(StatCollector.func_74838_a((String)l\u0441m." tji") + v\u0441u." cxe" + fluidStack.amount + ewc."j ao");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound $) {
        PartFluidInterface $2;
        if ($2.tank.getFluid() == null || $2.tank.getFluid().getFluid() == null) {
            $.func_74768_a(xll."b vd", -1);
        } else {
            $.func_74768_a(xll."b vd", $2.tank.getFluid().getFluidID());
        }
        $.func_74768_a(ldx." qrj", $2.tank.getFluidAmount());
        return $;
    }

    @Override
    public void initializePart(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            \u000a\u000a
            .readFilter(itemStack.func_77978_p());
        }
    }

    public boolean isBusy() {
        PartFluidInterface partFluidInterface;
        return !partFluidInterface.export.isEmpty();
    }

    private ItemStack makeCraftingPatternItem(ICraftingPatternDetails iCraftingPatternDetails2) {
        ICraftingPatternDetails iCraftingPatternDetails2;
        if (iCraftingPatternDetails2 == null) {
            return null;
        }
        NBTTagList nBTTagList = new NBTTagList();
          = new NBTTagList();
        for (IAEItemStack  2 : iCraftingPatternDetails2.getInputs()) {
            if ( 2 == null) {
                nBTTagList.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            nBTTagList.func_74742_a((NBTBase) 2.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        for (IAEItemStack  2 : iCraftingPatternDetails2.getOutputs()) {
            if ( 2 == null) {
                 .func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
             .func_74742_a((NBTBase) 2.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74782_a(tcx." fhu", (NBTBase)nBTTagList);
        nBTTagCompound.func_74782_a(tcx."\u043c nu", (NBTBase) );
        nBTTagCompound.func_74757_a(rj\u043e."w yu", iCraftingPatternDetails2.isCraftable());
        ItemStack  3 = new ItemStack( .encodedPattern);
         3.func_77982_d(nBTTagCompound);
        return  3;
    }

    @Override
    public boolean onActivate(EntityPlayer entityPlayer, Vec3 vec3) {
        if (entityPlayer.field_70170_p.field_72995_K) {
            return true;
        }
        if (PermissionUtil.hasPermission(entityPlayer, SecurityPermissions.BUILD, \u000a\u000a\u000a )) {
            return super.onActivate(entityPlayer, vec3);
        }
        return false;
    }

    public void provideCrafting(ICraftingProviderHelper iCraftingProviderHelper) {
        \u000a\u000a\u000a
        .patternHandlers = new ArrayList<ICraftingPatternDetails>();
        \u000a\u000a\u000a
        .patternConvert.clear();
        for (ItemStack itemStack : \u000a\u000a\u000a
        .inventory.inv) {
            if (itemStack == null || itemStack.func_77973_b() == null || !(itemStack.func_77973_b() instanceof ICraftingPatternItem) || (\u000a\u000a\u000a
             = (ICraftingPatternItem)itemStack.func_77973_b()) == null || \u000a\u000a\u000a
            .getPatternForItem(itemStack, \u000a\u000a\u000a
            .getGridNode().getWorld()) == null) continue;
            CraftingPattern2 craftingPattern2 = new CraftingPattern2(\u000a\u000a\u000a
            .getPatternForItem(itemStack, \u000a\u000a\u000a
            .getGridNode().getWorld()));
            \u000a\u000a\u000a
            .patternHandlers.add(craftingPattern2);
            ItemStack \u000a\u000a\u000a\u000a2 = \u000a\u000a\u000a
            .makeCraftingPatternItem(craftingPattern2);
            if (\u000a\u000a\u000a\u000a2 == null) continue;
            ICraftingPatternDetails \u000a\u000a\u000a\u000a3 = ((ICraftingPatternItem)\u000a\u000a\u000a\u000a2.func_77973_b()).getPatternForItem(\u000a\u000a\u000a\u000a2, \u000a\u000a\u000a
            .getGridNode().getWorld());
            \u000a\u000a\u000a
            .patternConvert.put(\u000a\u000a\u000a\u000a3, craftingPattern2);
            iCraftingProviderHelper.addCraftingOption((ICraftingMedium)\u000a\u000a\u000a
            , \u000a\u000a\u000a\u000a3);
        }
    }

    private void pushItems() {
        IAEStack  22;
        PartFluidInterface partFluidInterface;
        for (IAEStack  22 : partFluidInterface.removeFromExport) {
            partFluidInterface.export.remove( 22);
        }
        partFluidInterface.removeFromExport.clear();
        for (IAEStack  22 : partFluidInterface.addToExport) {
            partFluidInterface.export.add( 22);
        }
        partFluidInterface.addToExport.clear();
        if (partFluidInterface.getGridNode().getWorld() == null || partFluidInterface.export.isEmpty()) {
            return;
        }
        ForgeDirection forgeDirection = partFluidInterface.getSide();
         22 = partFluidInterface.getGridNode().getWorld().func_147438_o(partFluidInterface.getGridNode().getGridBlock().getLocation().x + forgeDirection.offsetX, partFluidInterface.getGridNode().getGridBlock().getLocation().y + forgeDirection.offsetY, partFluidInterface.getGridNode().getGridBlock().getLocation().z + forgeDirection.offsetZ);
        if ( 22 != null) {
            IAEStack iAEStack = partFluidInterface.export.iterator().next();
              = iAEStack.copy();
            if (  instanceof IAEItemStack &&  22 instanceof IInventory) {
                if ( 22 instanceof ISidedInventory) {
                    ISidedInventory iSidedInventory = (ISidedInventory) 22;
                    for (int n : iSidedInventory.func_94128_d(forgeDirection.getOpposite().ordinal())) {
                        if (!iSidedInventory.func_102007_a(n, ((IAEItemStack) ).getItemStack(), forgeDirection.getOpposite().ordinal())) continue;
                        if (iSidedInventory.func_70301_a(n) == null) {
                            iSidedInventory.func_70299_a(n, ((IAEItemStack) ).getItemStack());
                            partFluidInterface.removeFromExport.add(iAEStack);
                            return;
                        }
                        if (!ItemUtils.areItemEqualsIgnoreStackSize(iSidedInventory.func_70301_a(n), ((IAEItemStack) ).getItemStack())) continue;
                          = iSidedInventory.func_70297_j_();
                          = iSidedInventory.func_70301_a((int)n).field_77994_a;
                          = (int) .getStackSize();
                        if (  ==  ) continue;
                        if (  +   <=  ) {
                            ItemStack itemStack = iSidedInventory.func_70301_a(n).func_77946_l();
                            itemStack.field_77994_a +=  ;
                            iSidedInventory.func_70299_a(n, itemStack);
                            partFluidInterface.removeFromExport.add(iAEStack);
                            return;
                        }
                        ItemStack  3 = iSidedInventory.func_70301_a(n).func_77946_l();
                         3.field_77994_a =  ;
                        iSidedInventory.func_70299_a(n,  3);
                        partFluidInterface.removeFromExport.add(iAEStack);
                         .setStackSize((long)(  -   +  ));
                        partFluidInterface.addToExport.add( );
                        return;
                    }
                } else {
                    IInventory iInventory = (IInventory) 22;
                    for (int i = 0; i < iInventory.func_70302_i_(); ++i) {
                        if (!iInventory.func_94041_b(i, ((IAEItemStack) ).getItemStack())) continue;
                        if (iInventory.func_70301_a(i) == null) {
                            iInventory.func_70299_a(i, ((IAEItemStack) ).getItemStack());
                            partFluidInterface.removeFromExport.add(iAEStack);
                            return;
                        }
                        if (!ItemUtils.areItemEqualsIgnoreStackSize(iInventory.func_70301_a(i), ((IAEItemStack) ).getItemStack())) continue;
                          = iInventory.func_70297_j_();
                          = iInventory.func_70301_a((int)i).field_77994_a;
                          = (int) .getStackSize();
                        if (  ==  ) continue;
                        if (  +   <=  ) {
                            ItemStack itemStack = iInventory.func_70301_a(i).func_77946_l();
                            itemStack.field_77994_a +=  ;
                            iInventory.func_70299_a(i, itemStack);
                            partFluidInterface.removeFromExport.add(iAEStack);
                            return;
                        }
                        ItemStack  4 = iInventory.func_70301_a(i).func_77946_l();
                         4.field_77994_a =  ;
                        iInventory.func_70299_a(i,  4);
                        partFluidInterface.removeFromExport.add(iAEStack);
                         .setStackSize((long)(  -   +  ));
                        partFluidInterface.addToExport.add( );
                        return;
                    }
                }
            } else if (  instanceof IAEFluidStack &&  22 instanceof IFluidHandler) {
                IFluidHandler iFluidHandler = (IFluidHandler) 22;
                IAEFluidStack  5 = (IAEFluidStack) ;
                if (iFluidHandler.canFill(forgeDirection.getOpposite(),  5.copy().getFluid())) {
                    int n = iFluidHandler.fill(forgeDirection.getOpposite(),  5.getFluidStack().copy(), false);
                    if (n == 0) {
                        return;
                    }
                    if ((long)n ==  5.getStackSize()) {
                        iFluidHandler.fill(forgeDirection.getOpposite(),  5.getFluidStack().copy(), true);
                        partFluidInterface.removeFromExport.add(iAEStack);
                    } else {
                        IAEFluidStack iAEFluidStack =  5.copy();
                        iAEFluidStack.setStackSize(iAEFluidStack.getStackSize() - (long)n);
                        FluidStack  6 =  5.getFluidStack().copy();
                         6.amount = n;
                        iFluidHandler.fill(forgeDirection.getOpposite(),  6, true);
                        partFluidInterface.removeFromExport.add(iAEStack);
                        partFluidInterface.addToExport.add((IAEStack)iAEFluidStack);
                        return;
                    }
                }
            }
        }
    }

    public boolean pushPattern(ICraftingPatternDetails iCraftingPatternDetails, InventoryCrafting inventoryCrafting) {
        if (partFluidInterface.isBusy() || !partFluidInterface.patternConvert.containsKey(iCraftingPatternDetails)) {
            return false;
        }
        ICraftingPatternDetails iCraftingPatternDetails2 = partFluidInterface.patternConvert.get(iCraftingPatternDetails);
        if (iCraftingPatternDetails2 instanceof CraftingPattern) {
            IAEItemStack  52;
            PartFluidInterface partFluidInterface;
            Long l;
            CraftingPattern craftingPattern = (CraftingPattern)iCraftingPatternDetails2;
            HashMap<Fluid, Long>  2 = new HashMap<Fluid, Long>();
            for (IAEFluidStack iAEFluidStack2 : craftingPattern.getCondensedFluidInputs()) {
                IAEFluidStack iAEFluidStack2;
                if ( 2.containsKey(iAEFluidStack2.getFluid())) {
                    l = (Long) 2.get(iAEFluidStack2.getFluid()) + iAEFluidStack2.getStackSize();
                     2.remove(iAEFluidStack2.getFluid());
                     2.put(iAEFluidStack2.getFluid(), l);
                    continue;
                }
                 2.put(iAEFluidStack2.getFluid(), iAEFluidStack2.getStackSize());
            }
            IGrid  3 = partFluidInterface.getGridNode().getGrid();
            if ( 3 == null) {
                return false;
            }
            IStorageGrid  4 = (IStorageGrid) 3.getCache(IStorageGrid.class);
            if ( 4 == null) {
                return false;
            }
            for (IAEFluidStack iAEFluidStack2 :  2.keySet()) {
                l = (Long) 2.get(iAEFluidStack2);
                 52 = (IAEFluidStack) 4.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack((Fluid)iAEFluidStack2, (int)(l + 0L))), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)partFluidInterface));
                if ( 52 != null &&  52.getStackSize() == l.longValue()) continue;
                return false;
            }
            for (IAEFluidStack iAEFluidStack2 :  2.keySet()) {
                l = (Long) 2.get(iAEFluidStack2);
                 52 = (IAEFluidStack) 4.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack((Fluid)iAEFluidStack2, (int)(l + 0L))), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)partFluidInterface));
                partFluidInterface.export.add((IAEStack) 52);
            }
            for (IAEItemStack  52 : craftingPattern.getCondensedInputs()) {
                if ( 52 == null) continue;
                if ( 52.getItem() == ItemEnum.FLUIDPATTERN.getItem()) {
                    partFluidInterface.toExport =  52.copy();
                    continue;
                }
                partFluidInterface.export.add((IAEStack) 52);
            }
        }
        return true;
    }

    public void readFilter(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.func_74764_b(sfb." \u0445yb")) {
             .fluidFilter = nBTTagCompound.func_74762_e(sfb." \u0445yb");
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
        if (nBTTagCompound.func_74764_b(tcx."ps d")) {
            \u000a
            .tank.readFromNBT(nBTTagCompound.func_74775_l(tcx."ps d"));
        }
        if (nBTTagCompound.func_74764_b(sfb." \u0445yb")) {
            \u000a
            .fluidFilter = nBTTagCompound.func_74762_e(sfb." \u0445yb");
        }
        if (nBTTagCompound.func_74764_b(p\u043c\u0440." elh")) {
            \u000a
            .inventory.readFromNBT(nBTTagCompound.func_74775_l(p\u043c\u0440." elh"));
        }
        if (nBTTagCompound.func_74764_b(emp." o\u043ct")) {
            \u000a
            .readOutputFromNBT(nBTTagCompound.func_74775_l(emp." o\u043ct"));
        }
    }

    @Override
    public boolean readFromStream(ByteBuf byteBuf) throws IOException {
        super.readFromStream(byteBuf);
        NBTTagCompound nBTTagCompound = ByteBufUtils.readTag((ByteBuf)byteBuf);
        if (nBTTagCompound.func_74764_b(tcx."ps d")) {
             .tank.readFromNBT(nBTTagCompound.func_74775_l(tcx."ps d"));
        }
        if (nBTTagCompound.func_74764_b(sfb." \u0445yb")) {
             .fluidFilter = nBTTagCompound.func_74762_e(sfb." \u0445yb");
        }
        if (nBTTagCompound.func_74764_b(p\u043c\u0440." elh")) {
             .inventory.readFromNBT(nBTTagCompound.func_74775_l(p\u043c\u0440." elh"));
        }
        return true;
    }

    private void readOutputFromNBT(NBTTagCompound nBTTagCompound2) {
        IAEItemStack  2;
         .addToExport.clear();
         .removeFromExport.clear();
         .export.clear();
        int n = nBTTagCompound2.func_74762_e(\u0441ud." \u0443\u0443\u043e");
        for (  = 0;   < n; ++ ) {
            NBTTagCompound nBTTagCompound2;
            if (nBTTagCompound2.func_74767_n(bha."xp o" +   + t\u0441g."o\u0440 d")) {
                 2 = AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2.func_74775_l(bha."xp o" +  )));
                 2.setStackSize(nBTTagCompound2.func_74763_f(bha."xp o" +   + l\u043c\u043e."m \u043ey"));
                 .removeFromExport.add((IAEStack) 2);
                continue;
            }
             2 = AEApi.instance().storage().createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound2.func_74775_l(bha."xp o" +  )));
             2.setStackSize(nBTTagCompound2.func_74763_f(bha."xp o" +   + l\u043c\u043e."m \u043ey"));
             .removeFromExport.add((IAEStack) 2);
        }
        n = nBTTagCompound2.func_74762_e(\u0441dc." eqp");
        for (  = 0;   < n; ++ ) {
            if (nBTTagCompound2.func_74767_n(zwn."ph \u0435" +   + t\u0441g."o\u0440 d")) {
                 2 = AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2.func_74775_l(zwn."ph \u0435" +  )));
                 2.setStackSize(nBTTagCompound2.func_74763_f(zwn."ph \u0435" +   + l\u043c\u043e."m \u043ey"));
                 .addToExport.add((IAEStack) 2);
                continue;
            }
             2 = AEApi.instance().storage().createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound2.func_74775_l(zwn."ph \u0435" +  )));
             2.setStackSize(nBTTagCompound2.func_74763_f(zwn."ph \u0435" +   + l\u043c\u043e."m \u043ey"));
             .addToExport.add((IAEStack) 2);
        }
        n = nBTTagCompound2.func_74762_e(emp." o\u043ct");
        for (  = 0;   < n; ++ ) {
            if (nBTTagCompound2.func_74767_n(lt." \u0440fk" +   + t\u0441g."o\u0440 d")) {
                 2 = AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2.func_74775_l(lt." \u0440fk" +  )));
                 2.setStackSize(nBTTagCompound2.func_74763_f(lt." \u0440fk" +   + l\u043c\u043e."m \u043ey"));
                 .export.add((IAEStack) 2);
                continue;
            }
             2 = AEApi.instance().storage().createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound2.func_74775_l(lt." \u0440fk" +  )));
             2.setStackSize(nBTTagCompound2.func_74763_f(lt." \u0440fk" +   + l\u043c\u043e."m \u043ey"));
             .export.add((IAEStack) 2);
        }
    }

    public void registerListener(IContainerListener iContainerListener) {
        \u000a\u000a .listeners.add(iContainerListener);
    }

    public void removeListener(IContainerListener iContainerListener) {
         .listeners.remove(iContainerListener);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon  $ 2 = TextureManager.BUS_SIDE.getTexture();
        iPartRenderHelper.setTexture( $ 2,  $ 2,  $ 2, TextureManager.INTERFACE.getTextures()[0],  $ 2,  $ 2);
        iPartRenderHelper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
        iPartRenderHelper.renderInventoryFace(TextureManager.INTERFACE.getTextures()[0], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setTexture( $ 2);
        iPartRenderHelper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 14.0f);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int n, int n2, int n3, IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon  $2 = TextureManager.BUS_SIDE.getTexture();
        iPartRenderHelper.setTexture( $2,  $2,  $2, TextureManager.INTERFACE.getTextures()[0],  $2,  $2);
        iPartRenderHelper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        iPartRenderHelper.renderBlock(n, n2, n3, renderBlocks);
        tessellator.func_78380_c(0x1400000);
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.INTERFACE.getTextures()[0], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setTexture( $2);
        iPartRenderHelper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 14.0f);
        iPartRenderHelper.renderBlock(n, n2, n3, renderBlocks);
    }

    @Override
    public void setFilter(ForgeDirection forgeDirection, Fluid fluid) {
        if (fluid == null) {
             .fluidFilter = -1;
             .doNextUpdate = true;
            return;
        }
         .fluidFilter = fluid.getID();
         .doNextUpdate = true;
    }

    @Override
    public void setFluid(int n, Fluid fluid, EntityPlayer entityPlayer) {
         .setFilter(ForgeDirection.getOrientation((int)n), fluid);
    }

    @Override
    public void setFluidTank(ForgeDirection forgeDirection, FluidStack fluidStack) {
         .tank.setFluid(fluidStack);
         .doNextUpdate = true;
    }

    public TickRateModulation tickingRequest(IGridNode $, int $2) {
        FluidStack $3;
        IGrid $4;
        PartFluidInterface $5;
        if ($5.doNextUpdate) {
            $5.forceUpdate();
        }
        if (($4 = $.getGrid()) == null) {
            return TickRateModulation.URGENT;
        }
        IStorageGrid $6 = (IStorageGrid)$4.getCache(IStorageGrid.class);
        if ($6 == null) {
            return TickRateModulation.URGENT;
        }
        $5.pushItems();
        if ($5.toExport != null) {
            $6.getItemInventory().injectItems((IAEStack)$5.toExport, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)$5));
            $5.toExport = null;
        }
        if ($5.update) {
            $5.update = false;
            if ($5.getGridNode() != null && $5.getGridNode().getGrid() != null) {
                $5.getGridNode().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)$5, $5.getGridNode()));
            }
        }
        if ($5.tank.getFluid() != null && FluidRegistry.getFluid((int)$5.fluidFilter) != $5.tank.getFluid().getFluid() && ($3 = $5.tank.drain(125, false)) != null) {
            IAEFluidStack $7 = (IAEFluidStack)$6.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack($3.copy()), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)$5));
            if ($7 != null) {
                int $8 = (int)((long)$3.amount - $7.getStackSize());
                $6.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack($5.tank.drain($8, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)$5));
                $5.doNextUpdate = true;
                $5.needBreake = false;
            } else {
                $6.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack($5.tank.drain($3.amount, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)$5));
                $5.doNextUpdate = true;
                $5.needBreake = false;
            }
        }
        if (($5.tank.getFluid() == null || $5.tank.getFluid().getFluid() == FluidRegistry.getFluid((int)$5.fluidFilter)) && FluidRegistry.getFluid((int)$5.fluidFilter) != null) {
            $3 = (IAEFluidStack)$6.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(FluidRegistry.getFluid((int)$5.fluidFilter), 125)), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)$5));
            if ($3 == null) {
                return TickRateModulation.URGENT;
            }
            int $9 = $5.tank.fill($3.getFluidStack(), false);
            if ($9 == 0) {
                return TickRateModulation.URGENT;
            }
            $5.tank.fill(((IAEFluidStack)$6.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(FluidRegistry.getFluid((int)$5.fluidFilter), $9)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)$5))).getFluidStack(), true);
            $5.doNextUpdate = true;
            $5.needBreake = false;
        }
        return TickRateModulation.URGENT;
    }

    public NBTTagCompound writeFilter(NBTTagCompound nBTTagCompound) {
        if (FluidRegistry.getFluid((int) .fluidFilter) == null) {
            return null;
        }
        nBTTagCompound.func_74768_a(sfb." \u0445yb",  .fluidFilter);
        return nBTTagCompound;
    }

    private NBTTagCompound writeOutputToNBT(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        NBTTagCompound nBTTagCompound3;
        int  2 = 0;
        for (IAEStack iAEStack :  .removeFromExport) {
            if (iAEStack != null) {
                nBTTagCompound2.func_74757_a(bha."xp o" +  2 + t\u0441g."o\u0440 d", iAEStack.isItem());
                nBTTagCompound3 = new NBTTagCompound();
                if (iAEStack.isItem()) {
                    ((IAEItemStack)iAEStack).getItemStack().func_77955_b(nBTTagCompound3);
                } else {
                    ((IAEFluidStack)iAEStack).getFluidStack().writeToNBT(nBTTagCompound3);
                }
                nBTTagCompound2.func_74782_a(bha."xp o" +  2, (NBTBase)nBTTagCompound3);
                nBTTagCompound2.func_74772_a(bha."xp o" +  2 + l\u043c\u043e."m \u043ey", iAEStack.getStackSize());
            }
            ++ 2;
        }
        nBTTagCompound2.func_74768_a(\u0441ud." \u0443\u0443\u043e",  .removeFromExport.size());
         2 = 0;
        for (IAEStack iAEStack :  .addToExport) {
            if (iAEStack != null) {
                nBTTagCompound2.func_74757_a(zwn."ph \u0435" +  2 + t\u0441g."o\u0440 d", iAEStack.isItem());
                nBTTagCompound3 = new NBTTagCompound();
                if (iAEStack.isItem()) {
                    ((IAEItemStack)iAEStack).getItemStack().func_77955_b(nBTTagCompound3);
                } else {
                    ((IAEFluidStack)iAEStack).getFluidStack().writeToNBT(nBTTagCompound3);
                }
                nBTTagCompound2.func_74782_a(zwn."ph \u0435" +  2, (NBTBase)nBTTagCompound3);
                nBTTagCompound2.func_74772_a(zwn."ph \u0435" +  2 + l\u043c\u043e."m \u043ey", iAEStack.getStackSize());
            }
            ++ 2;
        }
        nBTTagCompound2.func_74768_a(\u0441dc." eqp",  .addToExport.size());
         2 = 0;
        for (IAEStack iAEStack :  .export) {
            if (iAEStack != null) {
                nBTTagCompound2.func_74757_a(lt." \u0440fk" +  2 + t\u0441g."o\u0440 d", iAEStack.isItem());
                nBTTagCompound3 = new NBTTagCompound();
                if (iAEStack.isItem()) {
                    ((IAEItemStack)iAEStack).getItemStack().func_77955_b(nBTTagCompound3);
                } else {
                    ((IAEFluidStack)iAEStack).getFluidStack().writeToNBT(nBTTagCompound3);
                }
                nBTTagCompound2.func_74782_a(lt." \u0440fk" +  2, (NBTBase)nBTTagCompound3);
                nBTTagCompound2.func_74772_a(lt." \u0440fk" +  2 + l\u043c\u043e."m \u043ey", iAEStack.getStackSize());
            }
            ++ 2;
        }
        nBTTagCompound2.func_74768_a(emp." o\u043ct",  .export.size());
        return nBTTagCompound2;
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
         .writeToNBTWithoutExport(nBTTagCompound);
          = new NBTTagCompound();
         .writeOutputToNBT( );
        nBTTagCompound.func_74782_a(emp." o\u043ct", (NBTBase) );
    }

    public void writeToNBTWithoutExport(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        nBTTagCompound.func_74782_a(tcx."ps d", (NBTBase)\u000a\u000a
        .tank.writeToNBT(new NBTTagCompound()));
        nBTTagCompound.func_74768_a(sfb." \u0445yb", \u000a\u000a
        .fluidFilter);
        \u000a\u000a
         = new NBTTagCompound();
        \u000a\u000a
        .inventory.writeToNBT(\u000a\u000a
        );
        nBTTagCompound.func_74782_a(p\u043c\u0440." elh", (NBTBase)\u000a\u000a
        );
    }

    @Override
    public void writeToStream(ByteBuf byteBuf) throws IOException {
        super.writeToStream(byteBuf);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74782_a(tcx."ps d", (NBTBase) .tank.writeToNBT(new NBTTagCompound()));
        nBTTagCompound.func_74768_a(sfb." \u0445yb",  .fluidFilter);
          = new NBTTagCompound();
         .inventory.writeToNBT( );
        nBTTagCompound.func_74782_a(p\u043c\u0440." elh", (NBTBase) );
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)nBTTagCompound);
    }

    private class FluidInterfaceInventory
    implements IInventory {
        private ItemStack[] inv = new ItemStack[9];

        private FluidInterfaceInventory() {
            FluidInterfaceInventory fluidInterfaceInventory;
        }

        public void func_70305_f() {
        }

        public ItemStack func_70298_a(int n, int n2) {
            ItemStack itemStack =  .func_70301_a(n);
            if (itemStack != null) {
                if (itemStack.field_77994_a <= n2) {
                     .func_70299_a(n, null);
                } else {
                    itemStack = itemStack.func_77979_a(n2);
                    if (itemStack.field_77994_a == 0) {
                         .func_70299_a(n, null);
                    }
                }
            }
             .PartFluidInterface.this.update = true;
            return itemStack;
        }

        public String func_145825_b() {
            return med." fgj";
        }

        public int func_70297_j_() {
            return 1;
        }

        public int func_70302_i_() {
            FluidInterfaceInventory fluidInterfaceInventory;
            return fluidInterfaceInventory.inv.length;
        }

        public ItemStack func_70301_a(int n) {
            return  .inv[n];
        }

        public ItemStack func_70304_b(int n) {
            return null;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public boolean func_94041_b(int n, ItemStack itemStack) {
            if (itemStack.func_77973_b() instanceof ICraftingPatternItem) {
                IGridNode iGridNode =  $.PartFluidInterface.this.getGridNode();
                World  $2 = iGridNode == null ?  $.PartFluidInterface.this.getClientWorld() : iGridNode.getWorld();
                if ( $2 == null) {
                    return false;
                }
                ICraftingPatternDetails  $3 = ((ICraftingPatternItem)itemStack.func_77973_b()).getPatternForItem(itemStack,  $2);
                return  $3 != null;
            }
            return false;
        }

        public boolean func_70300_a(EntityPlayer entityPlayer) {
            return true;
        }

        public void func_70296_d() {
        }

        public void func_70295_k_() {
        }

        public void readFromNBT(NBTTagCompound nBTTagCompound) {
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c(x\u0445."z\u0445 a", 10);
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
                byte  2 = nBTTagCompound2.func_74771_c(\u0443kg." \u0445jf");
                if ( 2 < 0 ||  2 >=  .inv.length) continue;
                 .inv[ 2] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
            }
        }

        public void func_70299_a(int n, ItemStack itemStack) {
            \u000a\u000a\u000a\u000a
            .inv[n] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > \u000a\u000a\u000a\u000a
            .func_70297_j_()) {
                itemStack.field_77994_a = \u000a\u000a\u000a\u000a
                .func_70297_j_();
            }
            \u000a\u000a\u000a\u000a
            .PartFluidInterface.this.update = true;
        }

        public void writeToNBT(NBTTagCompound nBTTagCompound) {
            NBTTagList nBTTagList = new NBTTagList();
            for (int i = 0; i <  .inv.length; ++i) {
                ItemStack itemStack =  .inv[i];
                if (itemStack == null) continue;
                NBTTagCompound  2 = new NBTTagCompound();
                 2.func_74774_a(\u0443kg." \u0445jf", (byte)i);
                itemStack.func_77955_b( 2);
                nBTTagList.func_74742_a((NBTBase) 2);
            }
            nBTTagCompound.func_74782_a(x\u0445."z\u0445 a", (NBTBase)nBTTagList);
        }
    }
}

