/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.b\u0440s;
import extracells.15_09_2024__02_32_46.\u0441\u0441k;
import extracells.container.ContainerPlaneFormation;
import extracells.gridblock.ECBaseGridBlock;
import extracells.gui.GuiFluidPlaneFormation;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.network.packet.other.PacketFluidSlot;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.ColorUtil;
import extracells.util.FluidUtil;
import extracells.util.PermissionUtil;
import extracells.util.inventory.ECPrivateInventory;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class PartFluidPlaneFormation
extends PartECBase
implements IFluidSlotPartOrBlock,
IGridTickable {
    private Fluid fluid;
    public RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private ECPrivateInventory upgradeInventory;

    public PartFluidPlaneFormation() {
        PartFluidPlaneFormation partFluidPlaneFormation;
        partFluidPlaneFormation.upgradeInventory = new ECPrivateInventory(\u0441\u0441k."d\u043e d", 1, 1){

            @Override
            public boolean func_94041_b(int n, ItemStack itemStack) {
                return AEApi.instance().definitions().materials().cardRedstone().isSameAs(itemStack);
            }
        };
    }

    @Override
    public void getDrops(List<ItemStack> list, boolean bl) {
        for (ItemStack itemStack :  .upgradeInventory.slots) {
            if (itemStack == null) continue;
            list.add(itemStack);
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 2;
    }

    public void doWork() {
        PartFluidPlaneFormation partFluidPlaneFormation;
        TileEntity  2 = partFluidPlaneFormation.getHostTile();
        ECBaseGridBlock  3 = partFluidPlaneFormation.getGridBlock();
        ForgeDirection  4 = partFluidPlaneFormation.getSide();
        if (partFluidPlaneFormation.fluid == null ||  2 == null ||  3 == null || partFluidPlaneFormation.fluid.getBlock() == null) {
            return;
        }
        IMEMonitor<IAEFluidStack>  5 =  3.getFluidMonitor();
        if ( 5 == null) {
            return;
        }
        World  6 =  2.func_145831_w();
        Block  7 =  6.func_147439_a(  =  2.field_145851_c +  4.offsetX,   =  2.field_145848_d +  4.offsetY,   =  2.field_145849_e +  4.offsetZ);
        if ( 7 != null &&  7 != Blocks.field_150350_a) {
            return;
        }
        IAEFluidStack  8 = (IAEFluidStack) 5.extractItems((IAEStack)FluidUtil.createAEFluidStack(partFluidPlaneFormation.fluid, 1000L), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)partFluidPlaneFormation));
        if ( 8 == null ||  8.getStackSize() < 1000L) {
            return;
        }
         5.extractItems((IAEStack)FluidUtil.createAEFluidStack(partFluidPlaneFormation.fluid, 1000L), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)partFluidPlaneFormation));
        Block  9 = partFluidPlaneFormation.fluid.getBlock();
         6.func_147449_b( ,  ,  ,  9);
         6.func_147471_g( ,  ,  );
    }

    @Override
    public void getBoxes(IPartCollisionHelper iPartCollisionHelper) {
        iPartCollisionHelper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        iPartCollisionHelper.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer entityPlayer) {
        return new GuiFluidPlaneFormation( , entityPlayer);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer entityPlayer) {
        return new ContainerPlaneFormation( , entityPlayer);
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 20, false, false);
    }

    public ECPrivateInventory getUpgradeInventory() {
        PartFluidPlaneFormation partFluidPlaneFormation;
        return partFluidPlaneFormation.upgradeInventory;
    }

    @Override
    public boolean onActivate(EntityPlayer entityPlayer, Vec3 vec3) {
        if (entityPlayer.field_70170_p.field_72995_K) {
            return true;
        }
        if (PermissionUtil.hasPermission(entityPlayer, SecurityPermissions.BUILD,  )) {
            return super.onActivate(entityPlayer, vec3);
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
         .fluid = FluidRegistry.getFluid((String)nBTTagCompound.func_74779_i(b\u0440s." \u0430tp"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        IIcon iIcon = TextureManager.PANE_SIDE.getTexture();
        iPartRenderHelper.setTexture(iIcon, iIcon, iIcon, TextureManager.BUS_BORDER.getTexture(), iIcon, iIcon);
        iPartRenderHelper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
        iPartRenderHelper.setBounds(3.0f, 3.0f, 14.0f, 13.0f, 13.0f, 16.0f);
        iPartRenderHelper.setInvColor(AEColor.Cyan.blackVariant);
        iPartRenderHelper.renderInventoryFace(TextureManager.PANE_FRONT.getTextures()[0], ForgeDirection.SOUTH, renderBlocks);
        Tessellator.field_78398_a.func_78380_c(0xD000D0);
        iPartRenderHelper.setInvColor(ColorUtil.getInvertedInt(AEColor.Cyan.mediumVariant));
        iPartRenderHelper.renderInventoryFace(TextureManager.PANE_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setInvColor(ColorUtil.getInvertedInt(AEColor.Cyan.whiteVariant));
        iPartRenderHelper.renderInventoryFace(TextureManager.PANE_FRONT.getTextures()[2], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
         \u000a
        .renderInventoryBusLights(iPartRenderHelper, renderBlocks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int n, int n2, int n3, IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon $ 2 = TextureManager.PANE_SIDE.getTexture();
        iPartRenderHelper.setTexture($ 2, $ 2, $ 2, TextureManager.BUS_BORDER.getTexture(), $ 2, $ 2);
        iPartRenderHelper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        iPartRenderHelper.renderBlock(n, n2, n3, renderBlocks);
        iPartRenderHelper.setBounds(3.0f, 3.0f, 14.0f, 13.0f, 13.0f, 16.0f);
        IPartHost $ 3 = $ .getHost();
        if ($ 3 != null) {
            tessellator.func_78378_d($ 3.getColor().blackVariant);
            iPartRenderHelper.renderFace(n, n2, n3, TextureManager.PANE_FRONT.getTextures()[0], ForgeDirection.SOUTH, renderBlocks);
            if ($ .isActive()) {
                tessellator.func_78380_c(0xD000D0);
            }
            tessellator.func_78378_d(ColorUtil.getInvertedInt($ 3.getColor().mediumVariant));
            iPartRenderHelper.renderFace(n, n2, n3, TextureManager.PANE_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderBlocks);
            tessellator.func_78378_d(ColorUtil.getInvertedInt($ 3.getColor().whiteVariant));
            iPartRenderHelper.renderFace(n, n2, n3, TextureManager.PANE_FRONT.getTextures()[2], ForgeDirection.SOUTH, renderBlocks);
        }
        iPartRenderHelper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        $ .renderStaticBusLights(n, n2, n3, iPartRenderHelper, renderBlocks);
    }

    public void sendInformation(EntityPlayer entityPlayer) {
        new PacketFluidSlot(Lists.newArrayList((Object[])new Fluid[]{ .fluid})).sendPacketToPlayer(entityPlayer);
    }

    @Override
    public void setFluid(int n, Fluid fluid, EntityPlayer entityPlayer) {
         .fluid = fluid;
        new PacketFluidSlot(Lists.newArrayList((Object[])new Fluid[]{ .fluid})).sendPacketToPlayer(entityPlayer);
         .saveData();
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int n) {
         .doWork();
        return TickRateModulation.SAME;
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74778_a(b\u0440s." \u0430tp",  .fluid == null ? \u0441\u0441k."d\u043e d" :  .fluid.getName());
    }
}

