/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.b\u0440s;
import extracells.15_09_2024__02_32_46.lqd;
import extracells.15_09_2024__02_32_46.\u0435el;
import extracells.15_09_2024__02_32_46.\u0441\u0441k;
import extracells.15_09_2024__02_32_46.\u0445w;
import extracells.container.ContainerBusFluidStorage;
import extracells.gui.GuiBusFluidStorage;
import extracells.inventory.HandlerPartStorageFluid;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.network.packet.other.PacketFluidSlot;
import extracells.network.packet.part.PacketBusFluidStorage;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.PermissionUtil;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PartFluidStorage
extends PartECBase
implements ICellContainer,
IInventoryUpdateReceiver,
IFluidSlotPartOrBlock {
    private HashMap<FluidStack, Integer> fluidList = new HashMap();
    private int priority = 0;
    protected HandlerPartStorageFluid handler;
    private Fluid[] filterFluids;
    private AccessRestriction access;
    private ECPrivateInventory upgradeInventory;

    public PartFluidStorage() {
        PartFluidStorage $;
        $.handler = new HandlerPartStorageFluid($);
        $.filterFluids = new Fluid[54];
        $.access = AccessRestriction.READ_WRITE;
        $.upgradeInventory = new ECPrivateInventory(\u0441\u0441k."d\u043e d", 1, 1, $){

            @Override
            public boolean func_94041_b(int n, ItemStack itemStack) {
                return itemStack != null && AEApi.instance().definitions().materials().cardInverter().isSameAs(itemStack);
            }
        };
    }

    @Override
    public void getDrops(List<ItemStack> list, boolean bl) {
        for (ItemStack itemStack : \u000a\u000a\u000a\u000a .upgradeInventory.slots) {
            if (itemStack == null) continue;
            list.add(itemStack);
        }
    }

    @Override
    public ItemStack getItemStack(PartItemStack partItemStack) {
        ItemStack itemStack = super.getItemStack(partItemStack);
        if (partItemStack.equals((Object)PartItemStack.Wrench)) {
            itemStack.func_77978_p().func_82580_o(\u0435el."qs \u0443");
        }
        return itemStack;
    }

    public void blinkCell(int n) {
    }

    @Override
    public int cableConnectionRenderTo() {
        return 3;
    }

    @Override
    public void getBoxes(IPartCollisionHelper iPartCollisionHelper) {
        iPartCollisionHelper.addBox(2.0, 2.0, 15.0, 14.0, 14.0, 16.0);
        iPartCollisionHelper.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 15.0);
        iPartCollisionHelper.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel storageChannel) {
        ArrayList<IMEInventoryHandler> arrayList = new ArrayList<IMEInventoryHandler>();
        if (storageChannel == StorageChannel.FLUIDS) {
            arrayList.add( .handler);
        }
         .updateNeighborFluids();
        return arrayList;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer entityPlayer) {
        return new GuiBusFluidStorage( , entityPlayer);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    public int getPriority() {
        PartFluidStorage partFluidStorage;
        return partFluidStorage.priority;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer entityPlayer) {
        return new ContainerBusFluidStorage( , entityPlayer);
    }

    public ECPrivateInventory getUpgradeInventory() {
        PartFluidStorage partFluidStorage;
        return partFluidStorage.upgradeInventory;
    }

    @Override
    public boolean onActivate(EntityPlayer entityPlayer, Vec3 vec3) {
        if (entityPlayer.field_70170_p.field_72995_K) {
            return true;
        }
        return PermissionUtil.hasPermission(entityPlayer, SecurityPermissions.BUILD,  ) && super.onActivate(entityPlayer, vec3);
    }

    @Override
    public void onInventoryChanged() {
        PartFluidStorage partFluidStorage;
        partFluidStorage.handler.setInverted(AEApi.instance().definitions().materials().cardInverter().isSameAs(partFluidStorage.upgradeInventory.func_70301_a(0)));
        partFluidStorage.saveData();
    }

    @Override
    public void onNeighborChanged() {
        PartFluidStorage partFluidStorage;
        partFluidStorage.handler.onNeighborChange();
        IGridNode \u000a\u000a\u000a\u000a\u000a2 = partFluidStorage.getGridNode();
        if (\u000a\u000a\u000a\u000a\u000a2 != null) {
            IGrid iGrid = \u000a\u000a\u000a\u000a\u000a2.getGrid();
            if (iGrid != null && partFluidStorage.wasChanged()) {
                iGrid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                \u000a\u000a\u000a\u000a\u000a2.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(partFluidStorage.getGridBlock().getFluidMonitor(), StorageChannel.FLUIDS));
                \u000a\u000a\u000a\u000a\u000a2.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            partFluidStorage.getHost().markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void powerChange(MENetworkPowerStatusChange mENetworkPowerStatusChange) {
        IGridNode iGridNode = \u000a\u000a\u000a
        .getGridNode();
        if (iGridNode != null && (\u000a\u000a\u000a
         = iGridNode.isActive()) != \u000a\u000a\u000a
        .isActive()) {
            \u000a\u000a\u000a
            .setActive(\u000a\u000a\u000a
            );
            \u000a\u000a\u000a
            .onNeighborChanged();
            \u000a\u000a\u000a
            .getHost().markForUpdate();
        }
        iGridNode.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(\u000a\u000a\u000a
        .getGridBlock().getFluidMonitor(), StorageChannel.FLUIDS));
        iGridNode.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        super.readFromNBT(nBTTagCompound2);
         .priority = nBTTagCompound2.func_74762_e(\u0445w."j s\u0430");
        for (int i = 0; i < 9; ++i) {
             .filterFluids[i] = FluidRegistry.getFluid((String)nBTTagCompound2.func_74779_i(lqd." quq" + i));
        }
        if (nBTTagCompound2.func_74764_b(b\u0440s." ouz")) {
            try {
                 .access = AccessRestriction.valueOf((String)nBTTagCompound2.func_74779_i(b\u0440s." ouz"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
         .upgradeInventory.readFromNBT(nBTTagCompound2.func_150295_c(\u0435el."qs \u0443", 10));
         .onInventoryChanged();
         .onNeighborChanged();
         .handler.setPrioritizedFluids( .filterFluids);
         .handler.setAccessRestriction( .access);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper $, RenderBlocks $2) {
        PartFluidStorage $3;
        Tessellator $4 = Tessellator.field_78398_a;
        IIcon $5 = TextureManager.STORAGE_SIDE.getTexture();
        $.setTexture($5, $5, $5, TextureManager.STORAGE_FRONT.getTextures()[0], $5, $5);
        $.setBounds(2.0f, 2.0f, 15.0f, 14.0f, 14.0f, 16.0f);
        $.renderInventoryBox($2);
        $.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        $.renderInventoryBox($2);
        $.setBounds(2.0f, 2.0f, 15.0f, 14.0f, 14.0f, 16.0f);
        $.setInvColor(AEColor.Cyan.blackVariant);
        $4.func_78380_c(0xF000F0);
        $.renderInventoryFace(TextureManager.STORAGE_FRONT.getTextures()[1], ForgeDirection.SOUTH, $2);
        $.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        $3.renderInventoryBusLights($, $2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int n, int n2, int n3, IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon \u000a\u000a\u000a 2 = TextureManager.STORAGE_SIDE.getTexture();
        iPartRenderHelper.setTexture(\u000a\u000a\u000a 2, \u000a\u000a\u000a 2, \u000a\u000a\u000a 2, TextureManager.STORAGE_FRONT.getTexture(), \u000a\u000a\u000a 2, \u000a\u000a\u000a 2);
        iPartRenderHelper.setBounds(2.0f, 2.0f, 15.0f, 14.0f, 14.0f, 16.0f);
        iPartRenderHelper.renderBlock(n, n2, n3, renderBlocks);
        tessellator.func_78378_d(\u000a\u000a\u000a .getHost().getColor().blackVariant);
        if (\u000a\u000a\u000a .isActive()) {
            tessellator.func_78380_c(0xF000F0);
        }
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.STORAGE_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        iPartRenderHelper.renderBlock(n, n2, n3, renderBlocks);
        iPartRenderHelper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        \u000a\u000a\u000a .renderStaticBusLights(n, n2, n3, iPartRenderHelper, renderBlocks);
    }

    public void saveChanges(IMEInventory iMEInventory) {
         .saveData();
    }

    public void sendInformation(EntityPlayer entityPlayer) {
        new PacketFluidSlot(Arrays.asList( .filterFluids)).sendPacketToPlayer(entityPlayer);
        new PacketBusFluidStorage(entityPlayer,  .access, true).sendPacketToPlayer(entityPlayer);
    }

    @Override
    public void setFluid(int n, Fluid fluid, EntityPlayer entityPlayer) {
         .filterFluids[n] = fluid;
         .handler.setPrioritizedFluids( .filterFluids);
         .sendInformation(entityPlayer);
         .saveData();
    }

    public void updateAccess(AccessRestriction accessRestriction) {
         $.access = accessRestriction;
         $.handler.setAccessRestriction(accessRestriction);
         $.onNeighborChanged();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged mENetworkChannelsChanged) {
        IGridNode iGridNode =  .getGridNode();
        if (iGridNode != null && (  = iGridNode.isActive()) !=  .isActive()) {
             .setActive( );
             .onNeighborChanged();
             .getHost().markForUpdate();
        }
        iGridNode.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent( .getGridBlock().getFluidMonitor(), StorageChannel.FLUIDS));
        iGridNode.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        super.writeToNBT(nBTTagCompound2);
        nBTTagCompound2.func_74768_a(\u0445w."j s\u0430",  .priority);
        for (int i = 0; i <  .filterFluids.length; ++i) {
            Fluid fluid =  .filterFluids[i];
            if (fluid != null) {
                nBTTagCompound2.func_74778_a(lqd." quq" + i, fluid.getName());
                continue;
            }
            nBTTagCompound2.func_74778_a(lqd." quq" + i, \u0441\u0441k."d\u043e d");
        }
        nBTTagCompound2.func_74782_a(\u0435el."qs \u0443", (NBTBase) .upgradeInventory.writeToNBT());
        nBTTagCompound2.func_74778_a(b\u0440s." ouz",  .access.name());
    }

    private void updateNeighborFluids() {
        PartFluidStorage partFluidStorage;
        partFluidStorage.fluidList.clear();
        if (partFluidStorage.access == AccessRestriction.READ || partFluidStorage.access == AccessRestriction.READ_WRITE) {
            for (IAEFluidStack iAEFluidStack : partFluidStorage.handler.getAvailableItems((IItemList<IAEFluidStack>)AEApi.instance().storage().createFluidList())) {
                FluidStack fluidStack = iAEFluidStack.getFluidStack().copy();
                partFluidStorage.fluidList.put(fluidStack, fluidStack.amount);
            }
        }
    }

    private boolean wasChanged() {
        HashMap<FluidStack, Integer> hashMap = new HashMap<FluidStack, Integer>();
        for (IAEFluidStack iAEFluidStack :  .handler.getAvailableItems((IItemList<IAEFluidStack>)AEApi.instance().storage().createFluidList())) {
            FluidStack fluidStack = iAEFluidStack.getFluidStack();
            hashMap.put(fluidStack, fluidStack.amount);
        }
        return !hashMap.equals( .fluidList);
    }
}

