/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.b\u0440s;
import extracells.15_09_2024__02_32_46.cwp;
import extracells.15_09_2024__02_32_46.euk;
import extracells.15_09_2024__02_32_46.ewc;
import extracells.15_09_2024__02_32_46.ldx;
import extracells.15_09_2024__02_32_46.l\u0441m;
import extracells.15_09_2024__02_32_46.mbd;
import extracells.15_09_2024__02_32_46.v\u0441u;
import extracells.15_09_2024__02_32_46.xkp;
import extracells.15_09_2024__02_32_46.x\u0435\u043e;
import extracells.15_09_2024__02_32_46.yr\u0440;
import extracells.15_09_2024__02_32_46.y\u0435h;
import extracells.15_09_2024__02_32_46.\u0435\u0445\u043c;
import extracells.15_09_2024__02_32_46.\u043car;
import extracells.15_09_2024__02_32_46.\u043c\u0441q;
import extracells.15_09_2024__02_32_46.\u0443kg;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.FluidUtil;
import extracells.util.WrenchUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class PartFluidStorageMonitor
extends PartECBase
implements IStackWatcherHost {
    Fluid fluid = null;
    long amount = 0L;
    private Object dspList;
    boolean locked = false;
    IStackWatcher watcher = null;

    public PartFluidStorageMonitor() {
        PartFluidStorageMonitor partFluidStorageMonitor;
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    protected void dropItems(World world, int n, int n2, int n3, ItemStack itemStack) {
        if (world == null) {
            return;
        }
        if (!world.field_72995_K) {
            float f = 0.7f;
            double  2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double  3 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double  4 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem  5 = new EntityItem(world, (double)n +  2, (double)n2 +  3, (double)n3 +  4, itemStack);
             5.field_145804_b = 10;
            world.func_72838_d((Entity) 5);
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper $) {
        $.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        $.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        $.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    protected IMEMonitor<IAEFluidStack> getFluidStorage() {
        PartFluidStorageMonitor partFluidStorageMonitor;
        IGridNode  2 = partFluidStorageMonitor.getGridNode();
        if ( 2 == null) {
            return null;
        }
        IGrid  3 =  2.getGrid();
        if ( 3 == null) {
            return null;
        }
        IStorageGrid  4 = (IStorageGrid) 3.getCache(IStorageGrid.class);
        if ( 4 == null) {
            return null;
        }
        return  4.getFluidInventory();
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound nBTTagCompound, List<String> list) {
        super.getWailaBodey(nBTTagCompound, list);
        long l = 0L;
        Fluid \u000a\u000a\u000a\u000a2 = null;
        if (nBTTagCompound.func_74764_b(xkp."dk g") && nBTTagCompound.func_74767_n(xkp."dk g")) {
            list.add(StatCollector.func_74838_a((String)\u043car." \u043djf"));
        } else {
            list.add(StatCollector.func_74838_a((String)x\u0435\u043e."zk c"));
        }
        if (nBTTagCompound.func_74764_b(ldx." qrj")) {
            l = nBTTagCompound.func_74763_f(ldx." qrj");
        }
        if (nBTTagCompound.func_74764_b(b\u0440s." \u0430tp") && (\u000a\u000a\u000a
         = nBTTagCompound.func_74762_e(b\u0440s." \u0430tp")) != -1) {
            \u000a\u000a\u000a\u000a2 = FluidRegistry.getFluid((int)\u000a\u000a\u000a
            );
        }
        if (\u000a\u000a\u000a\u000a2 != null) {
            list.add(StatCollector.func_74838_a((String)\u0435\u0445\u043c."y g\u0435") + v\u0441u." cxe" + \u000a\u000a\u000a\u000a2.getLocalizedName(new FluidStack(\u000a\u000a\u000a\u000a2, 1000)));
            if (\u000a\u000a\u000a
            .isActive()) {
                list.add(StatCollector.func_74838_a((String)l\u0441m." tji") + v\u0441u." cxe" + l + ewc."o y\u0440");
            } else {
                list.add(StatCollector.func_74838_a((String)l\u0441m." tji") + \u0443kg."tm r");
            }
        } else {
            list.add(StatCollector.func_74838_a((String)\u0435\u0445\u043c."y g\u0435") + v\u0441u." cxe" + StatCollector.func_74838_a((String)y\u0435h." c\u043e\u0430"));
            list.add(StatCollector.func_74838_a((String)l\u0441m." tji") + \u0443kg."tm r");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound $) {
        PartFluidStorageMonitor $2;
        super.getWailaTag($);
        $.func_74757_a(xkp."dk g", $2.locked);
        $.func_74772_a(ldx." qrj", $2.amount);
        if ($2.fluid == null) {
            $.func_74768_a(b\u0440s." \u0430tp", -1);
        } else {
            $.func_74768_a(b\u0440s." \u0430tp", $2.fluid.getID());
        }
        return $;
    }

    @Override
    public boolean onActivate(EntityPlayer entityPlayer, Vec3 vec3) {
        PartFluidStorageMonitor partFluidStorageMonitor;
        if (entityPlayer == null || entityPlayer.field_70170_p == null) {
            return true;
        }
        if (entityPlayer.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack itemStack = entityPlayer.func_71045_bC();
        if (itemStack == null) {
            if (partFluidStorageMonitor.locked) {
                return false;
            }
            if (partFluidStorageMonitor.fluid == null) {
                return true;
            }
            if (partFluidStorageMonitor.watcher != null) {
                partFluidStorageMonitor.watcher.remove((Object)FluidUtil.createAEFluidStack(partFluidStorageMonitor.fluid));
            }
            partFluidStorageMonitor.fluid = null;
            partFluidStorageMonitor.amount = 0L;
            IPartHost iPartHost = partFluidStorageMonitor.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
            return true;
        }
        if (WrenchUtil.canWrench(itemStack, entityPlayer, partFluidStorageMonitor.tile.field_145851_c, partFluidStorageMonitor.tile.field_145848_d, partFluidStorageMonitor.tile.field_145849_e)) {
            partFluidStorageMonitor.locked = !partFluidStorageMonitor.locked;
            WrenchUtil.wrenchUsed(itemStack, entityPlayer, partFluidStorageMonitor.tile.field_145851_c, partFluidStorageMonitor.tile.field_145849_e, partFluidStorageMonitor.tile.field_145848_d);
            IPartHost iPartHost = partFluidStorageMonitor.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
            if (partFluidStorageMonitor.locked) {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(mbd."\u043e \u0445y", new Object[0]));
            } else {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(b\u0440s."j\u0443 q", new Object[0]));
            }
            return true;
        }
        if (partFluidStorageMonitor.locked) {
            return false;
        }
        if (FluidUtil.isFilled(itemStack)) {
            if (partFluidStorageMonitor.fluid != null && partFluidStorageMonitor.watcher != null) {
                partFluidStorageMonitor.watcher.remove((Object)FluidUtil.createAEFluidStack(partFluidStorageMonitor.fluid));
            }
            partFluidStorageMonitor.fluid = FluidUtil.getFluidFromContainer(itemStack).getFluid();
            if (partFluidStorageMonitor.watcher != null) {
                partFluidStorageMonitor.watcher.add((Object)FluidUtil.createAEFluidStack(partFluidStorageMonitor.fluid));
            }
            if ((  = partFluidStorageMonitor.getHost()) != null) {
                 .markForUpdate();
            }
            return true;
        }
        return false;
    }

    public void onStackChange(IItemList iItemList, IAEStack iAEStack, IAEStack iAEStack2, BaseActionSource baseActionSource, StorageChannel storageChannel) {
        if (partFluidStorageMonitor.fluid != null) {
            PartFluidStorageMonitor partFluidStorageMonitor;
            IGridNode iGridNode = partFluidStorageMonitor.getGridNode();
            if (iGridNode == null) {
                return;
            }
            IGrid \u000a2 = iGridNode.getGrid();
            if (\u000a2 == null) {
                return;
            }
            IStorageGrid \u000a3 = (IStorageGrid)\u000a2.getCache(IStorageGrid.class);
            if (\u000a3 == null) {
                return;
            }
            IMEMonitor<IAEFluidStack> \u000a4 = partFluidStorageMonitor.getFluidStorage();
            if (\u000a4 == null) {
                return;
            }
            for (IAEFluidStack iAEFluidStack : \u000a4.getStorageList()) {
                if (iAEFluidStack.getFluid() != partFluidStorageMonitor.fluid) continue;
                partFluidStorageMonitor.amount = iAEFluidStack.getStackSize();
                IPartHost iPartHost = partFluidStorageMonitor.getHost();
                if (iPartHost != null) {
                    iPartHost.markForUpdate();
                }
                return;
            }
            partFluidStorageMonitor.amount = 0L;
            IPartHost \u000a5 = partFluidStorageMonitor.getHost();
            if (\u000a5 != null) {
                \u000a5.markForUpdate();
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        super.readFromNBT(nBTTagCompound2);
        if (nBTTagCompound2.func_74764_b(ldx." qrj")) {
             .amount = nBTTagCompound2.func_74763_f(ldx." qrj");
        }
        if (nBTTagCompound2.func_74764_b(b\u0440s." \u0430tp")) {
            int n = nBTTagCompound2.func_74762_e(b\u0440s." \u0430tp");
             .fluid = n == -1 ? null : FluidRegistry.getFluid((int)n);
        }
        if (nBTTagCompound2.func_74764_b(xkp."dk g")) {
             .locked = nBTTagCompound2.func_74767_n(xkp."dk g");
        }
    }

    @Override
    public boolean readFromStream(ByteBuf byteBuf) throws IOException {
        super.readFromStream(byteBuf);
         .amount = byteBuf.readLong();
        int n = byteBuf.readInt();
         .fluid = n == -1 ? null : FluidRegistry.getFluid((int)n);
         .locked = byteBuf.readBoolean();
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double d, double d2, double d3, IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        if ( .fluid == null) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        if (! .isActive()) {
            return;
        }
        IAEFluidStack  2 = FluidUtil.createAEFluidStack( .fluid);
         2.setStackSize( .amount);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(d + 0.5), (double)(d2 + 0.5), (double)(d3 + 0.5));
         .renderFluid(tessellator,  2);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderFluid(Tessellator tessellator, IAEFluidStack iAEFluidStack) {
        ForgeDirection forgeDirection =  .getSide();
        GL11.glTranslated((double)((double)forgeDirection.offsetX * 0.77), (double)((double)forgeDirection.offsetY * 0.77), (double)((double)forgeDirection.offsetZ * 0.77));
        if (forgeDirection == ForgeDirection.UP) {
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (forgeDirection == ForgeDirection.DOWN) {
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (forgeDirection == ForgeDirection.EAST) {
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (forgeDirection == ForgeDirection.WEST) {
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (forgeDirection == ForgeDirection.NORTH) {
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
        }
        if (forgeDirection == ForgeDirection.SOUTH) {
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        try {
            int n = 0x1000100;
              = n % 65536;
             4 = n / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)  * 0.8f), (float)((float) 4 * 0.8f));
            GL11.glDisable((int)2896);
            GL11.glDisable((int)32826);
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            IIcon  2 =  .fluid.getIcon();
            if ( 2 != null) {
                GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
                GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
                GL11.glTranslated((double)-8.6f, (double)-16.3, (double)-1.2f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                Tessellator tessellator2 = Tessellator.field_78398_a;
                GL11.glColor3f((float)((float)( .fluid.getColor() >> 16 & 0xFF) / 255.0f), (float)((float)( .fluid.getColor() >> 8 & 0xFF) / 255.0f), (float)((float)( .fluid.getColor() & 0xFF) / 255.0f));
                tessellator2.func_78369_a((float)( .fluid.getColor() >> 16 & 0xFF) / 255.0f, (float)( .fluid.getColor() >> 8 & 0xFF) / 255.0f, (float)( .fluid.getColor() & 0xFF) / 255.0f, 1.0f);
                tessellator2.func_78382_b();
                tessellator2.func_78374_a(0.0, 16.0, 0.0, (double) 2.func_94209_e(), (double) 2.func_94210_h());
                tessellator2.func_78374_a(16.0, 16.0, 0.0, (double) 2.func_94212_f(), (double) 2.func_94210_h());
                tessellator2.func_78374_a(16.0, 0.0, 0.0, (double) 2.func_94212_f(), (double) 2.func_94206_g());
                tessellator2.func_78374_a(0.0, 0.0, 0.0, (double) 2.func_94209_e(), (double) 2.func_94206_g());
                tessellator2.func_78381_a();
                GL11.glEnable((int)2896);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GL11.glPopMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
        GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        String string = PartFluidStorageMonitor.formatSize(iAEFluidStack.getStackSize());
        FontRenderer  3 = Minecraft.func_71410_x().field_71466_p;
        int  4 =  3.func_78256_a(string);
        GL11.glTranslatef((float)(-0.5f * (float) 4), (float)0.0f, (float)-1.0f);
         3.func_78276_b(string, 0, 0, 0);
    }

    private static String formatSize(long l) {
        if (l < 1000L) {
            return Long.toString(l);
        }
        if (l < 1000000L) {
            return l / 1000L + yr\u0440."hd m";
        }
        if (l < 1000000000L) {
            return l / 1000000L + cwp."s ba";
        }
        if (l < 1000000000000L) {
            return l / 1000000000L + ldx."ij g";
        }
        if (l < 1000000000000000L) {
            return l / 1000000000000L + \u0435\u0445\u043c."z xe";
        }
        if (l < 1000000000000000000L) {
            return l / 1000000000000000L + \u043c\u0441q."h \u043dt";
        }
        return l / 1000000000000000000L + euk."cq u";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon \u000a\u000a\u000a\u000a 2 = TextureManager.TERMINAL_SIDE.getTexture();
        iPartRenderHelper.setTexture(\u000a\u000a\u000a\u000a 2);
        iPartRenderHelper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
        iPartRenderHelper.setTexture(\u000a\u000a\u000a\u000a 2, \u000a\u000a\u000a\u000a 2, \u000a\u000a\u000a\u000a 2, TextureManager.BUS_BORDER.getTexture(), \u000a\u000a\u000a\u000a 2, \u000a\u000a\u000a\u000a 2);
        iPartRenderHelper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
        tessellator.func_78380_c(0xD000D0);
        iPartRenderHelper.setInvColor(0xFFFFFF);
        iPartRenderHelper.renderInventoryFace(TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        iPartRenderHelper.setInvColor(AEColor.Transparent.blackVariant);
        iPartRenderHelper.renderInventoryFace(TextureManager.STORAGE_MONITOR.getTextures()[0], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setInvColor(AEColor.Transparent.mediumVariant);
        iPartRenderHelper.renderInventoryFace(TextureManager.STORAGE_MONITOR.getTextures()[1], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setInvColor(AEColor.Transparent.whiteVariant);
        iPartRenderHelper.renderInventoryFace(TextureManager.STORAGE_MONITOR.getTextures()[2], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        \u000a\u000a\u000a\u000a .renderInventoryBusLights(iPartRenderHelper, renderBlocks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int n, int n2, int n3, IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon $ 2 = TextureManager.TERMINAL_SIDE.getTexture();
        iPartRenderHelper.setTexture($ 2);
        iPartRenderHelper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        iPartRenderHelper.renderBlock(n, n2, n3, renderBlocks);
        iPartRenderHelper.setTexture($ 2, $ 2, $ 2, TextureManager.BUS_BORDER.getTexture(), $ 2, $ 2);
        iPartRenderHelper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        iPartRenderHelper.renderBlock(n, n2, n3, renderBlocks);
        if ($ .isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        tessellator.func_78378_d(0xFFFFFF);
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderBlocks);
        IPartHost $ 3 = $ .getHost();
        iPartRenderHelper.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        tessellator.func_78378_d($ 3.getColor().mediumVariant);
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.STORAGE_MONITOR.getTextures()[0], ForgeDirection.SOUTH, renderBlocks);
        tessellator.func_78378_d($ 3.getColor().whiteVariant);
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.STORAGE_MONITOR.getTextures()[1], ForgeDirection.SOUTH, renderBlocks);
        tessellator.func_78378_d($ 3.getColor().blackVariant);
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.STORAGE_MONITOR.getTextures()[2], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        $ .renderStaticBusLights(n, n2, n3, iPartRenderHelper, renderBlocks);
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    public void updateWatcher(IStackWatcher iStackWatcher) {
         .watcher = iStackWatcher;
        if ( .fluid != null) {
            iStackWatcher.add((Object)FluidUtil.createAEFluidStack( .fluid));
        }
         .onStackChange(null, null, null, null, null);
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        nBTTagCompound.func_74772_a(ldx." qrj",  .amount);
        if ( .fluid == null) {
            nBTTagCompound.func_74768_a(b\u0440s." \u0430tp", -1);
        } else {
            nBTTagCompound.func_74768_a(b\u0440s." \u0430tp",  .fluid.getID());
        }
        nBTTagCompound.func_74757_a(xkp."dk g",  .locked);
    }

    @Override
    public void writeToStream(ByteBuf byteBuf) throws IOException {
        super.writeToStream(byteBuf);
        byteBuf.writeLong( .amount);
        if ( .fluid == null) {
            byteBuf.writeInt(-1);
        } else {
            byteBuf.writeInt( .fluid.getID());
        }
        byteBuf.writeBoolean( .locked);
    }
}

