/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import cpw.mods.fml.common.Optional;
import extracells.integration.Integration;
import java.util.HashMap;
import net.minecraftforge.fluids.Fluid;

public class FuelBurnTime {
    public static final HashMap<Fluid, Integer> fluidBurnTimes = new HashMap();

    public FuelBurnTime() {
        FuelBurnTime fuelBurnTime;
    }

    public static void registerFuel(Fluid fluid, int n) {
        if (!fluidBurnTimes.containsKey(fluid)) {
            fluidBurnTimes.put(fluid, n);
        }
    }

    public static int getBurnTime(Fluid fluid) {
        if (fluid == null) {
            return 0;
        }
        if (fluidBurnTimes.containsKey(fluid)) {
            return fluidBurnTimes.get(fluid);
        }
        if (Integration.Mods.BCFUEL.isEnabled()) {
            return FuelBurnTime.getBCBurnTime(fluid);
        }
        return 0;
    }

    @Optional.Method(modid="BuildCraftAPI|fuels")
    private static int getBCBurnTime(Fluid fluid) {
        for (IFuel iFuel : BuildcraftFuelRegistry.fuel.getFuels()) {
            if (iFuel.getFluid() != fluid) continue;
            return iFuel.getTotalBurningTime();
        }
        return 0;
    }
}

