/*
 * Decompiled with CFR 0.152.
 */
package com.TominoCZ.FBP;

import com.TominoCZ.FBP.handler.FBPEventHandler;
import com.TominoCZ.FBP.handler.FBPGuiHandler;
import com.TominoCZ.FBP.handler.FBPKeyInputHandler;
import com.TominoCZ.FBP.keys.FBPKeyBindings;
import com.TominoCZ.FBP.particle.FBPParticleManager;
import com.TominoCZ.FBP.vector.FBPVector3d;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SplittableRandom;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.StringUtils;

@Mod(modid="fbp", acceptedMinecraftVersions="[1.7,1.8)")
public class FBP {
    @Mod.Instance(value="fbp")
    public static FBP INSTANCE;
    public static final String MODID = "fbp";
    public static final ResourceLocation LOCATION_PARTICLE_TEXTURE;
    public static final ResourceLocation FBP_BUG;
    public static final ResourceLocation FBP_FBP;
    public static final ResourceLocation FBP_WIDGETS;
    public static File particleBlacklistFile;
    public static File floatingMaterialsFile;
    public static File config;
    public static int minAge;
    public static int maxAge;
    public static int particlesPerAxis;
    public static double scaleMult;
    public static double gravityMult;
    public static double rotationMult;
    public static double weatherParticleDensity;
    public static boolean enabled;
    public static boolean showInMillis;
    public static boolean infiniteDuration;
    public static boolean randomRotation;
    public static boolean cartoonMode;
    public static boolean spawnWhileFrozen;
    public static boolean spawnRedstoneBlockParticles;
    public static boolean randomizedScale;
    public static boolean randomFadingSpeed;
    public static boolean entityCollision;
    public static boolean bounceOffWalls;
    public static boolean lowTraction;
    public static boolean smartBreaking;
    public static boolean fancyRain;
    public static boolean fancySnow;
    public static boolean fancyFlame;
    public static boolean fancySmoke;
    public static boolean waterPhysics;
    public static boolean restOnFloor;
    public static boolean frozen;
    public List<String> blockParticleBlacklist;
    public List<Material> floatingMaterials;
    public static SplittableRandom random;
    public static final FBPVector3d[] CUBE;
    public static final FBPVector3d[] CUBE_NORMALS;
    public static IRenderHandler fancyWeatherRenderer;
    public static IRenderHandler originalWeatherRenderer;
    public static FBPParticleManager fancyEffectRenderer;
    public static EffectRenderer originalEffectRenderer;
    public FBPEventHandler eventHandler = new FBPEventHandler();
    public FBPGuiHandler guiHandler = new FBPGuiHandler();

    public FBP() {
        INSTANCE = this;
        this.blockParticleBlacklist = Collections.synchronizedList(new ArrayList());
        this.floatingMaterials = Collections.synchronizedList(new ArrayList());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        config = new File(evt.getModConfigurationDirectory() + "/FBP/Particle.properties");
        particleBlacklistFile = new File(evt.getModConfigurationDirectory() + "/FBP/ParticleBlockBlacklist.txt");
        floatingMaterialsFile = new File(evt.getModConfigurationDirectory() + "/FBP/FloatingMaterials.txt");
        FBPKeyBindings.init();
        FMLCommonHandler.instance().bus().register((Object)new FBPKeyInputHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.eventHandler);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this.guiHandler);
    }

    public static boolean isEnabled() {
        boolean result = enabled;
        if (!result) {
            frozen = false;
        }
        return result;
    }

    public static void setEnabled(boolean enabled) {
        if (FBP.enabled != enabled) {
            if (enabled) {
                fancyEffectRenderer.carryOver();
                Minecraft.func_71410_x().field_71452_i = fancyEffectRenderer;
                Minecraft.func_71410_x().field_71441_e.field_73011_w.setWeatherRenderer(fancyWeatherRenderer);
            } else {
                Minecraft.func_71410_x().field_71452_i = originalEffectRenderer;
                Minecraft.func_71410_x().field_71441_e.field_73011_w.setWeatherRenderer(originalWeatherRenderer);
            }
        }
        FBP.enabled = enabled;
    }

    public static boolean isDev() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public boolean isBlacklisted(Block b) {
        if (b == null) {
            return true;
        }
        return this.blockParticleBlacklist.contains(Block.field_149771_c.func_148750_c((Object)b));
    }

    public boolean doesMaterialFloat(Material mat) {
        return this.floatingMaterials.contains(mat);
    }

    public void addToBlacklist(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        Block b = (Block)Block.field_149771_c.func_82594_a(name);
        this.addToBlacklist(b);
    }

    public void addToBlacklist(Block b) {
        if (b == null) {
            return;
        }
        String name = Block.field_149771_c.func_148750_c((Object)b);
        if (!this.blockParticleBlacklist.contains(name)) {
            this.blockParticleBlacklist.add(name);
        }
    }

    public void removeFromBlacklist(Block b) {
        if (b == null) {
            return;
        }
        String name = Block.field_149771_c.func_148750_c((Object)b);
        if (this.blockParticleBlacklist.contains(name)) {
            this.blockParticleBlacklist.remove(name);
        }
    }

    public void resetBlacklist() {
        this.blockParticleBlacklist.clear();
    }

    static {
        LOCATION_PARTICLE_TEXTURE = new ResourceLocation("textures/particle/particles.png");
        FBP_BUG = new ResourceLocation("fbp:textures/gui/bug.png");
        FBP_FBP = new ResourceLocation("fbp:textures/gui/fbp.png");
        FBP_WIDGETS = new ResourceLocation("fbp:textures/gui/widgets.png");
        particleBlacklistFile = null;
        floatingMaterialsFile = null;
        config = null;
        enabled = true;
        showInMillis = false;
        infiniteDuration = false;
        random = new SplittableRandom();
        CUBE = new FBPVector3d[]{new FBPVector3d(1.0, 1.0, -1.0), new FBPVector3d(1.0, 1.0, 1.0), new FBPVector3d(-1.0, 1.0, 1.0), new FBPVector3d(-1.0, 1.0, -1.0), new FBPVector3d(-1.0, -1.0, -1.0), new FBPVector3d(-1.0, -1.0, 1.0), new FBPVector3d(1.0, -1.0, 1.0), new FBPVector3d(1.0, -1.0, -1.0), new FBPVector3d(-1.0, -1.0, 1.0), new FBPVector3d(-1.0, 1.0, 1.0), new FBPVector3d(1.0, 1.0, 1.0), new FBPVector3d(1.0, -1.0, 1.0), new FBPVector3d(1.0, -1.0, -1.0), new FBPVector3d(1.0, 1.0, -1.0), new FBPVector3d(-1.0, 1.0, -1.0), new FBPVector3d(-1.0, -1.0, -1.0), new FBPVector3d(-1.0, -1.0, -1.0), new FBPVector3d(-1.0, 1.0, -1.0), new FBPVector3d(-1.0, 1.0, 1.0), new FBPVector3d(-1.0, -1.0, 1.0), new FBPVector3d(1.0, -1.0, 1.0), new FBPVector3d(1.0, 1.0, 1.0), new FBPVector3d(1.0, 1.0, -1.0), new FBPVector3d(1.0, -1.0, -1.0)};
        CUBE_NORMALS = new FBPVector3d[]{new FBPVector3d(0.0, 1.0, 0.0), new FBPVector3d(0.0, -1.0, 0.0), new FBPVector3d(0.0, 0.0, 1.0), new FBPVector3d(0.0, 0.0, -1.0), new FBPVector3d(-1.0, 0.0, 0.0), new FBPVector3d(1.0, 0.0, 0.0)};
    }
}

