/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.client.gui;

import com.google.common.collect.Lists;
import gravisuite.GraviSuite;
import gravisuite.item.ItemRelocator;
import gravisuite.network.PacketManagePoints;
import gravisuite.utils.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiRelocatorDisplay
extends GuiScreen {
    private static ResourceLocation tex = new ResourceLocation("gravisuite", "textures/gui/relocator_display.png");
    private int mouseX;
    private int mouseY;
    private int itemInterval = 10;
    private int firstItemX = 17;
    private int firstItemY = 16;
    private int cancelBtnX1 = 138;
    private int cancelBtnSize;
    private int firstSelX = 15;
    private int firstSelY = 15;
    private int selWidth = 132;
    private int selHeight = 9;
    private int firstItemBGX = 14;
    private int firstItemBGY = 14;
    private int itemBGinterval = 10;
    private int cancelBtnWidth = 9;
    private int cancelBtnHeight = 9;
    private int openType;
    private int itemBGX = 0;
    private int itemBGY = 131;
    private int itemBGWidth = 134;
    private int itemBGHeight = 11;
    private int itemBGdefX = 0;
    private int itemBGdefY = 170;
    private int itemBGselX = 0;
    private int itemBGselY = 144;
    private int itemBGdelX = 0;
    private int itemBGdelY = 157;
    private int xSize = 162;
    private int ySize = 129;
    public static final int GUI_POINT_DISPLAY_LIST = 0;
    public static final int GUI_POINT_DISPLAY_DEFSELECT = 1;
    List<ItemRelocator.TeleportPoint> tpList = Lists.newArrayList();

    public GuiRelocatorDisplay(int guiType) {
        this.openType = guiType;
        this.tpList.addAll(ItemRelocator.loadTeleportPoints(this.getCurrentItem()));
    }

    public SelectedItem getSelected(List<ItemRelocator.TeleportPoint> tpList) {
        SelectedItem tmpSel = new SelectedItem();
        int yStart = (this.field_146295_m - this.ySize) / 2;
        int realMouseY = this.mouseY - yStart;
        int itemsCount = tpList.size();
        if (this.isPointInRegion(this.firstSelX, this.firstSelY + 1, this.selWidth, this.itemInterval * itemsCount - 2, this.mouseX, this.mouseY)) {
            double newCalc = (double)(realMouseY - this.firstSelY + 1) / (double)this.itemBGinterval;
            tmpSel.selItem = (int)Math.ceil(newCalc);
            if (this.isPointInRegion(this.cancelBtnX1, this.firstSelY + 1, this.cancelBtnWidth, this.itemInterval * itemsCount - 1, this.mouseX, this.mouseY)) {
                tmpSel.delFlag = true;
            }
            return tmpSel;
        }
        return null;
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        int xStart = (this.field_146294_l - this.xSize) / 2;
        int yStart = (this.field_146295_m - this.ySize) / 2;
        SelectedItem selectedItem = this.getSelected(this.tpList);
        if (selectedItem != null) {
            if (selectedItem.delFlag) {
                PacketManagePoints.issue((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.tpList.get((int)(selectedItem.selItem - 1)).pointName, (byte)0);
                this.tpList.remove(selectedItem.selItem - 1);
            } else {
                if (this.openType == 0) {
                    PacketManagePoints.issue((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.tpList.get((int)(selectedItem.selItem - 1)).pointName, (byte)2);
                }
                if (this.openType == 1) {
                    PacketManagePoints.issue((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.tpList.get((int)(selectedItem.selItem - 1)).pointName, (byte)3);
                }
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        }
    }

    private boolean isPointInRegion(int left, int top, int width, int height, int mouseX, int mouseY) {
        int k1 = (this.field_146294_l - 162) / 2;
        int l1 = (this.field_146295_m - 129) / 2;
        return (mouseX -= k1) >= left - 1 && mouseX < left + width + 1 && (mouseY -= l1) >= top - 1 && mouseY < top + height + 1;
    }

    public ItemStack getCurrentItem() {
        return Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70448_g();
    }

    public void sendPoint() {
        this.field_146297_k.field_71439_g.func_71053_j();
    }

    protected void drawGuiContainerForegroundLayer(int x, int y) {
        int xStart = (this.field_146294_l - this.xSize) / 2;
        int yStart = (this.field_146295_m - this.ySize) / 2;
        try {
            if (this.tpList.size() > 0) {
                SelectedItem selectedItem;
                for (int i = 0; i < this.tpList.size(); ++i) {
                    ItemRelocator.TeleportPoint tmpPoint = this.tpList.get(i);
                    this.field_146289_q.func_78276_b(tmpPoint.pointName, xStart + this.firstItemX, yStart + this.firstItemY + i * this.itemInterval, 0xFFFFFF);
                }
                GameSettings var10000 = this.field_146297_k.field_71474_y;
                if (GameSettings.func_100015_a((KeyBinding)this.field_146297_k.field_71474_y.field_74311_E) && (selectedItem = this.getSelected(this.tpList)) != null) {
                    ArrayList<String> toolTipData = new ArrayList<String>();
                    ItemRelocator.TeleportPoint tmpPoint2 = this.tpList.get(selectedItem.selItem - 1);
                    int hotKey = selectedItem.selItem;
                    if (hotKey == 10) {
                        hotKey = 0;
                    }
                    toolTipData.add(EnumChatFormatting.GOLD + "Hotkey: " + hotKey);
                    toolTipData.add("Dimension: " + DimensionManager.getProvider((int)tmpPoint2.dimID).func_80007_l());
                    toolTipData.add("Height: " + (int)tmpPoint2.y);
                    toolTipData.add("X: " + (int)tmpPoint2.x);
                    toolTipData.add("Y: " + (int)tmpPoint2.z);
                    int realMouseX = this.mouseX - xStart;
                    int realMouseY = this.mouseY - yStart;
                    RenderHelper.renderTooltip(realMouseX - 2, realMouseY, toolTipData);
                }
            }
        }
        catch (Exception var10001) {
            GraviSuite.addLog("Error in draw relocatorGui foregroundLayer:" + var10001.toString());
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int x, int y, float par3) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(par3, x, y);
        this.drawGuiContainerForegroundLayer(x, y);
        super.func_73863_a(x, y, par3);
        this.mouseX = x;
        this.mouseY = y;
    }

    public void func_73876_c() {
    }

    protected void func_73869_a(char par1, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (keyCode > 1 && keyCode < 12) {
            ArrayList tpList = Lists.newArrayList();
            tpList.addAll(ItemRelocator.loadTeleportPoints(this.getCurrentItem()));
            if (keyCode - 2 < tpList.size()) {
                ItemRelocator.TeleportPoint tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(keyCode - 2);
                PacketManagePoints.issue((EntityPlayer)Minecraft.func_71410_x().field_71439_g, tmpPoint.pointName, (byte)2);
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void drawGuiContainerBackgroundLayer(float opacity, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(tex);
        int xStart = (this.field_146294_l - this.xSize) / 2;
        int yStart = (this.field_146295_m - this.ySize) / 2;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_73729_b(xStart, yStart, 0, 0, this.xSize, this.ySize);
        GL11.glDisable((int)3042);
        if (this.tpList.size() > 0) {
            for (int i = 0; i < this.tpList.size(); ++i) {
                this.func_73729_b(xStart + this.firstItemBGX, yStart + this.firstItemBGY + i * this.itemInterval, this.itemBGX, this.itemBGY, this.itemBGWidth, this.itemBGHeight);
                ItemRelocator.TeleportPoint tmpPoint = this.tpList.get(i);
                if (!tmpPoint.defPoint) continue;
                this.func_73729_b(xStart + this.firstItemBGX, yStart + this.firstItemBGY + i * this.itemInterval, this.itemBGdefX, this.itemBGdefY, this.itemBGWidth, this.itemBGHeight);
            }
            SelectedItem selectedItem = this.getSelected(this.tpList);
            if (selectedItem != null) {
                if (!selectedItem.delFlag) {
                    this.func_73729_b(xStart + this.firstItemBGX, yStart + this.firstItemBGY + (selectedItem.selItem - 1) * this.itemInterval, this.itemBGselX, this.itemBGselY, this.itemBGWidth, this.itemBGHeight);
                } else {
                    this.func_73729_b(xStart + this.firstItemBGX, yStart + this.firstItemBGY + (selectedItem.selItem - 1) * this.itemInterval, this.itemBGdelX, this.itemBGdelY, this.itemBGWidth, this.itemBGHeight);
                }
            }
        }
    }

    public static class SelectedItem {
        public int selItem = -1;
        public boolean delFlag = false;
    }
}

