/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.BlockLocation;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import gravisuite.item.ItemAdvIDrill;
import gravisuite.keyboard.Keyboard;
import gravisuite.network.PacketSyncBlockBreak;
import gravisuite.utils.Helpers;
import gravisuite.utils.NBTHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ml.luxinfine.gravisuite.EventConfig;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class ItemAdvancedDrill
extends ItemTool
implements IElectricItem {
    protected int maxCharge;
    protected int tier;
    float bigHolePower;
    float normalPower;
    float lowPower;
    float ultraLowPower;
    int energyPerOperation;
    int energyPerLowOperation;
    int energyPerUltraLowOperation;
    protected int transferLimit;
    private final Set<Block> mineableBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150435_aG, Blocks.field_150425_aM});
    public int soundTicker;
    private final float damageToEntity;
    int maxWorkRange;
    private final String iconName;
    private static final Set<Material> materials = Sets.newHashSet((Object[])new Material[]{Material.field_151576_e, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151571_B, Material.field_151566_D});

    ItemAdvancedDrill(float damageToEntity, Item.ToolMaterial toolMaterial, String iconName) {
        super(damageToEntity, toolMaterial, new HashSet());
        this.iconName = iconName;
        this.damageToEntity = damageToEntity;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel");
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return Items.field_151046_w.canHarvestBlock(block, stack) || Items.field_151046_w.func_150893_a(stack, block) > 1.0f || Items.field_151047_v.canHarvestBlock(block, stack) || Items.field_151047_v.func_150893_a(stack, block) > 1.0f || this.mineableBlocks.contains(block);
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        return ElectricItem.manager.canUse(tool, (double)this.energyPerOperation) ? (this.canHarvestBlock(block, tool) ? this.getEfficiencyOfStack(tool) : 1.0f) : 1.0f;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return EventConfig.drillLvl;
    }

    public boolean func_77644_a(ItemStack p_77644_1_, EntityLivingBase p_77644_2_, EntityLivingBase p_77644_3_) {
        return true;
    }

    public float getDamageVsEntity() {
        return this.damageToEntity;
    }

    public boolean isRepairable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a(this.iconName);
    }

    public boolean removeBlocks(BlockLocation location, int sideHit, EntityPlayer player) {
        ItemStack stack = player.func_70694_bm();
        if (!(stack.func_77973_b() instanceof ItemAdvancedDrill)) {
            return false;
        }
        int toolMode = NBTHelper.readToolMode(stack);
        World world = player.field_70170_p;
        Block block = world.func_147439_a(location.X, location.Y, location.Z);
        boolean canceled = false;
        boolean correctTileInventory = Helpers.isCorrectTileInventory(world, location.X, location.Y, location.Z);
        if (!world.field_72995_K && !Helpers.canBreakBlock(world, (EntityPlayerMP)player, location.X, location.Y, location.Z)) {
            canceled = true;
        }
        int meta = world.func_72805_g(location.X, location.Y, location.Z);
        boolean lowPower = false;
        if (block == null) {
            return false;
        }
        if (toolMode != 3) {
            if (!canceled) {
                this.breakBlock(block, meta, stack, player, location.X, location.Y, location.Z);
                if (world.field_72995_K) {
                    world.func_72926_e(2001, location.X, location.Y, location.Z, Block.func_149682_b((Block)block) + (meta << 12));
                }
            }
            return true;
        }
        boolean blockEffective = materials.contains(block.func_149688_o()) || block.func_149688_o() == Material.field_151579_a;
        int xRange = blockEffective && sideHit != 4 && sideHit != 5 ? 1 : 0;
        int yRange = blockEffective && sideHit != 0 && sideHit != 1 ? 1 : 0;
        int zRange = blockEffective && sideHit != 2 && sideHit != 3 ? 1 : 0;
        for (int xPos = location.X - xRange; xPos <= location.X + xRange && !lowPower; ++xPos) {
            block1: for (int yPos = location.Y - yRange; yPos <= location.Y + yRange && !lowPower; ++yPos) {
                for (int zPos = location.Z - zRange; zPos <= location.Z + zRange; ++zPos) {
                    float localHardness;
                    if (!ElectricItem.manager.canUse(stack, (double)this.energyPerOperation)) {
                        lowPower = true;
                        if (world.field_72995_K) continue block1;
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(location.X, location.Y, location.Z, world));
                        ElectricItem.manager.chargeFromArmor(stack, (EntityLivingBase)player);
                        continue block1;
                    }
                    Block localBlock = world.func_147439_a(xPos, yPos, zPos);
                    int localMeta = world.func_72805_g(xPos, yPos, zPos);
                    float f = localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.func_149712_f(world, xPos, yPos, zPos);
                    if (localBlock == null || !(localHardness >= 0.0f) || !materials.contains(localBlock.func_149688_o()) && blockEffective) continue;
                    if (!(world.field_72995_K || !canceled && Helpers.canBreakBlock(world, (EntityPlayerMP)player, xPos, yPos, zPos))) {
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(xPos, yPos, zPos, world));
                        continue;
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        this.breakBlock(localBlock, localMeta, stack, player, xPos, yPos, zPos);
                        ElectricItem.manager.use(stack, (double)this.energyPerOperation / (double)(EnchantmentHelper.func_77506_a((int)34, (ItemStack)stack) + 1), (EntityLivingBase)player);
                    } else {
                        Helpers.setBlockToAir(world, xPos, yPos, zPos);
                    }
                    world.func_147479_m(xPos, yPos, zPos);
                }
            }
        }
        if (world.field_72995_K) {
            world.func_72926_e(2001, location.X, location.Y, location.Z, Block.func_149682_b((Block)block) + (meta << 12));
        }
        if (lowPower) {
            ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.text.noenergy}");
        }
        if (!GraviSuite.isSimulating() || !(this instanceof ItemAdvIDrill) || correctTileInventory) {
            return true;
        }
        BlockLocation chestLocation = NBTHelper.getHomeLocation(stack);
        boolean tpToHomeMode = NBTHelper.getTpToHomeMode(stack) > 0;
        boolean itemMode = NBTHelper.getItemMode(stack) > 0;
        boolean fastDespawnMode = NBTHelper.getFastDespawnMode(stack) > 0;
        List items = player.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(location.X - 1), (double)(location.Y - 1), (double)(location.Z - 1), (double)(location.X + 2), (double)(location.Y + 2), (double)(location.Z + 2)));
        for (EntityItem item : items) {
            if (item.field_70292_b > 1) continue;
            if (tpToHomeMode && chestLocation != null) {
                int remaining = Helpers.addItemToTileInventory(chestLocation.world, item.func_92059_d(), chestLocation.X, chestLocation.Y, chestLocation.Z);
                ElectricItem.manager.use(stack, (double)((item.func_92059_d().field_77994_a - remaining) * 125), (EntityLivingBase)player);
                if (remaining > 0) {
                    item.func_92059_d().field_77994_a = remaining;
                    if (itemMode) {
                        item.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S18PacketEntityTeleport((Entity)item));
                        item.field_145804_b = 0;
                    }
                    if (!fastDespawnMode) continue;
                    item.lifespan = 100;
                    continue;
                }
                item.func_70106_y();
                continue;
            }
            if (itemMode) {
                item.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S18PacketEntityTeleport((Entity)item));
                item.field_145804_b = 0;
            }
            if (!fastDespawnMode) continue;
            item.lifespan = 100;
        }
        return true;
    }

    private void breakBlock(Block block, int blockMeta, ItemStack stack, EntityPlayer player, int x, int y, int z) {
        World world = player.func_130014_f_();
        if (!world.field_72995_K && !EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            if (stack.func_77973_b() instanceof ItemAdvIDrill && NBTHelper.getExpMode(stack) == 0) {
                block.func_149657_c(world, x, y, z, block.getExpDrop((IBlockAccess)world, blockMeta, EnchantmentHelper.func_77517_e((EntityLivingBase)player)));
            } else {
                player.func_71023_q(block.getExpDrop((IBlockAccess)world, blockMeta, EnchantmentHelper.func_77517_e((EntityLivingBase)player)));
            }
        }
        if (!world.field_72995_K) {
            int whiteListMode = NBTHelper.getWhiteListMode(stack);
            if (whiteListMode != 0 && Helpers.isItemInMap(block, blockMeta, NBTHelper.getListBlockMap(stack, whiteListMode == 2), x, y, z, player) == (whiteListMode == 1)) {
                block.func_149681_a(world, x, y, z, blockMeta, player);
                if (block.removedByPlayer(world, player, x, y, z, false)) {
                    block.func_149664_b(world, x, y, z, blockMeta);
                }
                return;
            }
            if (block.func_149712_f(world, x, y, z) > 0.0f) {
                this.func_150894_a(stack, world, block, x, y, z, (EntityLivingBase)player);
            }
        }
        block.func_149681_a(world, x, y, z, blockMeta, player);
        if (block.removedByPlayer(world, player, x, y, z, true)) {
            block.func_149664_b(world, x, y, z, blockMeta);
            block.func_149636_a(world, player, x, y, z, blockMeta);
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (Minecraft.func_71410_x().func_71356_B()) {
            return false;
        }
        if (GraviSuite.isSimulating()) {
            return true;
        }
        World world = player.field_70170_p;
        MovingObjectPosition mop = Helpers.rayTraceFromEntity(world, (Entity)player, true, 4.5);
        PacketSyncBlockBreak.issue(new BlockLocation(x, y, z), mop.field_72310_e);
        return this.removeBlocks(new BlockLocation(x, y, z), mop.field_72310_e, player);
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int xPos, int yPos, int zPos, EntityLivingBase entityLiving) {
        if (world.field_72995_K) {
            return true;
        }
        if (block == null) {
            return false;
        }
        int toolMode = NBTHelper.readToolMode(itemstack);
        if (toolMode == 0) {
            if ((double)block.func_149712_f(world, xPos, yPos, zPos) != 0.0 && entityLiving != null) {
                ElectricItem.manager.use(itemstack, (double)this.energyPerOperation, entityLiving);
            }
            return true;
        }
        if (toolMode == 1) {
            if ((double)block.func_149712_f(world, xPos, yPos, zPos) != 0.0 && entityLiving != null) {
                ElectricItem.manager.use(itemstack, (double)this.energyPerLowOperation, entityLiving);
            }
            return true;
        }
        if (toolMode == 2) {
            if ((double)block.func_149712_f(world, xPos, yPos, zPos) != 0.0 && entityLiving != null) {
                ElectricItem.manager.use(itemstack, (double)this.energyPerUltraLowOperation, entityLiving);
            }
            return true;
        }
        return true;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (!world.field_72995_K) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                Item item;
                ItemStack torchStack = player.field_71071_by.field_70462_a[i];
                if (torchStack == null || !torchStack.func_77977_a().toLowerCase().contains("torch") || !((item = torchStack.func_77973_b()) instanceof ItemBlock)) continue;
                int oldMeta = torchStack.func_77960_j();
                int oldSize = torchStack.field_77994_a;
                boolean result = torchStack.func_77943_a(player, world, x, y, z, side, xOffset, yOffset, zOffset);
                if (player.field_71075_bZ.field_75098_d) {
                    torchStack.func_77964_b(oldMeta);
                    torchStack.field_77994_a = oldSize;
                } else if (torchStack.field_77994_a <= 0) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack);
                    player.field_71071_by.field_70462_a[i] = null;
                }
                if (!result) continue;
                return true;
            }
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K && Keyboard.isModeKeyDown(player)) {
            int toolMode = NBTHelper.readToolMode(itemStack);
            if (++toolMode > 3) {
                toolMode = 0;
            }
            NBTHelper.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.GREEN + "{message.text.mode}: {message.advDDrill.mode.normal}");
            }
            if (toolMode == 1) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.GOLD + "{message.text.mode}: {message.advDDrill.mode.lowPower}");
            }
            if (toolMode == 2) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.AQUA + "{message.text.mode}: {message.advDDrill.mode.fine}");
            }
            if (toolMode == 3) {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.LIGHT_PURPLE + "{message.text.mode}: {message.advDDrill.mode.bigHoles}");
            }
        }
        return itemStack;
    }

    public String getRandomDrillSound() {
        switch (GraviSuite.random.nextInt(4)) {
            case 1: {
                return "drillOne";
            }
            case 2: {
                return "drillTwo";
            }
            case 3: {
                return "drillThree";
            }
        }
        return "drill";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        int toolMode = NBTHelper.readToolMode(itemStack);
        if (toolMode == 0) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.advDDrill.mode.normal"));
        }
        if (toolMode == 1) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.advDDrill.mode.lowPower"));
        }
        if (toolMode == 2) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.advDDrill.mode.fine"));
        }
        if (toolMode == 3) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.advDDrill.mode.bigHoles"));
        }
        list.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.getTier(itemStack));
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    private float getEfficiencyOfStack(ItemStack is) {
        int toolMode = NBTHelper.readToolMode(is);
        switch (toolMode) {
            case 0: {
                return this.normalPower;
            }
            case 1: {
                return this.lowPower;
            }
            case 2: {
                return this.ultraLowPower;
            }
            case 3: {
                return this.bigHolePower;
            }
        }
        return this.field_77864_a;
    }
}

