/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.item;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import gravisuite.utils.Helpers;
import gravisuite.utils.NBTHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemAdvancedJetPack
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor {
    public static int maxCharge;
    private final int transferLimit;
    private final int tier;
    public static int energyPerTick;
    public static int boostMultiplier;
    private static byte toggleTimer;
    private static double hoverModeFallSpeed;
    private static boolean lastJetpackUsed;
    public AudioSource audioSource;

    public ItemAdvancedJetPack(ItemArmor.ArmorMaterial armorMaterial, int par3, int par4) {
        super(armorMaterial, par3, par4);
        maxCharge = 3000000;
        energyPerTick = 12;
        boostMultiplier = 5;
        this.transferLimit = 3000;
        hoverModeFallSpeed = 0.03;
        this.func_77637_a(GraviSuite.graviSuiteCreativeTab);
        this.tier = 3;
        toggleTimer = (byte)20;
        this.func_77656_e(27);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public static int getCharge(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        return nbttagcompound.func_74762_e("charge");
    }

    public static int switchWorkMode(EntityPlayer player, ItemStack itemstack) {
        if (ItemAdvancedJetPack.readWorkMode(itemstack)) {
            ItemAdvancedJetPack.saveWorkMode(itemstack, false);
            ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.YELLOW + "{message.advElJetpack.hoverMode} " + EnumChatFormatting.RED + "{message.text.disabled}");
        } else {
            ItemAdvancedJetPack.saveWorkMode(itemstack, true);
            ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.YELLOW + "{message.advElJetpack.hoverMode} " + EnumChatFormatting.GREEN + "{message.text.enabled}");
        }
        return 0;
    }

    public static int switchFlyState(EntityPlayer player, ItemStack itemstack) {
        if (ItemAdvancedJetPack.readFlyStatus(itemstack)) {
            ItemAdvancedJetPack.saveFlyStatus(itemstack, false);
            ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.YELLOW + "{message.advElJetpack.jetpackEngine} " + EnumChatFormatting.RED + "{message.text.off}");
        } else {
            ItemAdvancedJetPack.saveFlyStatus(itemstack, true);
            ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.YELLOW + "{message.advElJetpack.jetpackEngine} " + EnumChatFormatting.GREEN + "{message.text.on}");
        }
        return 0;
    }

    public void onArmorTick(World worldObj, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound var3 = NBTHelper.getOrCreateNbtData(itemStack);
        boolean hoverMode = ItemAdvancedJetPack.readWorkMode(itemStack);
        byte var5 = var3.func_74771_c("toggleTimer");
        boolean var6 = false;
        if ((Keyboard.isJumpKeyDown(player) || hoverMode && player.field_70181_x < -hoverModeFallSpeed && !player.field_70122_E) && ItemAdvancedJetPack.readFlyStatus(itemStack)) {
            var6 = ItemAdvancedJetPack.useJetpack(player, hoverMode);
        }
        if (!worldObj.field_72995_K && var5 > 0) {
            var5 = (byte)(var5 - 1);
            var3.func_74774_a("toggleTimer", var5);
        }
        if (worldObj.field_72995_K) {
            if (lastJetpackUsed != var6) {
                if (var6) {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource((Object)player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                } else if (this.audioSource != null) {
                    this.audioSource.remove();
                    this.audioSource = null;
                }
                lastJetpackUsed = var6;
            }
            if (this.audioSource != null) {
                this.audioSource.updatePosition();
            }
        }
    }

    public static boolean useJetpack(EntityPlayer player, boolean hoverMode) {
        int worldHeight;
        double currYPos;
        ItemStack itemstack = player.field_71071_by.field_70460_b[2];
        int currCharge = ItemAdvancedJetPack.getCharge(itemstack);
        if (currCharge < energyPerTick && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        float power = 1.0f;
        float dropPercentage = 0.001f;
        float bcoff = (float)maxCharge / 20.0f;
        if ((float)ItemAdvancedJetPack.getCharge(itemstack) / (float)maxCharge <= dropPercentage) {
            power *= (float)ItemAdvancedJetPack.getCharge(itemstack) / bcoff;
        }
        if (player.field_71075_bZ.field_75098_d) {
            power = 1.0f;
        }
        if (Keyboard.isForwardKeyDown(player)) {
            float retruster = 0.3f;
            if (hoverMode) {
                retruster = 0.65f;
            }
            float forwardpower = power * retruster * 2.0f;
            float boostSpeed = 0.0f;
            if (Keyboard.isBoostKeyDown(player) && (currCharge > energyPerTick * boostMultiplier || player.field_71075_bZ.field_75098_d)) {
                boostSpeed = 0.09f;
                if (hoverMode) {
                    boostSpeed = 0.07f;
                }
            }
            if (forwardpower > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * forwardpower + boostSpeed, 0.02f + boostSpeed);
                if (boostSpeed > 0.0f && !player.field_71075_bZ.field_75098_d && GraviSuite.isSimulating()) {
                    ItemAdvancedJetPack.use(itemstack, energyPerTick * boostMultiplier);
                }
            }
        }
        if ((currYPos = player.field_70163_u) > (double)((worldHeight = player.field_70170_p.func_72800_K()) - 25)) {
            if (currYPos > (double)worldHeight) {
                currYPos = worldHeight;
            }
            power = (float)((double)power * (((double)worldHeight - currYPos) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            double maxHoverY = -hoverModeFallSpeed;
            if (Keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.2;
            }
            if (Keyboard.isSneakKeyDown(player)) {
                maxHoverY = -0.2;
            }
            if ((currCharge > energyPerTick * boostMultiplier || player.field_71075_bZ.field_75098_d) && Keyboard.isBoostKeyDown(player) && (Keyboard.isSneakKeyDown(player) || Keyboard.isJumpKeyDown(player))) {
                maxHoverY *= 2.0;
                ItemAdvancedJetPack.use(itemstack, energyPerTick * boostMultiplier);
            }
            if (player.field_70181_x > maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        if (!player.field_71075_bZ.field_75098_d && !player.field_70122_E) {
            ItemAdvancedJetPack.use(itemstack, energyPerTick);
        }
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            ObfuscationReflectionHelper.setPrivateValue(NetHandlerPlayServer.class, (Object)((EntityPlayerMP)player).field_71135_a, (Object)0, (String[])new String[]{"field_147365_f", "floatingTickCount"});
        }
        return true;
    }

    public static void use(ItemStack item, int value) {
        if (GraviSuite.isSimulating()) {
            ElectricItem.manager.discharge(item, (double)value, Integer.MAX_VALUE, true, false, false);
        }
    }

    public int getEnergyPerDamage() {
        return 0;
    }

    public double getDamageAbsorptionRatio() {
        return 0.0;
    }

    private double getBaseAbsorptionRatio() {
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemAdvancedJetPack");
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "gravisuite:textures/armor/armor_advanced_jetpack.png";
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public static boolean readWorkMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        return Minecraft.func_71410_x().func_71356_B() ? nbttagcompound.func_74767_n("isHoverActive") : nbttagcompound.func_74767_n("hoverMode");
    }

    public static boolean saveWorkMode(ItemStack itemstack, boolean workMode) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isHoverActive", workMode);
        nbttagcompound.func_74774_a("toggleTimer", toggleTimer);
        return true;
    }

    public static boolean readFlyStatus(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        return Minecraft.func_71410_x().func_71356_B() ? nbttagcompound.func_74767_n("isFlyActive") : nbttagcompound.func_74767_n("jetpack");
    }

    public static boolean saveFlyStatus(ItemStack itemstack, boolean flyMode) {
        NBTTagCompound nbttagcompound = NBTHelper.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isFlyActive", flyMode);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        String jetPackEngine = ItemAdvancedJetPack.readFlyStatus(itemStack) ? EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.on") : EnumChatFormatting.DARK_RED + Helpers.formatMessage("message.text.off");
        String hoverModeStatus = ItemAdvancedJetPack.readWorkMode(itemStack) ? EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.on") : EnumChatFormatting.DARK_RED + Helpers.formatMessage("message.text.off");
        list.add(EnumChatFormatting.RED + Helpers.formatMessage("message.advElJetpack.jetpackEngine") + ": " + jetPackEngine);
        list.add(EnumChatFormatting.RED + Helpers.formatMessage("message.advElJetpack.hoverMode") + ": " + hoverModeStatus);
        list.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.getTier(itemStack));
    }

    public void resetPlayerInAirTime(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ObfuscationReflectionHelper.setPrivateValue(NetHandlerPlayServer.class, (Object)((EntityPlayerMP)player).field_71135_a, (Object)0, (String[])new String[]{"field_147365_f", "floatingTickCount"});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (!entity.field_70170_p.field_72995_K) {
            ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
        }
    }

    static {
        lastJetpackUsed = false;
    }
}

