/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.network;

import gravisuite.item.ItemAdvDDrill;
import gravisuite.item.ItemAdvIDrill;
import gravisuite.network.IPacket;
import gravisuite.network.PacketHandler;
import gravisuite.utils.NBTHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PacketSaveToolConfig
extends IPacket {
    public static final int packetID = 4;
    public int whiteListMode;
    public int itemMode;
    public int expMode;
    public int fastDespawnMode;
    public int tpToHomeMode;

    @Override
    public void readData(DataInputStream data) throws IOException {
        byte mode = data.readByte();
        this.whiteListMode = data.readInt();
        if (mode > 0) {
            return;
        }
        this.itemMode = data.readInt();
        this.expMode = data.readInt();
        this.fastDespawnMode = data.readInt();
        this.tpToHomeMode = data.readInt();
    }

    public static void issue(int whiteListMode, int itemMode, int expMode, int fastDespawnMode, int tpToHomeMode) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(buffer);
            data.writeByte(4);
            data.writeByte(0);
            data.writeInt(whiteListMode);
            data.writeInt(itemMode);
            data.writeInt(expMode);
            data.writeInt(fastDespawnMode);
            data.writeInt(tpToHomeMode);
            data.close();
            PacketHandler.sendPacket(buffer.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void issue(int whiteListMode) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(buffer);
            data.writeByte(4);
            data.writeByte(1);
            data.writeInt(whiteListMode);
            data.close();
            PacketHandler.sendPacket(buffer.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void execute(EntityPlayer player) {
        ItemStack itemStack = player.func_70694_bm();
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77973_b() instanceof ItemAdvIDrill) {
            NBTHelper.saveWhiteListMode(itemStack, this.whiteListMode);
            NBTHelper.saveItemMode(itemStack, this.itemMode);
            NBTHelper.saveExpMode(itemStack, this.expMode);
            NBTHelper.saveFastDespawnMode(itemStack, this.fastDespawnMode);
            NBTHelper.saveTpToHomeMode(itemStack, this.tpToHomeMode);
        } else if (itemStack.func_77973_b() instanceof ItemAdvDDrill) {
            NBTHelper.saveWhiteListMode(itemStack, this.whiteListMode);
        }
    }
}

