/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.utils;

import cpw.mods.fml.common.FMLCommonHandler;
import gravisuite.GraviSuite;
import gravisuite.item.ItemRelocator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;

public class Helpers {
    public static boolean isCorrectTileInventory(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile instanceof IInventory && ((IInventory)tile).func_70302_i_() >= 9;
    }

    public static int addItemToTileInventory(World world, ItemStack itemStack, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory && ((IInventory)tile).func_70302_i_() >= 9) {
            if (itemStack != null && itemStack.field_77994_a >= 1) {
                itemStack = itemStack.func_77946_l();
                IInventory inventory = (IInventory)tile;
                int remaining = itemStack.field_77994_a;
                for (int i = 0; i < inventory.func_70302_i_() && remaining > 0; ++i) {
                    ItemStack slotStack = inventory.func_70301_a(i);
                    if (slotStack == null && inventory.func_94041_b(i, itemStack)) {
                        itemStack.field_77994_a = (remaining -= inventory.func_70297_j_()) > 0 ? inventory.func_70297_j_() : itemStack.field_77994_a;
                        inventory.func_70299_a(i, itemStack);
                        inventory.func_70296_d();
                        continue;
                    }
                    if (slotStack == null || !itemStack.func_77985_e() || !inventory.func_94041_b(i, itemStack) || !slotStack.func_77973_b().equals(itemStack.func_77973_b()) || itemStack.func_77981_g() && itemStack.func_77960_j() != slotStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)slotStack)) continue;
                    int l = slotStack.field_77994_a + remaining;
                    if (l <= itemStack.func_77976_d() && l <= inventory.func_70297_j_()) {
                        remaining = 0;
                        slotStack.field_77994_a = l;
                        inventory.func_70296_d();
                        continue;
                    }
                    if (slotStack.field_77994_a >= itemStack.func_77976_d() || itemStack.func_77976_d() > inventory.func_70297_j_()) continue;
                    remaining -= itemStack.func_77976_d() - slotStack.field_77994_a;
                    slotStack.field_77994_a = itemStack.func_77976_d();
                    inventory.func_70296_d();
                }
                return remaining;
            }
            return 0;
        }
        return -1;
    }

    public static boolean setBlockToAir(World w, int x, int y, int z) {
        return w.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 0);
    }

    public static MovingObjectPosition rayTraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.0;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        if (player instanceof EntityPlayerMP) {
            range = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * range, (double)f6 * range, (double)f8 * range);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof ItemBlock ? ((ItemBlock)item).field_150939_a : null;
    }

    public static boolean canBreakBlock(World world, EntityPlayerMP player, int x, int y, int z) {
        return world.field_72995_K || !ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)world.func_72912_H().func_76077_q(), (EntityPlayerMP)player, (int)x, (int)y, (int)z).isCanceled();
    }

    public static boolean equals(Block block, ItemStack stack) {
        return block == Helpers.getBlock(stack);
    }

    public static String formatMessage(String inputString) {
        return StatCollector.func_74838_a((String)inputString);
    }

    public static Entity teleportEntity(Entity entity, ItemRelocator.TeleportPoint tpPoint) {
        boolean changeDim;
        if (entity.field_70170_p.field_72995_K) {
            return entity;
        }
        boolean bl = changeDim = entity.field_70170_p.field_73011_w.field_76574_g != tpPoint.dimID;
        if (changeDim) {
            Helpers.teleportToDimension(entity, tpPoint);
        } else {
            Entity mount = entity.field_70154_o;
            if (entity.field_70154_o != null) {
                entity.func_70078_a(null);
                mount = Helpers.teleportEntity(mount, tpPoint);
            }
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                player.func_70634_a(tpPoint.x, tpPoint.y, tpPoint.z);
            } else {
                entity.func_70107_b(tpPoint.x, tpPoint.y, tpPoint.z);
            }
            entity.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            if (mount != null) {
                entity.func_70078_a(mount);
            }
        }
        return entity;
    }

    public static Entity teleportToDimension(Entity entity, ItemRelocator.TeleportPoint tpPoint) {
        if (GraviSuite.isSimulating()) {
            EntityPlayerMP player;
            Entity mount = entity.field_70154_o;
            if (entity.field_70154_o != null) {
                entity.func_70078_a(null);
                mount = Helpers.teleportToDimension(mount, tpPoint);
            }
            System.out.println("Teleport entity: " + entity);
            tpPoint.y += 0.5;
            int currentDim = entity.field_70170_p.field_73011_w.field_76574_g;
            MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
            WorldServer currentServer = minecraftServer.func_71218_a(currentDim);
            WorldServer targetServer = minecraftServer.func_71218_a(tpPoint.dimID);
            currentServer.func_72866_a(entity, false);
            if (entity instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)entity;
                player.field_71093_bK = tpPoint.dimID;
                player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                currentServer.func_72973_f((Entity)player);
                player.field_70128_L = false;
            } else {
                entity.field_71093_bK = tpPoint.dimID;
                entity.field_70128_L = false;
            }
            entity.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            targetServer.field_73059_b.func_73158_c((int)tpPoint.x >> 4, (int)tpPoint.z >> 4);
            targetServer.func_72838_d(entity);
            targetServer.func_72866_a(entity, false);
            entity.func_70029_a((World)targetServer);
            if (!(entity instanceof EntityPlayerMP)) {
                NBTTagCompound entityNBT = new NBTTagCompound();
                entity.field_70128_L = false;
                entity.func_70039_c(entityNBT);
                entity.field_70128_L = true;
                entity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)targetServer);
                if (entity == null) {
                    return null;
                }
                entity.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
                targetServer.func_72838_d(entity);
                entity.func_70029_a((World)targetServer);
                entity.field_71093_bK = tpPoint.dimID;
            }
            if (entity instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)entity;
                if (currentServer != null) {
                    currentServer.func_73040_p().func_72695_c(player);
                }
                targetServer.func_73040_p().func_72683_a(player);
                targetServer.field_73059_b.func_73158_c((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
                targetServer.func_72866_a(entity, false);
                player.field_71135_a.func_147364_a(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
                player.field_71134_c.func_73080_a(targetServer);
                player.field_71133_b.func_71203_ab().func_72354_b(player, targetServer);
                player.field_71133_b.func_71203_ab().func_72385_f(player);
                FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, currentDim, tpPoint.dimID);
                player.func_70634_a(tpPoint.x, tpPoint.y, tpPoint.z);
                player.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            }
            entity.func_70012_b(tpPoint.x, tpPoint.y, tpPoint.z, (float)tpPoint.yaw, (float)tpPoint.pitch);
            if (mount != null) {
                if (entity instanceof EntityPlayerMP) {
                    targetServer.func_72866_a(entity, true);
                }
                System.out.println("Mount entity");
                entity.func_70078_a(mount);
                targetServer.func_72939_s();
                Helpers.teleportEntity(entity, tpPoint);
            }
        }
        return entity;
    }

    private static void removeEntityFromWorld(World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71053_j();
            world.field_73010_i.remove(player);
            world.func_72854_c();
            int i = entity.field_70176_ah;
            int j = entity.field_70164_aj;
            if (entity.field_70175_ag && world.func_72863_F().func_73149_a(i, j)) {
                world.func_72964_e(i, j).func_76622_b(entity);
                world.func_72964_e((int)i, (int)j).field_76643_l = true;
            }
            world.field_72996_f.remove(entity);
            world.func_72847_b(entity);
        }
        entity.field_70128_L = false;
    }

    public static boolean isItemInMap(Block block, int blockMeta, List<ItemStack> itemStackList, int x, int y, int z, EntityPlayer player) {
        for (ItemStack itemStack : itemStackList) {
            if (itemStack == null || itemStack.func_77973_b() == null || block != Block.func_149634_a((Item)itemStack.func_77973_b()) || itemStack.func_77960_j() != blockMeta) continue;
            return true;
        }
        ArrayList drops = block.getDrops(player.func_130014_f_(), x, y, z, blockMeta, EnchantmentHelper.func_77517_e((EntityLivingBase)player));
        if (drops != null) {
            for (ItemStack is : drops) {
                for (ItemStack itemStack : itemStackList) {
                    if (!itemStack.func_77973_b().equals(is.func_77973_b()) || itemStack.func_77960_j() != is.func_77960_j()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getLocalizedMessage(String message) {
        Pattern pattern = Pattern.compile("\\{.*?}");
        Matcher matcher = pattern.matcher(message);
        String result = message;
        while (matcher.find()) {
            String group = matcher.group();
            String localGroup = group.replace("{", "");
            localGroup = localGroup.replace("}", "");
            result = result.replace(group, Helpers.formatMessage(localGroup));
        }
        return result;
    }

    public static void dropAsEntity(World world, int x, int y, int z, ItemStack itemStack) {
        if (itemStack != null) {
            double masterOffset = 0.7;
            double xOffset = (double)world.field_73012_v.nextFloat() * masterOffset + (1.0 - masterOffset) * 0.5;
            double yOffset = (double)world.field_73012_v.nextFloat() * masterOffset + (1.0 - masterOffset) * 0.5;
            double zOffset = (double)world.field_73012_v.nextFloat() * masterOffset + (1.0 - masterOffset) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + xOffset, (double)y + yOffset, (double)z + zOffset, itemStack.func_77946_l());
            entityItem.field_145804_b = 10;
            world.func_72838_d((Entity)entityItem);
        }
    }
}

