/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.utils;

import gravisuite.BlockLocation;
import gravisuite.GraviSuite;
import gravisuite.item.ItemAdvIDrill;
import gravisuite.utils.Helpers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class NBTHelper {
    public static int readToolMode(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        int toolMode = nbtTagCompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > (itemStack.func_77973_b() instanceof ItemAdvIDrill ? 4 : 3)) {
            toolMode = 0;
        }
        return toolMode;
    }

    public static void saveToolMode(ItemStack itemStack, int toolMode) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        nbtTagCompound.func_74768_a("toolMode", toolMode);
    }

    public static List<ItemStack> getListBlockMap(ItemStack itemStack, boolean isWhiteList) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        NBTTagList list = nbtTagCompound.func_150295_c(isWhiteList ? "WhiteListItems" : "BlackListItems", 10);
        ArrayList<ItemStack> listItemStack = new ArrayList<ItemStack>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            listItemStack.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
        }
        return listItemStack;
    }

    public static IInventory getInventory(ItemStack itemStack, boolean isWhiteList) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        int size = itemStack.func_77973_b() instanceof ItemAdvIDrill ? 27 : 9;
        InventoryBasic inventory = new InventoryBasic(isWhiteList ? "WhiteList" : "BlackList", false, size);
        NBTTagList list = nbtTagCompound.func_150295_c(isWhiteList ? "WhiteListItems" : "BlackListItems", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)stackTag);
            inventory.func_70299_a(i, is);
        }
        return inventory;
    }

    public static int getWhiteListMode(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        int whiteListMode = nbtTagCompound.func_74762_e("WhiteList");
        return whiteListMode >= 0 && whiteListMode <= 2 ? whiteListMode : 0;
    }

    public static void saveWhiteListMode(ItemStack itemStack, int whiteListMode) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        nbtTagCompound.func_74768_a("WhiteList", whiteListMode);
    }

    public static void saveInventory(ItemStack itemStack, IInventory inventory, boolean isWhiteList) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            ItemStack is = inventory.func_70301_a(i);
            list.func_74742_a((NBTBase)is.func_77955_b(stackTag));
        }
        nbtTagCompound.func_74782_a(isWhiteList ? "WhiteListItems" : "BlackListItems", (NBTBase)list);
    }

    public static int getItemMode(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        int itemMode = nbtTagCompound.func_74762_e("ItemMode");
        if (itemMode < 0 || itemMode > 1) {
            itemMode = 0;
        }
        return itemMode;
    }

    public static void saveItemMode(ItemStack itemStack, int itemMode) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        nbtTagCompound.func_74768_a("ItemMode", itemMode);
    }

    public static int getExpMode(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        int expMode = nbtTagCompound.func_74762_e("ExpMode");
        if (expMode < 0 || expMode > 1) {
            expMode = 0;
        }
        return expMode;
    }

    public static void saveExpMode(ItemStack itemStack, int expMode) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        nbtTagCompound.func_74768_a("ExpMode", expMode);
    }

    public static int getTpToHomeMode(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        int tpToHomeMode = nbtTagCompound.func_74762_e("TpToHomeMode");
        if (tpToHomeMode < 0 || tpToHomeMode > 1) {
            tpToHomeMode = 0;
        }
        return tpToHomeMode;
    }

    public static void saveTpToHomeMode(ItemStack itemStack, int tpToHomeMode) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        nbtTagCompound.func_74768_a("TpToHomeMode", tpToHomeMode);
    }

    public static BlockLocation getHomeLocation(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        NBTTagCompound homeLocation = nbtTagCompound.func_74775_l("HomeLocation");
        BlockLocation blockLocation = new BlockLocation(homeLocation.func_74762_e("X"), homeLocation.func_74762_e("Y"), homeLocation.func_74762_e("Z"));
        if (blockLocation.X == 0 && blockLocation.Y == 0 && blockLocation.Z == 0) {
            return null;
        }
        if (!GraviSuite.isSimulating()) {
            return blockLocation;
        }
        int dimensionID = homeLocation.func_74762_e("WorldID");
        for (WorldServer worldServer : DimensionManager.getWorlds()) {
            if (worldServer.field_73011_w.field_76574_g != dimensionID) continue;
            blockLocation.world = worldServer;
            break;
        }
        return blockLocation.world != null && Helpers.isCorrectTileInventory(blockLocation.world, blockLocation.X, blockLocation.Y, blockLocation.Z) ? blockLocation : null;
    }

    public static void saveHomeLocation(ItemStack itemStack, BlockLocation location) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        NBTTagCompound homeLocation = new NBTTagCompound();
        homeLocation.func_74768_a("X", location.X);
        homeLocation.func_74768_a("Y", location.Y);
        homeLocation.func_74768_a("Z", location.Z);
        homeLocation.func_74768_a("WorldID", location.world.field_73011_w.field_76574_g);
        nbtTagCompound.func_74782_a("HomeLocation", (NBTBase)homeLocation);
    }

    public static int getFastDespawnMode(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        int tpToHomeMode = nbtTagCompound.func_74762_e("FastDespawnMode");
        if (tpToHomeMode < 0 || tpToHomeMode > 1) {
            tpToHomeMode = 0;
        }
        return tpToHomeMode;
    }

    public static void saveFastDespawnMode(ItemStack itemStack, int fastDespawnMode) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        nbtTagCompound.func_74768_a("FastDespawnMode", fastDespawnMode);
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            if (GraviSuite.isSimulating()) {
                itemstack.func_77982_d(nbttagcompound);
            }
            nbttagcompound.func_74768_a("charge", 0);
        }
        return nbttagcompound;
    }
}

