/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.utils;

import gravisuite.network.IPacket;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.file.FileURLConnection;

public class ReflectionHelper {
    public static Set<Class<? extends IPacket>> getPacketClasses(String packageName) {
        HashSet<Class<? extends IPacket>> resultSet = new HashSet<Class<? extends IPacket>>();
        try {
            for (Class<?> localClass : ReflectionHelper.getClassesForPackage(packageName)) {
                if (!localClass.getSuperclass().equals(IPacket.class) || localClass.getField("packetID") == null) continue;
                resultSet.add(localClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e2) {
            e2.printStackTrace();
        }
        return resultSet;
    }

    private static void checkDirectory(File directory, String packageName, ArrayList<Class<?>> classes) throws ClassNotFoundException {
        if (directory.exists() && directory.isDirectory()) {
            String[] files = directory.list();
            for (String file : files != null ? files : new String[]{}) {
                if (file.endsWith(".class")) {
                    try {
                        classes.add(Class.forName(packageName + '.' + file.substring(0, file.length() - 6)));
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                    continue;
                }
                File tmpDirectory = new File(directory, file);
                if (!tmpDirectory.isDirectory()) continue;
                ReflectionHelper.checkDirectory(tmpDirectory, packageName + "." + file, classes);
            }
        }
    }

    private static void checkJarFile(JarURLConnection connection, String packageName, ArrayList<Class<?>> classes) throws ClassNotFoundException, IOException {
        JarFile jarFile = connection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        JarEntry jarEntry = null;
        while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
            String name = jarEntry.getName();
            if (!name.contains(".class") || !(name = name.substring(0, name.length() - 6).replace('/', '.')).contains(packageName)) continue;
            classes.add(Class.forName(name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList<Class<?>> getClassesForPackage(String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(packageName.replace('.', '/'));
            URL url = null;
            while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
                try {
                    URLConnection connection = url.openConnection();
                    if (!(connection instanceof JarURLConnection)) {
                        if (!(connection instanceof FileURLConnection)) throw new ClassNotFoundException(packageName + " (" + url.getPath() + ") does not appear to be a valid package");
                        try {
                            ReflectionHelper.checkDirectory(new File(URLDecoder.decode(url.getPath(), "UTF-8")), packageName, classes);
                            continue;
                        }
                        catch (UnsupportedEncodingException ex) {
                            throw new ClassNotFoundException(packageName + " does not appear to be a valid package (Unsupported encoding)", ex);
                        }
                    }
                    ReflectionHelper.checkJarFile((JarURLConnection)connection, packageName, classes);
                }
                catch (IOException ioException) {
                    throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + packageName, ioException);
                    return classes;
                }
            }
        }
        catch (NullPointerException ex2) {
            throw new ClassNotFoundException(packageName + " does not appear to be a valid package (Null pointer exception)", ex2);
        }
        catch (IOException ioException2) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + packageName, ioException2);
        }
    }
}

