/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gaia.GaiaBlock;
import gaia.GaiaItem;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobBase;
import gaia.entity.ai.EntityAIGaiaAttackOnCollide;
import gaia.entity.ai.EntityAIGaiaCreepSwell;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityGaiaCreep
extends EntityMobBase {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;

    public EntityGaiaCreep(World par1World) {
        super(par1World);
        this.func_70105_a(0.7f, 0.7f);
        this.field_70728_aV = EntityAttributes.experienceValue1;
        this.field_70138_W = 1.0f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIGaiaCreepSwell(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIGaiaAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.maxHealth1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)EntityAttributes.moveSpeed1);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.attackDamage1);
    }

    public int func_70658_aO() {
        return EntityAttributes.rateArmor1;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    protected void func_70069_a(float par1) {
        super.func_70069_a(par1);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + par1 * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (this.field_70180_af.func_75683_a(17) == 1) {
            par1NBTTagCompound.func_74757_a("powered", true);
        }
        par1NBTTagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        par1NBTTagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.field_70180_af.func_75692_b(17, (Object)((byte)(par1NBTTagCompound.func_74767_n("powered") ? 1 : 0)));
        if (par1NBTTagCompound.func_74764_b("Fuse")) {
            this.fuseTime = par1NBTTagCompound.func_74765_d("Fuse");
        }
        if (par1NBTTagCompound.func_74764_b("ExplosionRadius")) {
            this.explosionRadius = par1NBTTagCompound.func_74771_c("ExplosionRadius");
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            this.lastActiveTime = this.timeSinceIgnited;
            int var1 = this.getGaiaCreepState();
            if (var1 > 0 && this.timeSinceIgnited == 0) {
                this.func_85030_a("random.fuse", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += var1;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                if (!this.field_70170_p.field_72995_K) {
                    boolean var2 = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                    if (this.getPowered()) {
                        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)(this.explosionRadius * 2), var2);
                    } else {
                        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius, var2);
                    }
                    this.func_70106_y();
                }
            }
        }
        super.func_70071_h_();
    }

    public void func_70636_d() {
        if (this.func_110143_aJ() <= EntityAttributes.maxHealth1 * 0.1f) {
            this.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 100, 0));
        }
        super.func_70636_d();
    }

    protected String func_70621_aR() {
        return "mob.creeper.say";
    }

    protected String func_70673_aS() {
        return "mob.creeper.death";
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var3 = this.field_70146_Z.nextInt(3 + par2);
        for (int var4 = 0; var4 < var3; ++var4) {
            this.func_145779_a(Items.field_151016_H, 1);
        }
        if (par1 && (this.field_70146_Z.nextInt(10) == 0 || this.field_70146_Z.nextInt(1 + par2) > 0)) {
            this.func_145779_a(Items.field_151016_H, 1);
        }
        if (par1 && (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + par2) > 0)) {
            this.func_70099_a(new ItemStack(GaiaItem.Shard, 1, 0), 0.0f);
        }
    }

    protected void func_70600_l(int par1) {
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                this.func_145779_a(GaiaItem.BagOre, 1);
                break;
            }
            case 1: {
                this.func_145779_a(GaiaItem.SpawnCardCreeperGirl, 1);
                break;
            }
            case 2: {
                this.func_145779_a(Item.func_150898_a((Block)GaiaBlock.DollCreeperGirl), 1);
                break;
            }
            case 3: {
                this.field_70728_aV = EntityAttributes.experienceValue1 * 5;
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        return true;
    }

    public boolean getPowered() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getGaiaCreepFlashIntensity(float par1) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * par1) / (float)(this.fuseTime - 2);
    }

    public int getGaiaCreepState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setGaiaCreepState(int par1) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)par1));
    }

    public void func_70077_a(EntityLightningBolt par1EntityLightningBolt) {
        super.func_70077_a(par1EntityLightningBolt);
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
        if (this.field_70146_Z.nextDouble() >= this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            this.field_70160_al = true;
            float f1 = MathHelper.func_76133_a((double)(par3 * par3 + par5 * par5));
            float f2 = 0.4f;
            this.field_70159_w /= 2.0;
            this.field_70181_x /= 2.0;
            this.field_70179_y /= 2.0;
            this.field_70159_w -= par3 / (double)f1 * (double)f2;
            this.field_70181_x += (double)f2;
            this.field_70179_y -= par5 / (double)f1 * (double)f2;
            if (this.field_70181_x > EntityAttributes.knockback1) {
                this.field_70181_x = EntityAttributes.knockback1;
            }
        }
    }

    public boolean func_70601_bi() {
        return this.field_70163_u < 60.0 && this.field_70163_u > 32.0 && super.func_70601_bi();
    }
}

