/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.info.IC2Classic;
import ic2.api.item.IC2Items;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import speiger.src.crops.api.CropPluginAPI;
import speiger.src.crops.classic.ClassicCaclulator;
import speiger.src.crops.classic.ClassicInfoLoader;
import speiger.src.crops.client.ICalculatorContainer;
import speiger.src.crops.core.CropThreadIniter;
import speiger.src.crops.core.ICropCalculator;
import speiger.src.crops.core.NeiCrops;
import speiger.src.crops.exp.ExpCalculator;
import speiger.src.crops.exp.ExpInfoLoader;
import speiger.src.crops.handler.Handler;

@Mod(modid="Ic2Nei", name="IC2 Nei Plugin", version="1.0", dependencies="required-after:IC2;required-after:NotEnoughItems")
public class IC2NeiPlugin {
    @Mod.Instance(value="Ic2Nei")
    public static IC2NeiPlugin instance;
    public static ICropCalculator calculator;
    public boolean loaded = false;
    @SideOnly(value=Side.CLIENT)
    public NeiCrops crops;
    public static HashMap<CropCard, ItemStack> displayItems;
    public static ArrayList<CropCard> allCrops;
    public static Configuration config;
    public static int maxLoad;
    public static boolean keepBest;
    public static boolean extraInfos;
    public static boolean displayOtherItems;
    public static Item baseCrop;
    public static Item analyzer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void load(FMLPreInitializationEvent event) {
        IC2Classic.IC2Type type = IC2Classic.getLoadedIC2Type();
        if (type == IC2Classic.IC2Type.Experimental) {
            calculator = new ExpCalculator();
            CropPluginAPI.instance.registerCropInfo(new ExpInfoLoader());
            this.loaded = true;
        }
        if (type == IC2Classic.IC2Type.SpeigersClassic) {
            calculator = new ClassicCaclulator();
            CropPluginAPI.instance.registerCropInfo(new ClassicInfoLoader());
            this.loaded = true;
        }
        if (type == IC2Classic.IC2Type.None) {
            event.getModLog().info("Plugin does not load because you have IC2 Not installed or the Version is Invalid");
        }
        config = new Configuration(new File(event.getModConfigurationDirectory().getPath() + "/Spmod/IC2Breed.cfg"));
        try {
            keepBest = Boolean.parseBoolean(config.get("general", "Keep Best", true, String.format("%s%n%s", "This keep only the Best possebilities inside of that Plugin.", "Note that could mean that you could get really much possebilities if you dissable it. Else you may not get all really good ones")).getString());
            extraInfos = Boolean.parseBoolean(config.get("general", "Extra Crop Info", false, "Tells you Special Grow requirements of the Crop").getString());
            maxLoad = Integer.parseInt(config.get("general", "Max Breeding Flowers", 2, String.format("%s%n%s%n%s", "This changes how many crops will be used in the calulator", "It will not effect the loading of MC but the plugin needs longer to load. (Since it has way more possebilities to calculate)", "Pick 2-3-4 one of these numbers. If it is lower or higher it will be not effecting anything.")).getString());
            displayOtherItems = Boolean.parseBoolean(config.get("general", "Change Crop Display Item", false, "Simply Changes the Crop Item in the Calculator/Plugin into Better Indicating once. Dissabled by default").getString());
            if (maxLoad > 4) {
                maxLoad = 4;
            } else if (maxLoad < 2) {
                maxLoad = 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            config.save();
        }
        if (this.loaded) {
            this.crops = new NeiCrops();
            new Handler().load();
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void modsLoaded(FMLLoadCompleteEvent event) {
        if (this.loaded) {
            this.load();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void load() {
        ArrayList<CropCard> list = new ArrayList<CropCard>();
        list.addAll(Crops.instance.getCrops());
        for (int i = 0; i < list.size(); ++i) {
            CropCard card = (CropCard)list.get(i);
            if (card == null) continue;
            allCrops.add(card);
        }
        ItemStack item = IC2Items.getItem((String)"cropSeed");
        if (item != null) {
            baseCrop = item.func_77973_b();
            ArrayList items = new ArrayList();
            baseCrop.func_150895_a(baseCrop, null, items);
            for (ItemStack stack : items) {
                displayItems.put(Crops.instance.getCropCard(stack), stack);
            }
        }
        CropPluginAPI.instance.load(displayItems, IC2Classic.getLoadedIC2Type());
        item = IC2Items.getItem((String)"cropnalyzer");
        if (item != null) {
            analyzer = item.func_77973_b();
        }
        ICalculatorContainer.creativeCrops.init();
        API.registerRecipeHandler((ICraftingHandler)this.crops);
        API.registerUsageHandler((IUsageHandler)this.crops);
        Thread thread = new Thread((Runnable)new CropThreadIniter(), "Crop Calculation Thread");
        thread.start();
    }

    static {
        displayItems = new HashMap();
        allCrops = new ArrayList();
        maxLoad = 2;
        keepBest = true;
        extraInfos = false;
        displayOtherItems = false;
    }
}

