/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.api;

import ic2.api.crops.CropCard;
import ic2.api.info.IC2Classic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import speiger.src.crops.api.ICropCardInfo;
import speiger.src.crops.api.ICropInfo;

public class CropPluginAPI {
    private static List<ICropInfo> toProcess = new ArrayList<ICropInfo>();
    private Map<CropCard, List<String>> extraInfos = new HashMap<CropCard, List<String>>();
    private Map<CropCard, ItemStack> displayItems = new HashMap<CropCard, ItemStack>();
    public static CropPluginAPI instance = new CropPluginAPI();

    public void registerCropInfo(ICropInfo info) {
        if (info != null) {
            toProcess.add(info);
        }
    }

    public ItemStack getDisplayItem(CropCard card) {
        return this.displayItems.get(card);
    }

    public List<String> getExtraInfos(CropCard card) {
        List<String> info = this.extraInfos.get(card);
        if (info == null) {
            info = new ArrayList<String>();
        }
        return info;
    }

    public void load(Map<CropCard, ItemStack> par1, IC2Classic.IC2Type type) {
        for (ICropInfo target : toProcess) {
            List<CropCard> cards = target.getSupportedCrops();
            if (cards == null || cards.isEmpty()) continue;
            for (CropCard card : cards) {
                ItemStack item;
                List<String> data = target.getCropInformation(card);
                if (data != null && !data.isEmpty() && !this.extraInfos.containsKey(card)) {
                    this.extraInfos.put(card, data);
                }
                if ((item = target.getDisplayItems(card)) == null || this.displayItems.containsKey(card)) continue;
                item = item.func_77946_l();
                String name = card.displayName();
                if (type == IC2Classic.IC2Type.Experimental) {
                    name = StatCollector.func_74838_a((String)name);
                }
                item.func_151001_c("Crop " + name);
                this.displayItems.put(card, item);
            }
        }
        toProcess.clear();
        for (CropCard card : par1.keySet()) {
            if (card instanceof ICropCardInfo) {
                ItemStack item;
                ICropCardInfo info = (ICropCardInfo)((Object)card);
                List<String> data = info.getCropInformation();
                if (data != null && !data.isEmpty()) {
                    this.extraInfos.put(card, data);
                }
                if ((item = info.getDisplayItem()) != null) {
                    item = item.func_77946_l();
                    String name = card.displayName();
                    if (type == IC2Classic.IC2Type.Experimental) {
                        name = StatCollector.func_74838_a((String)name);
                    }
                    item.func_151001_c("Crop " + name);
                    this.displayItems.put(card, item);
                }
            }
            if (this.displayItems.containsKey(card)) continue;
            this.displayItems.put(card, par1.get(card));
        }
    }
}

