/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.client;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import speiger.src.crops.IC2NeiPlugin;
import speiger.src.crops.core.CropSorter;
import speiger.src.crops.core.ICropCalculator;

public class ResultInventory
implements IInventory {
    List<ItemStack> items = new ArrayList<ItemStack>();
    final IInventory inv;
    int modifier;
    CropSorter.SortingOption option = CropSorter.SortingOption.Points;
    CropSorter sorter = new CropSorter(this.option, false);
    boolean changeInvert = false;
    boolean invert = false;

    public ResultInventory(IInventory inventory) {
        this.inv = inventory;
    }

    public void addItem(ItemStack par1) {
        this.items.add(par1);
    }

    public void applyModifier(int par1) {
        this.modifier += par1;
        if (this.modifier < 0) {
            this.modifier = 0;
        }
        if (this.modifier >= this.items.size()) {
            this.modifier = this.items.size();
        }
    }

    public void clear() {
        this.items.clear();
        this.modifier = 0;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        if (p_70301_1_ + this.modifier >= this.items.size()) {
            return null;
        }
        return this.items.get(p_70301_1_ + this.modifier);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public String func_145825_b() {
        return "Nothing";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public void calculateResults() {
        this.clear();
        ArrayList<CropCard> pos = new ArrayList<CropCard>();
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack item = this.inv.func_70301_a(i);
            if (item == null || item.func_77973_b() != IC2NeiPlugin.baseCrop && Crops.instance.getCropCard(item) == null) continue;
            pos.add(Crops.instance.getCropCard(item));
        }
        if (pos.size() > 1) {
            List<ICropCalculator.BreedMap> results = IC2NeiPlugin.calculator.getBreedingResults(pos.toArray(new CropCard[0]));
            for (ICropCalculator.BreedMap map : results) {
                ItemStack item = map.getDisplayItem().func_77946_l();
                this.setPoints(item, map.getPoints());
                this.addItem(item);
            }
        }
        Collections.sort(this.items, this.sorter);
    }

    public void setPoints(ItemStack par1, int points) {
        if (!par1.func_77942_o() || !par1.func_77978_p().func_74764_b("display")) {
            NBTTagCompound nbt = new NBTTagCompound();
            par1.func_77983_a("display", (NBTBase)nbt);
        }
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString("Points: " + points));
        NBTTagCompound nbt = par1.func_77978_p().func_74775_l("display");
        nbt.func_74782_a("Lore", (NBTBase)list);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("Points", points);
        par1.func_77983_a("CropData", (NBTBase)data);
    }

    public void updateSorting(boolean shift) {
        if (shift) {
            this.changeInvert = !this.changeInvert;
            return;
        }
        if (!this.changeInvert) {
            switch (this.option) {
                case Points: {
                    this.option = CropSorter.SortingOption.Tier;
                    break;
                }
                case Tier: {
                    this.option = CropSorter.SortingOption.Name;
                    break;
                }
                case Name: {
                    this.option = CropSorter.SortingOption.Registry;
                    break;
                }
                case Registry: {
                    this.option = CropSorter.SortingOption.Points;
                }
            }
        } else {
            this.invert = !this.invert;
        }
        this.sorter = new CropSorter(this.option, this.invert);
    }

    public void sort() {
        if (this.items.isEmpty()) {
            return;
        }
        Collections.sort(this.items, this.sorter);
    }
}

