/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.core;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.util.StackUtil;
import java.util.Comparator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CropSorter
implements Comparator<ItemStack> {
    final SortingOption option;
    final boolean inverted;

    public CropSorter(SortingOption par1, boolean par2) {
        this.option = par1;
        this.inverted = par2;
    }

    @Override
    public int compare(ItemStack par1, ItemStack par2) {
        if (this.option == SortingOption.Points) {
            int pointA = this.getPoints(par1);
            int pointB = this.getPoints(par2);
            if (this.inverted) {
                int holder = pointA;
                pointA = pointB;
                pointB = holder;
            }
            if (pointA > pointB) {
                return -1;
            }
            if (pointB > pointA) {
                return 1;
            }
            return 0;
        }
        if (this.option == SortingOption.Tier) {
            int tierA = this.getTier(par1);
            int tierB = this.getTier(par2);
            if (this.inverted) {
                int holder = tierA;
                tierA = tierB;
                tierB = holder;
            }
            if (tierA > tierB) {
                return -1;
            }
            if (tierB > tierA) {
                return 1;
            }
            return 0;
        }
        if (this.option == SortingOption.Name) {
            int result;
            String nameA = this.getName(par1);
            String nameB = this.getName(par2);
            int n = result = this.inverted ? this.compareStrings(nameB, nameA) : this.compareStrings(nameA, nameB);
            if (result > 1) {
                result = 1;
            }
            if (result < -1) {
                result = -1;
            }
            return result;
        }
        if (this.option == SortingOption.Registry) {
            int idA = this.getID(par1);
            int idB = this.getID(par2);
            if (!this.inverted) {
                int holder = idA;
                idA = idB;
                idB = holder;
            }
            if (idA > idB) {
                return -1;
            }
            if (idB > idA) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public int getID(ItemStack par1) {
        CropCard card = Crops.instance.getCropCard(par1);
        if (card == null) {
            return 0;
        }
        return card.getId();
    }

    public String getName(ItemStack par1) {
        CropCard card = Crops.instance.getCropCard(par1);
        if (card == null) {
            return "No Name";
        }
        return card.displayName();
    }

    public int getTier(ItemStack par1) {
        CropCard card = Crops.instance.getCropCard(par1);
        if (card == null) {
            return 0;
        }
        return card.tier();
    }

    public int getPoints(ItemStack par1) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)par1);
        if (!nbt.func_74764_b("CropData")) {
            return 0;
        }
        return nbt.func_74775_l("CropData").func_74762_e("Points");
    }

    public int compareStrings(String s1, String s2) {
        int n1 = s1.length();
        int n2 = s2.length();
        int min = Math.min(n1, n2);
        for (int i = 0; i < min; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return n1 - n2;
    }

    public static enum SortingOption {
        Points,
        Tier,
        Name,
        Registry;

    }
}

