/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.core;

import ic2.api.crops.CropCard;
import java.util.List;
import net.minecraft.item.ItemStack;
import speiger.src.crops.IC2NeiPlugin;
import speiger.src.crops.api.CropPluginAPI;

public interface ICropCalculator {
    public List<BreedMap> getBreedingResults(CropCard ... var1);

    public static class BreedMap
    implements Comparable {
        CropCard result;
        int points;
        ItemStack displayItem;
        BreedEntry[] component;

        public BreedMap(CropCard par1, int par2, ItemStack par3, BreedEntry ... par4) {
            this.result = par1;
            this.points = par2;
            this.displayItem = par3;
            this.component = par4;
        }

        public BreedEntry[] getComponents() {
            return this.component;
        }

        public CropCard getResult() {
            return this.result;
        }

        public int getPoints() {
            return this.points;
        }

        public ItemStack getDisplayItem() {
            return this.displayItem;
        }

        public boolean isValidRecipe() {
            for (BreedEntry entry : this.component) {
                if (entry.getCrop() != this.result) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BreedMap)) {
                return false;
            }
            BreedMap map = (BreedMap)obj;
            if (map.result != this.result || map.points != this.points) {
                return false;
            }
            if (map.component.length != this.component.length) {
                return false;
            }
            boolean[] flag = new boolean[map.component.length];
            block0: for (int i = 0; i < this.component.length; ++i) {
                for (int x = 0; x < this.component.length; ++x) {
                    if (this.component[i] != map.component[x]) continue;
                    flag[i] = true;
                    continue block0;
                }
            }
            boolean result = false;
            for (boolean data : flag) {
                result = result || data;
            }
            return !result;
        }

        public int hashCode() {
            return this.result.hashCode();
        }

        public int compareTo(Object arg0) {
            return this.compare(this, (BreedMap)arg0);
        }

        public int compare(BreedMap map, BreedMap par2) {
            if (map.getPoints() > par2.getPoints()) {
                return -1;
            }
            if (par2.getPoints() > map.getPoints()) {
                return 1;
            }
            return 0;
        }
    }

    public static class BreedEntry {
        CropCard crop;
        ItemStack displayItem;

        public BreedEntry(CropCard par1) {
            this(par1, IC2NeiPlugin.displayOtherItems ? CropPluginAPI.instance.getDisplayItem(par1) : IC2NeiPlugin.displayItems.get(par1));
        }

        public BreedEntry(CropCard par1, ItemStack par2) {
            this.crop = par1;
            this.displayItem = par2;
        }

        public CropCard getCrop() {
            return this.crop;
        }

        public ItemStack getDisplayItem() {
            return this.displayItem;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BreedEntry)) {
                return false;
            }
            BreedEntry map = (BreedEntry)obj;
            return map.crop == this.crop;
        }

        public int hashCode() {
            return this.crop.hashCode();
        }
    }
}

