/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.core;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.lwjgl.opengl.GL11;
import speiger.src.crops.IC2NeiPlugin;
import speiger.src.crops.api.CropPluginAPI;
import speiger.src.crops.core.ICropCalculator;
import speiger.src.crops.core.LoadingEntry;

@SideOnly(value=Side.CLIENT)
public class NeiCrops
extends TemplateRecipeHandler {
    private static Map<CropCard, List<ICropCalculator.BreedMap>> cropResults = new HashMap<CropCard, List<ICropCalculator.BreedMap>>();
    private static Map<CropCard, List<ICropCalculator.BreedMap>> cropGetting = new HashMap<CropCard, List<ICropCalculator.BreedMap>>();
    public static boolean loaded = false;
    List<LoadingEntry> todo = new ArrayList<LoadingEntry>();

    public String getRecipeName() {
        return "IC2 Crop Breeding";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)10, (int)5, (int)5, (int)166, (int)75);
    }

    public void drawExtras(int recipe) {
        BreedRecipe rec = (BreedRecipe)((Object)this.arecipes.get(recipe));
        GuiDraw.fontRenderer.func_78276_b("Points: " + rec.resultPoints, 20, 20, 0x404040);
        if (IC2NeiPlugin.extraInfos) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)30.0f, (float)38.0f, (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.0f);
            List<String> data = CropPluginAPI.instance.getExtraInfos(rec.getCropResult());
            if (!data.isEmpty()) {
                for (int i = 0; i < data.size(); ++i) {
                    GuiDraw.fontRenderer.func_78276_b(data.get(i), -50, 100 + i * 10, 0x404040);
                }
            }
            GL11.glPopMatrix();
        }
    }

    public String getGuiTexture() {
        return "ic2nei:textures/gui/BreedingGui.png";
    }

    public void init() {
        ArrayList<CropCard> crops = IC2NeiPlugin.allCrops;
        FMLLog.getLogger().info("Init Pre Loading");
        boolean second = IC2NeiPlugin.maxLoad > 2;
        boolean third = IC2NeiPlugin.maxLoad > 3;
        for (int i = 1; i < crops.size(); ++i) {
            for (int x = 1; x < crops.size(); ++x) {
                if (i == x) continue;
                for (int y = 1; second && y < crops.size(); ++y) {
                    if (i == x || i == y || x == y) continue;
                    for (int z = 1; third && z < crops.size(); ++z) {
                        if (i == x || i == y || i == z || x == y || x == z || y == z) continue;
                        this.addEntry(new LoadingEntry((CropCard)crops.get(i), (CropCard)crops.get(x), (CropCard)crops.get(y), (CropCard)crops.get(z)));
                    }
                    this.addEntry(new LoadingEntry((CropCard)crops.get(i), (CropCard)crops.get(x), (CropCard)crops.get(y)));
                }
                this.addEntry(new LoadingEntry((CropCard)crops.get(i), (CropCard)crops.get(x)));
            }
        }
        FMLLog.getLogger().info("Finish Pre Loading");
    }

    public void removeToMuch() {
        HashSet<ICropCalculator.BreedMap> container;
        int points;
        HashMap<CropCard, ICropCalculator.BreedMap> best;
        HashMap<CropCard, List<ICropCalculator.BreedMap>> results = new HashMap<CropCard, List<ICropCalculator.BreedMap>>();
        for (Map.Entry<CropCard, List<ICropCalculator.BreedMap>> entries : cropGetting.entrySet()) {
            best = new HashMap<CropCard, ICropCalculator.BreedMap>();
            for (ICropCalculator.BreedMap map : entries.getValue()) {
                for (ICropCalculator.BreedEntry entry : map.component) {
                    if (best.containsKey(entry.getCrop())) {
                        points = ((ICropCalculator.BreedMap)best.get(entry.getCrop())).getPoints();
                        if (points >= map.getPoints()) continue;
                        best.put(entry.getCrop(), map);
                        continue;
                    }
                    best.put(entry.getCrop(), map);
                }
            }
            container = new HashSet<ICropCalculator.BreedMap>();
            for (ICropCalculator.BreedMap map : best.values()) {
                container.add(map);
            }
            results.put(entries.getKey(), new ArrayList(container));
        }
        cropGetting = results;
        results = new HashMap();
        for (Map.Entry<CropCard, List<ICropCalculator.BreedMap>> entries : cropResults.entrySet()) {
            best = new HashMap();
            for (ICropCalculator.BreedMap map : entries.getValue()) {
                for (ICropCalculator.BreedEntry entry : map.component) {
                    if (best.containsKey(entry.getCrop())) {
                        points = ((ICropCalculator.BreedMap)best.get(entry.getCrop())).getPoints();
                        if (points >= map.getPoints()) continue;
                        best.put(entry.getCrop(), map);
                        continue;
                    }
                    best.put(entry.getCrop(), map);
                }
            }
            container = new HashSet();
            for (ICropCalculator.BreedMap map : best.values()) {
                container.add(map);
            }
            results.put(entries.getKey(), new ArrayList(container));
        }
    }

    public void addEntry(LoadingEntry par1) {
        for (LoadingEntry entry : this.todo) {
            if (!entry.equals(par1)) continue;
            return;
        }
        this.todo.add(par1);
    }

    public boolean hasTodo() {
        return this.todo.size() > 0;
    }

    public void handleEntry() {
        LoadingEntry entry = this.todo.remove(0);
        List<ICropCalculator.BreedMap> map = IC2NeiPlugin.calculator.getBreedingResults(entry.getCards());
        for (CropCard card : entry.getCards()) {
            this.addBreeds(card, map);
        }
    }

    private void check(CropCard par1) {
        if (!cropResults.containsKey(par1)) {
            cropResults.put(par1, new ArrayList());
        }
        if (!cropGetting.containsKey(par1)) {
            cropGetting.put(par1, new ArrayList());
        }
    }

    public void addBreeds(CropCard par2, List<ICropCalculator.BreedMap> par3) {
        this.check(par2);
        List<ICropCalculator.BreedMap> list = cropGetting.get(par2);
        for (ICropCalculator.BreedMap map : par3) {
            if (!map.isValidRecipe() || list.contains(map)) continue;
            list.add(map);
        }
        cropGetting.put(par2, list);
        for (ICropCalculator.BreedMap map : par3) {
            CropCard par1 = map.getResult();
            if (!map.isValidRecipe()) continue;
            this.check(par1);
            HashSet<ICropCalculator.BreedMap> set = new HashSet<ICropCalculator.BreedMap>((Collection)cropResults.get(par1));
            if (!set.contains(map)) {
                set.add(map);
            }
            cropResults.put(par1, new ArrayList(set));
        }
    }

    public String getRecipeID() {
        return "Ic2:breeding";
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result == null || !loaded) {
            super.loadCraftingRecipes(result);
            return;
        }
        CropCard card = Crops.instance.getCropCard(result);
        if (card != null && cropResults.containsKey(card)) {
            for (ICropCalculator.BreedMap map : cropResults.get(card)) {
                this.arecipes.add(new BreedRecipe(map));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        CropCard card;
        if (ingredient == null || !loaded) {
            super.loadUsageRecipes(ingredient);
        }
        if ((card = Crops.instance.getCropCard(ingredient)) != null && cropGetting.containsKey(card)) {
            for (ICropCalculator.BreedMap map : cropGetting.get(card)) {
                this.arecipes.add(new BreedRecipe(map));
            }
        }
    }

    public void sort() {
        for (CropCard card : cropGetting.keySet()) {
            Collections.sort(cropGetting.get(card));
        }
        for (CropCard card : cropResults.keySet()) {
            Collections.sort(cropResults.get(card));
        }
    }

    public class BreedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        CropCard cropResult;
        ItemStack result;
        int resultPoints;
        ICropCalculator.BreedEntry[] comp;

        public BreedRecipe(ICropCalculator.BreedMap map) {
            super((TemplateRecipeHandler)NeiCrops.this);
            this.result = map.getDisplayItem().func_77946_l();
            this.resultPoints = map.getPoints();
            this.comp = map.getComponents();
            this.cropResult = map.getResult();
        }

        public CropCard getCropResult() {
            return this.cropResult;
        }

        public PositionedStack getResult() {
            this.addPoints(this.result, this.resultPoints);
            return new PositionedStack((Object)this.result, 75, 40);
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> ingred = new ArrayList<PositionedStack>();
            for (int i = 0; i < this.comp.length; ++i) {
                int[] data = this.getCoords(i);
                ingred.add(new PositionedStack((Object)this.comp[i].getDisplayItem(), data[0], data[1]));
            }
            return ingred;
        }

        public void addPoints(ItemStack item, int points) {
            NBTTagList list = new NBTTagList();
            list.func_74742_a((NBTBase)new NBTTagString("Breeding Points: " + points));
            item.func_77983_a("Lore", (NBTBase)list);
        }

        public int[] getCoords(int type) {
            switch (type) {
                case 0: {
                    return new int[]{43, 40};
                }
                case 1: {
                    return new int[]{107, 40};
                }
                case 2: {
                    return new int[]{75, 67};
                }
                case 3: {
                    return new int[]{75, 12};
                }
            }
            return new int[0];
        }
    }
}

