/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.crossmod.appeng;

import appeng.tile.crafting.TileCraftingMonitorTile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.crossmod.appeng.CrossAppeng;
import shedar.mods.ic2.nuclearcontrol.crossmod.appeng.TileEntityNetworkLink;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardEnergySensorLocation;
import shedar.mods.ic2.nuclearcontrol.utils.LangHelper;
import shedar.mods.ic2.nuclearcontrol.utils.StringUtils;

public class ItemCardAppeng
extends ItemCardEnergySensorLocation {
    public static final int DISPLAY_BYTES = 1;
    public static final int DISPLAY_ITEMS = 2;
    public static final int DISPLAY_CRAFTER = 4;
    public static final int DISPLAY_CRAFTSTACK = 8;
    public static final UUID CARD_TYPE1 = new UUID(0L, 2L);

    public ItemCardAppeng() {
        this.func_111206_d("nuclearcontrol:cardAEMonitor");
        this.func_77655_b("AppengCard");
    }

    @Override
    public UUID getCardType() {
        return CARD_TYPE1;
    }

    @Override
    public CardState update(World world, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        int targetType = card.getInt("targetType");
        if (targetType == 1) {
            TileEntity check = world.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
            if (check instanceof TileEntityNetworkLink) {
                TileEntityNetworkLink tileNetworkLink = (TileEntityNetworkLink)check;
                card.setInt("ByteTotal", tileNetworkLink.getTOTALBYTES());
                card.setInt("UsedBytes", tileNetworkLink.getUSEDBYTES());
                card.setInt("ItemsTotal", tileNetworkLink.getITEMTYPETOTAL());
                card.setInt("UsedItems", tileNetworkLink.getUSEDITEMTYPE());
                return CardState.OK;
            }
            return CardState.NO_TARGET;
        }
        if (targetType == 2) {
            TileEntity check = world.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
            if (check instanceof TileCraftingMonitorTile) {
                int size;
                Item crafter;
                TileCraftingMonitorTile monitorTile = (TileCraftingMonitorTile)check;
                if (monitorTile.getJobProgress() != null) {
                    crafter = monitorTile.getJobProgress().getItemStack().func_77973_b();
                    size = (int)monitorTile.getJobProgress().getStackSize();
                } else {
                    crafter = CrossAppeng.cardAppeng;
                    size = 0;
                }
                card.setInt("ITEMSTACK", Item.func_150891_b((Item)crafter));
                card.setInt("STACKSIZE", size);
                return CardState.OK;
            }
        } else {
            return CardState.NO_TARGET;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public CardState update(TileEntity panel, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        int targetType = card.getInt("targetType");
        if (targetType == 1) {
            TileEntity check = panel.func_145831_w().func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
            if (check instanceof TileEntityNetworkLink) {
                TileEntityNetworkLink tileNetworkLink = (TileEntityNetworkLink)check;
                card.setInt("ByteTotal", tileNetworkLink.getTOTALBYTES());
                card.setInt("UsedBytes", tileNetworkLink.getUSEDBYTES());
                card.setInt("ItemsTotal", tileNetworkLink.getITEMTYPETOTAL());
                card.setInt("UsedItems", tileNetworkLink.getUSEDITEMTYPE());
                return CardState.OK;
            }
            return CardState.NO_TARGET;
        }
        if (targetType == 2) {
            TileEntity check = panel.func_145831_w().func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
            if (check instanceof TileCraftingMonitorTile) {
                int size;
                Item crafter;
                TileCraftingMonitorTile monitorTile = (TileCraftingMonitorTile)check;
                if (monitorTile.getJobProgress() != null) {
                    crafter = monitorTile.getJobProgress().getItemStack().func_77973_b();
                    size = (int)monitorTile.getJobProgress().getStackSize();
                } else {
                    crafter = CrossAppeng.cardAppeng;
                    size = 0;
                }
                card.setInt("ITEMSTACK", Item.func_150891_b((Item)crafter));
                card.setInt("STACKSIZE", size);
                return CardState.OK;
            }
        } else {
            return CardState.NO_TARGET;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardWrapper card, boolean showLabels) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        int TYPE = card.getInt("targetType");
        if (TYPE == 1) {
            PanelString line;
            int byteTotal = card.getInt("ByteTotal");
            int usedBytes = card.getInt("UsedBytes");
            int items = card.getInt("ItemsTotal");
            int itemsUsed = card.getInt("UsedItems");
            if ((displaySettings & 1) > 0) {
                line = new PanelString();
                line.textRight = String.format(StatCollector.func_74838_a((String)"msg.nc.InfoPanelAE.DisplayBytes"), usedBytes, byteTotal);
                result.add(line);
            }
            if ((displaySettings & 2) > 0) {
                line = new PanelString();
                line.textRight = String.format(StatCollector.func_74838_a((String)"msg.nc.InfoPanelAE.DisplayItem"), itemsUsed, items);
                result.add(line);
            }
        } else if (TYPE == 2) {
            PanelString line;
            int stackSize = card.getInt("STACKSIZE");
            Item item = Item.func_150899_d((int)card.getInt("ITEMSTACK"));
            String localName = "item.null.name";
            try {
                localName = StatCollector.func_74838_a((String)(item.func_77658_a() + ".name"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (localName == "item.null.name" || localName.equals("Applied Energistics Card")) {
                localName = StatCollector.func_74838_a((String)"msg.null.craft");
            }
            if ((displaySettings & 4) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelAE.CraftItemMake", localName, showLabels);
                result.add(line);
            }
            if ((displaySettings & 8) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelAE.CraftAMT", stackSize, showLabels);
                result.add(line);
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(4);
        result.add(new PanelSetting(LangHelper.translate("msg.nc.InfoPanelAE.Bytes"), 1, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.InfoPanelAE.Items"), 2, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.InfoPanelAE.CraftItem"), 4, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.InfoPanelAE.CraftStack"), 8, CARD_TYPE));
        return result;
    }
}

