/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.uncomplication.enet;

import com.denfop.Config;
import com.denfop.IUItem;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.NodeStats;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.block.machine.tileentity.TileEntityMatter;
import ic2.core.block.wiring.TileEntityTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyNetLocal {
    public static double minConductionLoss = 1.0E-4;
    private static Direction[] directions = Direction.values();
    private final World world;
    private final EnergyPathMap energySourceToEnergyPathMap = new EnergyPathMap();
    private final Map<ChunkCoordinates, IEnergyTile> registeredTiles = new HashMap<ChunkCoordinates, IEnergyTile>();
    private final List<IEnergyTile> energyTileList;
    private final Map<ChunkCoordinates, IEnergySource> sources = new HashMap<ChunkCoordinates, IEnergySource>();
    private final WaitingList waitingList = new WaitingList();

    EnergyNetLocal(World world) {
        this.world = world;
        this.energyTileList = new ArrayList<IEnergyTile>();
    }

    public void addTile(TileEntity par1) {
        if (par1 instanceof IMetaDelegate) {
            List tiles = ((IMetaDelegate)par1).getSubTiles();
            for (TileEntity tile : tiles) {
                this.addTileEntity(EnergyNetLocal.coords(tile), par1);
            }
            if (par1 instanceof IEnergySource) {
                this.sources.put(EnergyNetLocal.coords((TileEntity)tiles.get(0)), (IEnergySource)par1);
            }
        } else {
            this.addTileEntity(EnergyNetLocal.coords(par1), par1);
        }
    }

    public void addTileEntity(ChunkCoordinates coords, TileEntity tile) {
        if (!(tile instanceof IEnergyTile) || this.registeredTiles.containsKey(coords)) {
            return;
        }
        this.registeredTiles.put(coords, (IEnergyTile)tile);
        this.update(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (tile instanceof IEnergyAcceptor) {
            this.waitingList.onTileEntityAdded(this.getValidReceivers((IEnergyTile)tile, true), tile);
        }
        if (tile instanceof IEnergySource && !(tile instanceof IMetaDelegate)) {
            this.sources.put(coords, (IEnergySource)tile);
        }
    }

    public void removeTile(TileEntity par1) {
        if (par1 instanceof IMetaDelegate) {
            List tiles = ((IMetaDelegate)par1).getSubTiles();
            for (TileEntity tile : tiles) {
                this.removeTileEntity(EnergyNetLocal.coords(tile), par1);
            }
        } else {
            this.removeTileEntity(EnergyNetLocal.coords(par1), par1);
        }
    }

    public void removeTileEntity(ChunkCoordinates coords, TileEntity tile) {
        if (!(tile instanceof IEnergyTile) || !this.registeredTiles.containsKey(coords)) {
            return;
        }
        this.registeredTiles.remove(coords);
        this.update(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (tile instanceof IEnergyAcceptor) {
            this.energySourceToEnergyPathMap.removeAll(this.energySourceToEnergyPathMap.getSources((IEnergyAcceptor)tile));
            this.waitingList.onTileEntityRemoved(tile);
        }
        if (tile instanceof IEnergySource) {
            this.sources.remove(coords);
            this.energySourceToEnergyPathMap.remove(tile);
        }
    }

    public double emitEnergyFrom(ChunkCoordinates coords, IEnergySource energySource, double amount) {
        if (!this.registeredTiles.containsKey(coords)) {
            return amount;
        }
        if (!this.energySourceToEnergyPathMap.containsKey(energySource)) {
            EnergyPathMap energySourceToEnergyPathMap = this.energySourceToEnergyPathMap;
            TileEntity emitter = (TileEntity)energySource;
            energySourceToEnergyPathMap.put(energySource, this.discover(emitter, energySource.getOfferedEnergy()));
        }
        Vector<EnergyPath> activeEnergyPaths = new Vector<EnergyPath>();
        double totalInvLoss = 0.0;
        double source = energySource.getSourceTier();
        for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(energySource)) {
            assert (energyPath.target instanceof IEnergySink);
            IEnergySink energySink = (IEnergySink)energyPath.target;
            if (energySink.getDemandedEnergy() <= 0.0 || energyPath.loss >= amount || Config.enableIC2EasyMode && this.conductorToWeak(energyPath.conductors, amount)) continue;
            totalInvLoss += 1.0 / energyPath.loss;
            activeEnergyPaths.add(energyPath);
        }
        Collections.shuffle(activeEnergyPaths);
        for (double i = (double)activeEnergyPaths.size() - amount; i > 0.0; i -= 1.0) {
            EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
            totalInvLoss -= 1.0 / removedEnergyPath.loss;
        }
        HashMap<EnergyPath, Double> suppliedEnergyPaths = new HashMap<EnergyPath, Double>();
        while (!activeEnergyPaths.isEmpty() && amount > 0.0) {
            double energyConsumed = 0.0;
            double newTotalInvLoss = 0.0;
            Vector<EnergyPath> currentActiveEnergyPaths = activeEnergyPaths;
            activeEnergyPaths = new Vector();
            for (EnergyPath energyPath2 : currentActiveEnergyPaths) {
                double energyLoss;
                IEnergySink energySink2 = (IEnergySink)energyPath2.target;
                double energyProvided = Math.floor((double)Math.round(amount / totalInvLoss / energyPath2.loss * 100000.0) / 100000.0);
                if (energyProvided > (energyLoss = Math.floor(energyPath2.loss))) {
                    double providing = energyProvided - energyLoss;
                    double adding = Math.min(providing, energySink2.getDemandedEnergy());
                    if (adding <= 0.0) continue;
                    int tier = energySink2.getSinkTier();
                    double accepting = EnergyNet.instance.getPowerFromTier(tier);
                    if (tier >= Integer.MAX_VALUE || accepting <= 0.0) {
                        accepting = 2.147483647E9;
                    }
                    if (providing > accepting) {
                        if (Config.enableIC2EasyMode) continue;
                        this.explodeTiles(energySink2);
                        continue;
                    }
                    double energyReturned = energySink2.injectEnergy(energyPath2.targetDirection.toForgeDirection(), adding, source);
                    if (energyReturned == 0.0) {
                        activeEnergyPaths.add(energyPath2);
                        newTotalInvLoss += 1.0 / energyPath2.loss;
                    } else if (energyReturned >= energyProvided - energyLoss) {
                        energyReturned = energyProvided - energyLoss;
                    }
                    energyConsumed += adding - energyReturned + energyLoss;
                    double energyInjected = adding - energyReturned;
                    if (!suppliedEnergyPaths.containsKey(energyPath2)) {
                        suppliedEnergyPaths.put(energyPath2, energyInjected);
                        continue;
                    }
                    suppliedEnergyPaths.put(energyPath2, energyInjected + (Double)suppliedEnergyPaths.get(energyPath2));
                    continue;
                }
                activeEnergyPaths.add(energyPath2);
                newTotalInvLoss += 1.0 / energyPath2.loss;
            }
            if (energyConsumed == 0.0 && !activeEnergyPaths.isEmpty()) {
                EnergyPath removedEnergyPath2 = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
                newTotalInvLoss -= 1.0 / removedEnergyPath2.loss;
            }
            totalInvLoss = newTotalInvLoss;
            amount -= energyConsumed;
        }
        for (Map.Entry entry : suppliedEnergyPaths.entrySet()) {
            EnergyPath energyPath5;
            EnergyPath energyPath3 = (EnergyPath)entry.getKey();
            double energyInjected2 = (Double)entry.getValue();
            EnergyPath energyPath4 = energyPath5 = energyPath3;
            energyPath5.totalEnergyConducted = (long)((double)energyPath5.totalEnergyConducted + energyInjected2);
            energyPath4.maxSendedEnergy = (long)Math.max((double)energyPath4.maxSendedEnergy, energyInjected2);
            if (energyInjected2 > energyPath3.minInsulationEnergyAbsorption && energyInjected2 >= energyPath3.minInsulationBreakdownEnergy) {
                for (IEnergyConductor energyConductor2 : energyPath3.conductors) {
                    if (!(energyInjected2 >= energyConductor2.getInsulationBreakdownEnergy())) continue;
                    energyConductor2.removeInsulation();
                    if (energyConductor2.getInsulationEnergyAbsorption() >= energyPath3.minInsulationEnergyAbsorption) continue;
                    energyPath3.minInsulationEnergyAbsorption = (int)energyConductor2.getInsulationEnergyAbsorption();
                }
            }
            if (!(energyInjected2 >= energyPath3.minConductorBreakdownEnergy)) continue;
            for (IEnergyConductor energyConductor3 : energyPath3.conductors) {
                if (!(energyInjected2 >= energyConductor3.getConductorBreakdownEnergy()) || Config.enableIC2EasyMode) continue;
                energyConductor3.removeConductor();
            }
        }
        return amount;
    }

    public double getTotalEnergyEmitted(TileEntity tileEntity) {
        double ret = 0.0;
        if (tileEntity instanceof IEnergyConductor) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.getPaths((IEnergyAcceptor)tileEntity)) {
                if (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tileEntity)) continue;
                ret += (double)energyPath.totalEnergyConducted;
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tileEntity)) {
            for (EnergyPath energyPath2 : this.energySourceToEnergyPathMap.get(tileEntity)) {
                ret += (double)energyPath2.totalEnergyConducted;
            }
        }
        return ret;
    }

    public double getTotalEnergySunken(TileEntity tileEntity) {
        double ret = 0.0;
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.getPaths((IEnergyAcceptor)tileEntity)) {
                if ((!(tileEntity instanceof IEnergySink) || energyPath.target != tileEntity) && (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tileEntity))) continue;
                ret += (double)energyPath.totalEnergyConducted;
            }
        }
        return ret;
    }

    private List<EnergyPath> discover(TileEntity emitter, double lossLimit) {
        HashMap<TileEntity, EnergyBlockLink> reachedTileEntities = new HashMap<TileEntity, EnergyBlockLink>();
        LinkedList<TileEntity> tileEntitiesToCheck = new LinkedList<TileEntity>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            TileEntity currentTileEntity = (TileEntity)tileEntitiesToCheck.remove();
            if (currentTileEntity.func_145837_r()) continue;
            double currentLoss = 0.0;
            if (this.registeredTiles.get(EnergyNetLocal.coords(currentTileEntity)) != null && this.registeredTiles.get(EnergyNetLocal.coords(currentTileEntity)) != emitter && reachedTileEntities.containsKey(currentTileEntity)) {
                currentLoss = ((EnergyBlockLink)reachedTileEntities.get((Object)currentTileEntity)).loss;
            }
            List<EnergyTarget> validReceivers = this.getValidReceivers((IEnergyTile)currentTileEntity, false);
            for (EnergyTarget validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                double additionalLoss = 0.0;
                if (validReceiver.tileEntity instanceof IEnergyConductor) {
                    additionalLoss = ((IEnergyConductor)validReceiver.tileEntity).getConductionLoss();
                    if (additionalLoss < 1.0E-4) {
                        additionalLoss = 1.0E-4;
                    }
                    if (currentLoss + additionalLoss >= lossLimit) continue;
                }
                if (reachedTileEntities.containsKey(validReceiver.tileEntity) && ((EnergyBlockLink)reachedTileEntities.get((Object)validReceiver.tileEntity)).loss <= currentLoss + additionalLoss) continue;
                reachedTileEntities.put(validReceiver.tileEntity, new EnergyBlockLink(validReceiver.direction, currentLoss + additionalLoss));
                if (!(validReceiver.tileEntity instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.remove(validReceiver.tileEntity);
                tileEntitiesToCheck.add(validReceiver.tileEntity);
            }
        }
        LinkedList<EnergyPath> energyPaths = new LinkedList<EnergyPath>();
        for (Map.Entry entry : reachedTileEntities.entrySet()) {
            TileEntity tileEntity = (TileEntity)entry.getKey();
            if (!(tileEntity instanceof IEnergySink)) continue;
            EnergyBlockLink energyBlockLink = (EnergyBlockLink)entry.getValue();
            EnergyPath energyPath = new EnergyPath();
            energyPath.loss = Math.max(energyBlockLink.loss, 0.1);
            energyPath.target = tileEntity;
            energyPath.targetDirection = energyBlockLink.direction;
            if (emitter instanceof IEnergySource) {
                while ((tileEntity = EnergyNet.instance.getNeighbor(tileEntity, energyBlockLink.direction.toForgeDirection())) != emitter && tileEntity instanceof IEnergyConductor) {
                    IEnergyConductor energyConductor = (IEnergyConductor)tileEntity;
                    energyPath.conductors.add(energyConductor);
                    if (energyConductor.getInsulationEnergyAbsorption() < energyPath.minInsulationEnergyAbsorption) {
                        energyPath.minInsulationEnergyAbsorption = (int)energyConductor.getInsulationEnergyAbsorption();
                    }
                    if (energyConductor.getInsulationBreakdownEnergy() < energyPath.minInsulationBreakdownEnergy) {
                        energyPath.minInsulationBreakdownEnergy = (int)energyConductor.getInsulationBreakdownEnergy();
                    }
                    if (energyConductor.getConductorBreakdownEnergy() < energyPath.minConductorBreakdownEnergy) {
                        energyPath.minConductorBreakdownEnergy = (int)energyConductor.getConductorBreakdownEnergy();
                    }
                    if ((energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tileEntity)) != null) continue;
                    IC2.platform.displayError("An energy network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: energyBlockLink, tile entities below)\nE: " + emitter + " (" + emitter.field_145851_c + "," + emitter.field_145848_d + "," + emitter.field_145849_e + ")\nC: " + tileEntity + " (" + tileEntity.field_145851_c + "," + tileEntity.field_145848_d + "," + tileEntity.field_145849_e + ")\nR: " + energyPath.target + " (" + energyPath.target.field_145851_c + "," + energyPath.target.field_145848_d + "," + energyPath.target.field_145849_e + ")", new Object[0]);
                }
            }
            energyPaths.add(energyPath);
        }
        return energyPaths;
    }

    private boolean conductorToWeak(Set<IEnergyConductor> par1, double energyToSend) {
        boolean flag = false;
        for (IEnergyConductor cond : par1) {
            if (!(cond.getConductorBreakdownEnergy() <= energyToSend)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private List<EnergyTarget> getValidReceivers(IEnergyTile emitter, boolean reverse) {
        LinkedList<EnergyTarget> validReceivers = new LinkedList<EnergyTarget>();
        for (Direction direction : directions) {
            IEnergyAcceptor receiver2;
            IEnergyEmitter sender2;
            if (emitter instanceof IMetaDelegate) {
                IMetaDelegate meta = (IMetaDelegate)emitter;
                List targets = meta.getSubTiles();
                for (TileEntity tile : targets) {
                    IEnergyAcceptor receiver;
                    IEnergyEmitter sender;
                    TileEntity target = EnergyNet.instance.getNeighbor(tile, direction.toForgeDirection());
                    if (target == emitter || !(target instanceof IEnergyTile) || !this.registeredTiles.containsKey(EnergyNetLocal.coords(target))) continue;
                    Direction inverseDirection = direction.getInverse();
                    if (reverse) {
                        if (!(emitter instanceof IEnergyAcceptor) || !(target instanceof IEnergyEmitter)) continue;
                        sender = (IEnergyEmitter)target;
                        receiver = (IEnergyAcceptor)emitter;
                        if (!sender.emitsEnergyTo((TileEntity)emitter, inverseDirection.toForgeDirection()) || !receiver.acceptsEnergyFrom(target, direction.toForgeDirection())) {
                            continue;
                        }
                    } else {
                        if (!(emitter instanceof IEnergyEmitter) || !(target instanceof IEnergyAcceptor)) continue;
                        sender = (IEnergyEmitter)emitter;
                        receiver = (IEnergyAcceptor)target;
                        if (!sender.emitsEnergyTo(target, direction.toForgeDirection()) || !receiver.acceptsEnergyFrom((TileEntity)emitter, inverseDirection.toForgeDirection())) continue;
                    }
                    validReceivers.add(new EnergyTarget(target, inverseDirection));
                }
                continue;
            }
            TileEntity target2 = EnergyNet.instance.getNeighbor((TileEntity)emitter, direction.toForgeDirection());
            if (!(target2 instanceof IEnergyTile) || !this.registeredTiles.containsKey(EnergyNetLocal.coords(target2))) continue;
            Direction inverseDirection2 = direction.getInverse();
            if (reverse) {
                if (!(emitter instanceof IEnergyAcceptor) || !(target2 instanceof IEnergyEmitter)) continue;
                sender2 = (IEnergyEmitter)target2;
                receiver2 = (IEnergyAcceptor)emitter;
                if (!sender2.emitsEnergyTo((TileEntity)emitter, inverseDirection2.toForgeDirection()) || !receiver2.acceptsEnergyFrom(target2, direction.toForgeDirection())) continue;
                validReceivers.add(new EnergyTarget(target2, inverseDirection2));
                continue;
            }
            if (!(emitter instanceof IEnergyEmitter) || !(target2 instanceof IEnergyAcceptor)) continue;
            sender2 = (IEnergyEmitter)emitter;
            receiver2 = (IEnergyAcceptor)target2;
            if (!sender2.emitsEnergyTo(target2, direction.toForgeDirection()) || !receiver2.acceptsEnergyFrom((TileEntity)emitter, inverseDirection2.toForgeDirection())) continue;
            validReceivers.add(new EnergyTarget(target2, inverseDirection2));
        }
        return validReceivers;
    }

    public List<IEnergySource> discoverFirstPathOrSources(TileEntity par1) {
        HashSet<TileEntity> reached = new HashSet<TileEntity>();
        ArrayList<IEnergySource> result = new ArrayList<IEnergySource>();
        ArrayList<TileEntity> workList = new ArrayList<TileEntity>();
        workList.add(par1);
        while (workList.size() > 0) {
            TileEntity tile = (TileEntity)workList.remove(0);
            if (tile.func_145837_r()) continue;
            List<EnergyTarget> targets = this.getValidReceivers((IEnergyTile)tile, true);
            for (EnergyTarget energyTarget : targets) {
                TileEntity target = energyTarget.tileEntity;
                if (target == par1 || reached.contains(target)) continue;
                reached.add(target);
                if (target instanceof IEnergySource) {
                    result.add((IEnergySource)target);
                    continue;
                }
                if (!(target instanceof IEnergyConductor)) continue;
                workList.add(target);
            }
        }
        return result;
    }

    public static ChunkCoordinates coords(TileEntity par1) {
        if (par1 == null) {
            return null;
        }
        return new ChunkCoordinates(par1.field_145851_c, par1.field_145848_d, par1.field_145849_e);
    }

    public void onTickStart() {
    }

    public void onTickEnd() {
        if (this.waitingList.hasWork()) {
            List<TileEntity> tiles = this.waitingList.getPathTiles();
            for (TileEntity tile : tiles) {
                List<IEnergySource> sources = this.discoverFirstPathOrSources(tile);
                if (sources.size() <= 0) continue;
                this.energySourceToEnergyPathMap.removeAll(sources);
            }
            this.waitingList.clear();
        }
        for (Map.Entry<ChunkCoordinates, IEnergySource> entry : new HashMap<ChunkCoordinates, IEnergySource>(this.sources).entrySet()) {
            double removed;
            double offer;
            IEnergySource source;
            if (entry == null || (source = entry.getValue()) == null) continue;
            if (this.energySourceToEnergyPathMap.containsKey(source)) {
                for (EnergyPath path : this.energySourceToEnergyPathMap.get(source)) {
                    path.totalEnergyConducted = 0L;
                    path.maxSendedEnergy = 0L;
                }
            }
            if (!((offer = source.getOfferedEnergy()) > 0.0)) continue;
            double packetAmount = this.getPacketAmount(source);
            for (double i = 0.0; i < packetAmount && !((offer = source.getOfferedEnergy()) < 1.0) && !((removed = offer - this.emitEnergyFrom(entry.getKey(), source, offer)) <= 0.0); i += 1.0) {
                source.drawEnergy(removed);
            }
        }
    }

    private double getPacketAmount(IEnergySource source) {
        if (source instanceof IMultiEnergySource && ((IMultiEnergySource)source).sendMultibleEnergyPackets()) {
            return ((IMultiEnergySource)source).getMultibleEnergyPacketAmount();
        }
        if (source instanceof TileEntityTransformer) {
            return ((TileEntityTransformer)source).redstone ? 1.0 : 4.0;
        }
        return 1.0;
    }

    public void explodeTiles(IEnergySink sink) {
        this.removeTile((TileEntity)sink);
        if (sink instanceof IMetaDelegate) {
            IMetaDelegate meta = (IMetaDelegate)sink;
            for (TileEntity tile : meta.getSubTiles()) {
                this.explodeMachineAt(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile);
            }
        } else {
            this.explodeMachineAt(((TileEntity)sink).field_145851_c, ((TileEntity)sink).field_145848_d, ((TileEntity)sink).field_145849_e, (TileEntity)sink);
        }
    }

    public TileEntity getTileEntity(int x, int y, int z) {
        ChunkCoordinates coords = new ChunkCoordinates(x, y, z);
        if (this.registeredTiles.containsKey(coords)) {
            return (TileEntity)this.registeredTiles.get(coords);
        }
        return null;
    }

    public NodeStats getNodeStats(TileEntity tile) {
        double emitted = this.getTotalEnergyEmitted(tile);
        double received = this.getTotalEnergySunken(tile);
        return new NodeStats(received, emitted, (double)EnergyNet.instance.getTierFromPower(this.getVoltage(tile)));
    }

    private double getVoltage(TileEntity tileEntity) {
        double voltage = 0.0;
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tileEntity)) {
            for (EnergyPath energyPath2 : this.energySourceToEnergyPathMap.get(tileEntity)) {
                voltage = Math.max(voltage, (double)energyPath2.maxSendedEnergy);
            }
        }
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            for (EnergyPath energyPath3 : this.energySourceToEnergyPathMap.getPaths((IEnergyAcceptor)tileEntity)) {
                if ((!(tileEntity instanceof IEnergySink) || energyPath3.target != tileEntity) && (!(tileEntity instanceof IEnergyConductor) || !energyPath3.conductors.contains(tileEntity))) continue;
                voltage = Math.max(voltage, (double)energyPath3.maxSendedEnergy);
            }
        }
        return voltage;
    }

    void explodeMachineAt(int x, int y, int z, TileEntity tile) {
        if (Config.enableexlposion) {
            this.world.func_147468_f(x, y, z);
            float power = 2.5f;
            if (tile instanceof TileEntityMatter) {
                power = 15.0f;
            }
            ExplosionIC2 explosion = new ExplosionIC2(this.world, null, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, power, 0.75f);
            explosion.doExplosion();
        } else if (this.world.func_147439_a(x, y + 1, z) == null || this.world.func_147438_o(x, y + 1, z) == null) {
            this.world.func_147449_b(x, y + 1, z, IUItem.errorblock);
        }
    }

    void update(int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (!this.world.func_72899_e(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
            this.world.func_147460_e(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, Blocks.field_150350_a);
        }
    }

    public void onUnload() {
        this.energySourceToEnergyPathMap.clear();
        this.registeredTiles.clear();
        this.sources.clear();
        this.waitingList.clear();
    }

    static class PathLogic {
        final List<TileEntity> tiles = new ArrayList<TileEntity>();

        PathLogic() {
        }

        public boolean contains(TileEntity par1) {
            return this.tiles.contains(par1);
        }

        public void add(TileEntity par1) {
            this.tiles.add(par1);
        }

        public void remove(TileEntity par1) {
            this.tiles.remove(par1);
        }

        public void clear() {
            this.tiles.clear();
        }

        public TileEntity getRepresentingTile() {
            if (this.tiles.isEmpty()) {
                return null;
            }
            return this.tiles.get(0);
        }
    }

    class WaitingList {
        final List<PathLogic> paths = new ArrayList<PathLogic>();

        WaitingList() {
        }

        public void onTileEntityAdded(List<EnergyTarget> around, TileEntity tile) {
            if (around.isEmpty() || this.paths.isEmpty()) {
                this.createNewPath(tile);
                return;
            }
            boolean found = false;
            ArrayList<PathLogic> logics = new ArrayList<PathLogic>();
            block0: for (PathLogic logic : this.paths) {
                if (logic.contains(tile)) {
                    found = true;
                    if (!(tile instanceof IEnergyConductor)) continue;
                    logics.add(logic);
                    continue;
                }
                for (EnergyTarget target : around) {
                    if (!logic.contains(target.tileEntity)) continue;
                    found = true;
                    logic.add(tile);
                    if (!(target.tileEntity instanceof IEnergyConductor)) continue block0;
                    logics.add(logic);
                    continue block0;
                }
            }
            if (logics.size() > 1 && tile instanceof IEnergyConductor) {
                PathLogic newLogic = new PathLogic();
                for (PathLogic logic2 : logics) {
                    this.paths.remove(logic2);
                    for (TileEntity toMove : logic2.tiles) {
                        if (newLogic.contains(toMove)) continue;
                        newLogic.add(toMove);
                    }
                    logic2.clear();
                }
                this.paths.add(newLogic);
            }
            if (!found) {
                this.createNewPath(tile);
            }
        }

        public void onTileEntityRemoved(TileEntity par1) {
            if (this.paths.isEmpty()) {
                return;
            }
            ArrayList<TileEntity> toRecalculate = new ArrayList<TileEntity>();
            for (int i = 0; i < this.paths.size(); ++i) {
                PathLogic logic = this.paths.get(i);
                if (!logic.contains(par1)) continue;
                logic.remove(par1);
                toRecalculate.addAll(logic.tiles);
                this.paths.remove(i--);
            }
            for (TileEntity tile : toRecalculate) {
                this.onTileEntityAdded(EnergyNetLocal.this.getValidReceivers((IEnergyTile)tile, true), tile);
            }
        }

        public void createNewPath(TileEntity par1) {
            PathLogic logic = new PathLogic();
            logic.add(par1);
            this.paths.add(logic);
        }

        public void clear() {
            if (this.paths.isEmpty()) {
                return;
            }
            for (PathLogic path : this.paths) {
                path.clear();
            }
            this.paths.clear();
        }

        public boolean hasWork() {
            return this.paths.size() > 0;
        }

        public List<TileEntity> getPathTiles() {
            ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
            for (PathLogic path : this.paths) {
                TileEntity tile = path.getRepresentingTile();
                if (tile == null) continue;
                tiles.add(tile);
            }
            return tiles;
        }
    }

    static class EnergyPathMap {
        final Map<IEnergySource, List<EnergyPath>> senderPath = new HashMap<IEnergySource, List<EnergyPath>>();
        final Map<EnergyPath, IEnergySource> pathToSender = new HashMap<EnergyPath, IEnergySource>();

        EnergyPathMap() {
        }

        public void put(IEnergySource par1, List<EnergyPath> par2) {
            this.senderPath.put(par1, par2);
            for (EnergyPath energyPath : par2) {
                this.pathToSender.put(energyPath, par1);
            }
        }

        public boolean containsKey(Object par1) {
            return this.senderPath.containsKey(par1);
        }

        public List<EnergyPath> get(Object par1) {
            return this.senderPath.get(par1);
        }

        public void remove(Object par1) {
            List<EnergyPath> paths = this.senderPath.remove(par1);
            if (paths != null) {
                for (EnergyPath path : paths) {
                    this.pathToSender.remove(path);
                }
            }
        }

        public void removeAll(List<IEnergySource> par1) {
            for (IEnergySource iEnergySource : par1) {
                this.remove(iEnergySource);
            }
        }

        public List<EnergyPath> getPaths(IEnergyAcceptor par1) {
            ArrayList<EnergyPath> paths = new ArrayList<EnergyPath>();
            for (IEnergySource source : this.getSources(par1)) {
                if (!this.containsKey(source)) continue;
                paths.addAll(this.get(source));
            }
            return paths;
        }

        public List<IEnergySource> getSources(IEnergyAcceptor par1) {
            ArrayList<IEnergySource> source = new ArrayList<IEnergySource>();
            for (Map.Entry<EnergyPath, IEnergySource> entry : this.pathToSender.entrySet()) {
                if (source.contains(entry.getValue())) continue;
                EnergyPath path = entry.getKey();
                if (!(par1 instanceof IEnergyConductor && path.conductors.contains(par1) || par1 instanceof IEnergySink && path.target == par1)) continue;
                source.add(entry.getValue());
            }
            return source;
        }

        public void clear() {
            this.senderPath.clear();
            this.pathToSender.clear();
        }
    }

    static class EnergyPath {
        TileEntity target = null;
        Direction targetDirection;
        final Set<IEnergyConductor> conductors = new HashSet<IEnergyConductor>();
        double loss = 0.0;
        double minInsulationEnergyAbsorption = 2.147483647E9;
        double minInsulationBreakdownEnergy = 2.147483647E9;
        double minConductorBreakdownEnergy = 2.147483647E9;
        long totalEnergyConducted = 0L;
        long maxSendedEnergy = 0L;

        EnergyPath() {
        }
    }

    static class EnergyBlockLink {
        final Direction direction;
        final double loss;

        EnergyBlockLink(Direction direction, double loss) {
            this.direction = direction;
            this.loss = loss;
        }
    }

    static class EnergyTarget {
        final TileEntity tileEntity;
        final Direction direction;

        EnergyTarget(TileEntity tileEntity, Direction direction) {
            this.tileEntity = tileEntity;
            this.direction = direction;
        }
    }
}

