/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.item.upgrade.ItemUpgradeModule;
import com.denfop.tiles.base.TileEntityConverterSolidMatter;
import ic2.api.recipe.RecipeOutput;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidTank;

public class InvSlotRecipes
extends InvSlot {
    private final IBaseRecipe recipe;
    private final IUpdateTick tile;
    private FluidTank tank;

    public InvSlotRecipes(TileEntityInventory base, IBaseRecipe baseRecipe, IUpdateTick tile) {
        super(base, "input", 40, InvSlot.Access.I, baseRecipe.getSize());
        this.recipe = baseRecipe;
        this.tile = tile;
        this.tank = null;
    }

    public InvSlotRecipes(TileEntityInventory base, String baseRecipe, IUpdateTick tile) {
        this(base, Recipes.recipes.getRecipe(baseRecipe), tile);
    }

    public InvSlotRecipes(TileEntityInventory base, String baseRecipe, IUpdateTick tile, FluidTank tank) {
        this(base, Recipes.recipes.getRecipe(baseRecipe), tile);
        this.tank = tank;
    }

    public void put(int index, ItemStack content) {
        super.put(index, content);
        this.tile.setRecipeOutput(this.process());
        this.tile.onUpdate();
    }

    public boolean accepts(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemUpgradeModule);
    }

    public void consume(int number, int amount) {
        this.consume(number, amount, false, false);
    }

    public void consume(int number, int amount, boolean simulate, boolean consumeContainers) {
        ItemStack stack = this.get(number);
        if (stack != null && stack.field_77994_a >= 1 && this.accepts(stack) && (stack.field_77994_a >= 1 || consumeContainers || !stack.func_77973_b().hasContainerItem(stack))) {
            int currentAmount = Math.min(amount, stack.field_77994_a);
            if (!simulate) {
                if (stack.field_77994_a == currentAmount) {
                    if (!consumeContainers && stack.func_77973_b().hasContainerItem(stack)) {
                        this.put(number, stack.func_77973_b().getContainerItem(stack));
                    } else {
                        this.put(number, null);
                    }
                } else {
                    stack.field_77994_a -= currentAmount;
                }
            }
        }
    }

    public ItemStack get(int index) {
        return super.get(index);
    }

    public RecipeOutput process() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != null) continue;
            return null;
        }
        RecipeOutput output = this.getOutputFor();
        if (this.tile instanceof TileEntityConverterSolidMatter) {
            TileEntityConverterSolidMatter mechanism = (TileEntityConverterSolidMatter)((Object)this.tile);
            mechanism.getrequiredmatter(output);
        }
        return output;
    }

    public RecipeOutput consume() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != null) continue;
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.size(); ++i) {
            list.add(this.get(i));
        }
        if (this.tank == null) {
            return Recipes.recipes.getRecipeOutput(this.recipe.getName(), this.recipe.consume(), list);
        }
        return Recipes.recipes.getRecipeOutputFluid(this.recipe.getName(), this.recipe.consume(), list, this.tank);
    }

    private RecipeOutput getOutputFor() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.size(); ++i) {
            list.add(this.get(i));
        }
        if (this.tank == null) {
            return Recipes.recipes.getRecipeOutput(this.recipe.getName(), false, list);
        }
        return Recipes.recipes.getRecipeOutputFluid(this.recipe.getName(), false, list, this.tank);
    }
}

