/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.upgrade;

import com.denfop.IUItem;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.IUpgradeSystem;
import com.denfop.api.upgrade.IUpgradeWithBlackList;
import com.denfop.api.upgrade.UpgradeItemInform;
import com.denfop.api.upgrade.UpgradeModificator;
import com.denfop.api.upgrade.event.EventItemBlackListLoad;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.utils.EnumInfoUpgradeModules;
import com.denfop.utils.ModUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class BaseUpgradeSystem
implements IUpgradeSystem {
    Map<Integer, List<UpgradeItemInform>> map = new HashMap<Integer, List<UpgradeItemInform>>();
    Map<Integer, List<UpgradeModificator>> map_modification;
    Map<Integer, ItemStack> map_stack;
    Map<Integer, Integer> map_col;
    Map<Integer, List<String>> map_blackList = new HashMap<Integer, List<String>>();
    List<UpgradeModificator> list_modificators;
    int max = 0;

    public BaseUpgradeSystem() {
        this.map_col = new HashMap<Integer, Integer>();
        this.map_stack = new HashMap<Integer, ItemStack>();
        this.list_modificators = new ArrayList<UpgradeModificator>();
        this.list_modificators.add(new UpgradeModificator(new ItemStack(IUItem.core, 1, 7)));
        this.list_modificators.add(new UpgradeModificator(new ItemStack(IUItem.neutroniumingot, 1)));
        this.map_modification = new HashMap<Integer, List<UpgradeModificator>>();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void loadItem(EventItemLoad event) {
        this.updateListFromNBT(event.item, event.stack);
        event.item.setUpdate(true);
    }

    @SubscribeEvent
    public void loadItem(EventItemBlackListLoad event) {
        this.updateBlackListFromNBT(event.item, event.stack, event.nbt);
        event.item.setUpdate(true);
    }

    @Override
    public boolean getModifications(ItemStack item) {
        return this.map_modification.containsKey(ModUtils.nbt(item).func_74762_e("ID_Item"));
    }

    @Override
    public List<UpgradeModificator> getListModifications(ItemStack item) {
        return this.getModifications(item) ? this.map_modification.get(ModUtils.nbt(item).func_74762_e("ID_Item")) : new ArrayList<UpgradeModificator>();
    }

    @Override
    public int getRemaining(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        return this.map_col.getOrDefault(id, 4);
    }

    @Override
    public boolean hasBlackList(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        return this.map_blackList.containsKey(id);
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        if (!this.map_stack.containsKey(id)) {
            return false;
        }
        ItemStack item = this.map_stack.get(id);
        int id1 = ModUtils.nbt(item).func_74762_e("ID_Item");
        return item.func_77969_a(stack) && id1 == id;
    }

    @Override
    public List<String> getBlackList(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        return this.map_blackList.containsKey(id) ? this.map_blackList.get(id) : new ArrayList<String>();
    }

    @Override
    public List<UpgradeItemInform> getInformation(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        return this.map.containsKey(id) ? this.map.get(id) : new ArrayList<UpgradeItemInform>();
    }

    @Override
    public UpgradeItemInform getModules(EnumInfoUpgradeModules module, ItemStack item) {
        List<UpgradeItemInform> list = this.getInformation(item);
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumInfoUpgradeModules module, ItemStack item) {
        List<UpgradeItemInform> list = this.getInformation(item);
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(IUpgradeItem item, ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        boolean hasID = nbt.func_74767_n("hasID");
        int id = nbt.func_74762_e("ID_Item");
        if (!hasID) {
            id = this.max++;
            nbt.func_74768_a("ID_Item", id);
            nbt.func_74757_a("hasID", true);
        }
        ArrayList<EnumInfoUpgradeModules> lst = new ArrayList<EnumInfoUpgradeModules>();
        ArrayList<UpgradeModificator> list = new ArrayList<UpgradeModificator>();
        for (int i = 0; i < 2; ++i) {
            String name = nbt.func_74779_i("modification_module" + i);
            if (this.getModification(name) == null) continue;
            list.add(this.getModification(name));
        }
        if (this.map_modification.containsKey(id)) {
            this.map_modification.replace(id, list);
        } else {
            this.map_modification.put(id, list);
        }
        int empty = 0;
        boolean canupgrade = false;
        for (int i = 0; i < 4; ++i) {
            String name = nbt.func_74779_i("mode_module" + i);
            if (name.equals("")) {
                ++empty;
                canupgrade = true;
            }
            if (name.equals("")) continue;
            int index = IUItem.list.indexOf(name);
            lst.add(EnumInfoUpgradeModules.getFromID(index));
        }
        int ost = empty;
        nbt.func_74757_a("canupgrade", canupgrade);
        if (this.map_col.containsKey(id)) {
            this.map_col.replace(id, ost);
        } else {
            this.map_col.put(id, ost);
        }
        this.setInformation(item, lst, stack);
    }

    private UpgradeModificator getModification(String name) {
        if (name.equals("0")) {
            return this.list_modificators.get(0);
        }
        if (name.equals("1")) {
            return this.list_modificators.get(1);
        }
        return null;
    }

    @Override
    public void setInformation(IUpgradeItem item, List<EnumInfoUpgradeModules> lst, ItemStack stack) {
        this.write(item, lst, stack);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.map.clear();
        this.map_blackList.clear();
        this.max = 0;
        this.map_col.clear();
        this.map_stack.clear();
        this.list_modificators.clear();
        this.map_modification.clear();
    }

    @Override
    public void write(IUpgradeItem item, List<EnumInfoUpgradeModules> lst, ItemStack stack) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Object upgrade : lst) {
            if (map.containsKey(upgrade)) {
                map.replace(upgrade, (Integer)map.get(upgrade) + 1);
                continue;
            }
            map.put(upgrade, 1);
        }
        ArrayList<UpgradeItemInform> list = new ArrayList<UpgradeItemInform>();
        for (Map.Entry entry : map.entrySet()) {
            list.add(new UpgradeItemInform((EnumInfoUpgradeModules)((Object)entry.getKey()), (Integer)entry.getValue()));
        }
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int n = nbt.func_74762_e("ID_Item");
        if (!this.map.containsKey(n)) {
            this.map.put(n, list);
            this.map_stack.put(n, stack);
        } else {
            this.map.replace(n, list);
            this.map_stack.replace(n, stack);
        }
        Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (this.hasModules(EnumInfoUpgradeModules.SILK_TOUCH, stack)) {
            enchantmentMap.put(Enchantment.field_77348_q, 1);
        } else {
            enchantmentMap.remove(Enchantment.field_77348_q);
        }
        if (this.hasModules(EnumInfoUpgradeModules.LUCKY, stack)) {
            enchantmentMap.put(Enchantment.field_77346_s, this.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.LUCKY, (ItemStack)stack).number);
        } else {
            enchantmentMap.remove(Enchantment.field_77346_s);
        }
        if (this.hasModules(EnumInfoUpgradeModules.EFFICIENT, stack)) {
            enchantmentMap.put(Enchantment.field_77349_p, 1 + (this.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.EFFICIENT, (ItemStack)stack).number - 1) * 2);
        } else {
            enchantmentMap.remove(Enchantment.field_77349_p);
        }
        if (this.hasModules(EnumInfoUpgradeModules.FIRE, stack)) {
            enchantmentMap.put(Enchantment.field_77334_n, this.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.FIRE, (ItemStack)stack).number);
        } else {
            enchantmentMap.remove(Enchantment.field_77334_n);
        }
        if (this.hasModules(EnumInfoUpgradeModules.LOOT, stack)) {
            enchantmentMap.put(Enchantment.field_77335_o, this.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.LOOT, (ItemStack)stack).number);
        } else {
            enchantmentMap.remove(Enchantment.field_77335_o);
        }
        if (this.hasModules(EnumInfoUpgradeModules.PROTECTION_ARROW, stack)) {
            enchantmentMap.put(Enchantment.field_77328_g, 1 + (this.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION_ARROW, (ItemStack)stack).number - 1) * 2);
        } else {
            enchantmentMap.remove(Enchantment.field_77328_g);
        }
        EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)stack);
    }

    @Override
    public void updateBlackListFromNBT(IUpgradeWithBlackList item, ItemStack stack, NBTTagCompound nbt) {
        this.updateListFromNBT(item, stack);
        ArrayList<String> lst = new ArrayList<String>();
        for (int j = 0; j < 18; ++j) {
            String l = "number_" + j;
            if (nbt.func_74779_i(l).isEmpty()) continue;
            lst.add(nbt.func_74779_i(l));
        }
        nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        nbt.func_74757_a("accept_blacklist", true);
        if (this.map_blackList.containsKey(id)) {
            this.map_blackList.replace(id, lst);
        } else {
            this.map_blackList.put(id, lst);
        }
    }

    @Override
    public void removeUpdate(ItemStack stack, World world, int index) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74778_a("mode_module" + index, "");
        MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, (IUpgradeItem)stack.func_77973_b(), stack));
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        NBTTagCompound nbt = ModUtils.nbt(stack);
        for (int i = 0; i < 4; ++i) {
            String name = nbt.func_74779_i("mode_module" + i);
            if (!name.equals("")) {
                int index = IUItem.list.indexOf(name);
                list.add(new ItemStack(IUItem.upgrademodule, 1, index));
                continue;
            }
            list.add(null);
        }
        return list;
    }
}

