/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.upgrade;

import com.denfop.utils.EnumInfoUpgradeModules;
import com.denfop.utils.ModUtils;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class UpgradeItemInform {
    public final EnumInfoUpgradeModules upgrade;
    public final int number;

    public UpgradeItemInform(EnumInfoUpgradeModules modules, int number) {
        this.upgrade = modules;
        this.number = number;
    }

    public boolean matched(EnumInfoUpgradeModules modules) {
        return this.upgrade.name.equals(modules.name);
    }

    public int getInformation(EnumInfoUpgradeModules modules) {
        if (this.upgrade.name.equals(modules.name)) {
            return this.number;
        }
        return 0;
    }

    public String getName() {
        switch (this.upgrade) {
            case GENDAY: {
                return EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"genday") + EnumChatFormatting.GREEN + ModUtils.getString(0.05 * (double)this.number * 100.0) + "%";
            }
            case GENNIGHT: {
                return EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gennight") + EnumChatFormatting.GREEN + ModUtils.getString(0.05 * (double)this.number * 100.0) + "%";
            }
            case PROTECTION: {
                return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"protect") + EnumChatFormatting.GREEN + ModUtils.getString(0.2 * (double)this.number * 100.0) + "%";
            }
            case EFFICIENCY: {
                return EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)"speed") + EnumChatFormatting.GREEN + ModUtils.getString(0.2 * (double)this.number * 100.0) + "%";
            }
            case BOWENERGY: {
                return EnumChatFormatting.RED + StatCollector.func_74838_a((String)"bowenergy") + EnumChatFormatting.GREEN + ModUtils.getString(0.1 * (double)this.number * 100.0) + "%";
            }
            case SABERENERGY: {
                return EnumChatFormatting.RED + StatCollector.func_74838_a((String)"saberenergy") + EnumChatFormatting.GREEN + ModUtils.getString(0.15 * (double)this.number * 100.0) + "%";
            }
            case DIG_DEPTH: {
                return EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"depth") + EnumChatFormatting.GREEN + this.number;
            }
            case FIRE_PROTECTION: {
                return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"fireResistance");
            }
            case WATER: {
                return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"waterBreathing");
            }
            case SPEED: {
                return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"moveSpeed");
            }
            case JUMP: {
                return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"jump");
            }
            case BOWDAMAGE: {
                return EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"bowdamage") + EnumChatFormatting.GREEN + ModUtils.getString(0.25 * (double)this.number * 100.0) + "%";
            }
            case SABER_DAMAGE: {
                return EnumChatFormatting.DARK_AQUA + StatCollector.func_74838_a((String)"saberdamage") + EnumChatFormatting.GREEN + ModUtils.getString(0.15 * (double)this.number * 100.0) + "%";
            }
            case AOE_DIG: {
                return EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"aoe") + EnumChatFormatting.GREEN + this.number;
            }
            case FLYSPEED: {
                return EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"speedfly") + EnumChatFormatting.GREEN + ModUtils.getString(0.1 * (double)this.number / 0.2 * 100.0) + "%";
            }
            case STORAGE: {
                return EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"storage") + EnumChatFormatting.GREEN + ModUtils.getString(0.05 * (double)this.number * 100.0) + "%";
            }
            case ENERGY: {
                return EnumChatFormatting.RED + StatCollector.func_74838_a((String)"energy_less_use") + EnumChatFormatting.GREEN + ModUtils.getString(0.25 * (double)this.number * 100.0) + "%";
            }
            case VAMPIRES: {
                return EnumChatFormatting.RED + StatCollector.func_74838_a((String)"vampires") + EnumChatFormatting.GREEN + ModUtils.getString(this.number);
            }
            case RESISTANCE: {
                return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"resistance") + EnumChatFormatting.GREEN + ModUtils.getString(this.number);
            }
            case POISON: {
                return EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"poison");
            }
            case WITHER: {
                return EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"wither");
            }
            case SILK_TOUCH: {
                return EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"silk");
            }
            case INVISIBILITY: {
                return EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"invisibility");
            }
            case LOOT: {
                return EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"loot") + EnumChatFormatting.GREEN + ModUtils.getString(this.number);
            }
            case FIRE: {
                return EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"fire") + EnumChatFormatting.GREEN + ModUtils.getString(this.number);
            }
            case REPAIRED: {
                return EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"repaired") + EnumChatFormatting.GREEN + 0.001 * (double)this.number + "%";
            }
            case LUCKY: {
                return EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"lucky") + EnumChatFormatting.GREEN + this.number;
            }
            case EFFICIENT: {
                return EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"efficient") + EnumChatFormatting.GREEN + (1 + (this.number - 1) * 2);
            }
            case SMELTER: {
                return EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"iu.smelter");
            }
            case NIGTHVISION: {
                return EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"iu.nightvision");
            }
            case THORNS: {
                return EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"iu.thorns") + EnumChatFormatting.GREEN + this.number;
            }
            case EXPERIENCE: {
                return EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"iu.experience") + EnumChatFormatting.GOLD + this.number * 50 + "%";
            }
            case BLINDNESS: {
                return EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"iu.blindness");
            }
            case PROTECTION_ARROW: {
                return EnumChatFormatting.RED + StatCollector.func_74838_a((String)"iu.protection_arrow") + EnumChatFormatting.DARK_PURPLE + (1 + (this.number - 1) * 2);
            }
            case FALLING_DAMAGE: {
                return EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"iu.falling_damage") + EnumChatFormatting.DARK_GREEN + this.number * 25 + "%";
            }
            case MACERATOR: {
                return EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"iu.macerator");
            }
            case COMB_MACERATOR: {
                return EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"iu.comb_macerator");
            }
            case RANDOM: {
                return EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"iu.random") + 0.001 * (double)this.number + "%";
            }
            case HUNGRY: {
                return EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"iu.hungry");
            }
            case GENERATOR: {
                return EnumChatFormatting.DARK_AQUA + StatCollector.func_74838_a((String)"iu.generator");
            }
        }
        return "";
    }
}

