/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.audio;

import com.denfop.IUCore;
import com.denfop.audio.AudioManagerClient;
import com.denfop.audio.AudioPosition;
import com.denfop.audio.AudioSource;
import com.denfop.audio.PositionSpec;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.util.LogCategory;
import ic2.core.util.Util;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import paulscode.sound.SoundSystem;

@SideOnly(value=Side.CLIENT)
public final class AudioSourceClient
extends AudioSource
implements Comparable<AudioSourceClient> {
    private final SoundSystem soundSystem;
    private final Reference<Object> obj;
    private final PositionSpec positionSpec;
    private String sourceName;
    private boolean valid = false;
    private boolean culled = false;
    private AudioPosition position;
    private float configuredVolume;
    private float realVolume;
    private boolean isPlaying = false;

    public AudioSourceClient(SoundSystem soundSystem1, String sourceName1, Object obj1, PositionSpec positionSpec1, String initialSoundFile, boolean loop, boolean priorized, float volume) {
        this.soundSystem = soundSystem1;
        this.sourceName = sourceName1;
        this.obj = new WeakReference<Object>(obj1);
        this.positionSpec = positionSpec1;
        URL url = AudioSource.class.getClassLoader().getResource("assets/industrialupgrade/sounds/" + initialSoundFile);
        if (url == null) {
            url = AudioSource.class.getClassLoader().getResource("ic2/sounds/" + initialSoundFile);
        }
        if (url == null) {
            IC2.log.warn(LogCategory.Audio, "Invalid sound file: %s.", new Object[]{initialSoundFile});
            return;
        }
        this.position = AudioPosition.getFrom(obj1);
        soundSystem1.newSource(priorized, sourceName1, url, initialSoundFile, loop, this.position.x, this.position.y, this.position.z, 0, ((AudioManagerClient)IUCore.audioManager).fadingDistance * Math.max(volume, 1.0f));
        this.valid = true;
        this.setVolume(volume);
    }

    @Override
    public int compareTo(@NotNull AudioSourceClient x) {
        if (this.culled) {
            return (int)((this.realVolume * 0.9f - x.realVolume) * 128.0f);
        }
        return (int)((this.realVolume - x.realVolume) * 128.0f);
    }

    @Override
    public void remove() {
        if (this.check()) {
            return;
        }
        if (this.sourceName == null) {
            return;
        }
        this.stop();
        this.soundSystem.removeSource(this.sourceName);
        this.sourceName = null;
        this.valid = false;
    }

    @Override
    public void play() {
        if (this.check()) {
            return;
        }
        if (this.isPlaying) {
            return;
        }
        this.isPlaying = true;
        if (this.culled) {
            return;
        }
        this.soundSystem.play(this.sourceName);
    }

    @Override
    public void stop() {
        if (this.check() || !this.isPlaying) {
            return;
        }
        this.isPlaying = false;
        if (this.culled) {
            return;
        }
        this.soundSystem.stop(this.sourceName);
    }

    @Override
    public void cull() {
        if (this.check() || this.culled) {
            return;
        }
        this.soundSystem.cull(this.sourceName);
        this.culled = true;
    }

    @Override
    public void activate() {
        if (this.check() || !this.culled) {
            return;
        }
        this.soundSystem.activate(this.sourceName);
        this.culled = false;
        if (this.isPlaying) {
            this.isPlaying = false;
            this.play();
        }
    }

    @Override
    public float getRealVolume() {
        return this.realVolume;
    }

    private void setVolume(float volume) {
        if (this.check()) {
            return;
        }
        this.configuredVolume = volume;
        this.soundSystem.setVolume(this.sourceName, 0.001f);
    }

    @Override
    public void updateVolume(EntityPlayer player) {
        float distance;
        if (this.check() || !this.isPlaying) {
            this.realVolume = 0.0f;
            return;
        }
        float maxDistance = ((AudioManagerClient)IUCore.audioManager).fadingDistance * Math.max(this.configuredVolume, 1.0f);
        float rolloffFactor = 1.0f;
        float referenceDistance = 1.0f;
        float x = (float)player.field_70165_t;
        float y = (float)player.field_70163_u;
        float z = (float)player.field_70161_v;
        if (this.position != null && this.position.getWorld() == player.field_70170_p) {
            float deltaX = this.position.x - x;
            float deltaY = this.position.y - y;
            float deltaZ = this.position.z - z;
            distance = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        } else {
            distance = Float.POSITIVE_INFINITY;
        }
        if (distance > maxDistance) {
            this.realVolume = 0.0f;
            this.cull();
            return;
        }
        if (distance < 1.0f) {
            distance = 1.0f;
        }
        float gain = 1.0f - 1.0f * (distance - 1.0f) / (maxDistance - 1.0f);
        float newRealVolume = gain * this.configuredVolume * IC2.audioManager.getMasterVolume();
        float dx = (this.position.x - x) / distance;
        float dy = (this.position.y - y) / distance;
        float dz = (this.position.z - z) / distance;
        if ((double)newRealVolume > 0.1) {
            int i = 0;
            while ((float)i < distance) {
                int zi;
                int yi;
                int xi = Util.roundToNegInf((float)x);
                Block block = player.field_70170_p.func_147439_a(xi, yi = Util.roundToNegInf((float)y), zi = Util.roundToNegInf((float)z));
                if (!block.isAir((IBlockAccess)player.field_70170_p, xi, yi, zi)) {
                    newRealVolume = block.isNormalCube((IBlockAccess)player.field_70170_p, xi, yi, zi) ? (newRealVolume *= 0.6f) : (newRealVolume *= 0.8f);
                }
                x += dx;
                y += dy;
                z += dz;
                ++i;
            }
        }
        if ((double)Math.abs(this.realVolume / newRealVolume - 1.0f) > 0.06) {
            this.soundSystem.setVolume(this.sourceName, IUCore.audioManager.getMasterVolume() * Math.min(newRealVolume, 1.0f));
        }
        this.realVolume = newRealVolume;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean check() {
        if (this.valid) {
            if (!IUCore.audioManager.valid()) return false;
        }
        this.valid = false;
        if (false) return false;
        return true;
    }
}

