/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.block.base;

import com.denfop.block.base.BlockIUFluid;
import com.denfop.fluid.IUFluid;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BlocksItems {
    private static final Map<String, Fluid> fluids = new HashMap<String, Fluid>();
    private static final Map<String, Block> fluidBlocks = new HashMap<String, Block>();
    private static final Map<String, String> renames = new HashMap<String, String>();
    private static final Set<String> dropped = new HashSet<String>();
    public static Material fluid = new MaterialLiquid(MapColor.field_151656_f);

    public static void init() {
        BlocksItems.initFluids();
    }

    private static void initFluids() {
        BlocksItems.registerIC2fluid("fluidNeutron", 3867955, 3000, 300, false);
        BlocksItems.registerIC2fluid("fluidHelium", 10983500, 1000, 300, true);
        BlocksItems.registerIC2fluid("fluidbenz", 3867955, 3000, 500, false);
        BlocksItems.registerIC2fluid("fluiddizel", 3867955, 3000, 500, false);
        BlocksItems.registerIC2fluid("fluidneft", 3867955, 3000, 500, false);
        BlocksItems.registerIC2fluid("fluidpolyeth", 3867955, 3000, 2000, true);
        BlocksItems.registerIC2fluid("fluidpolyprop", 3867955, 3000, 2000, true);
        BlocksItems.registerIC2fluid("fluidoxy", 3867955, 3000, 500, false);
        BlocksItems.registerIC2fluid("fluidhyd", 3867955, 3000, 500, false);
    }

    private static void registerIC2fluid(String internalName, int color, int density, int temperature, boolean isGaseous) {
        Block block = null;
        String fluidName = internalName.substring("fluid".length()).toLowerCase(Locale.ENGLISH);
        Fluid fluid = new IUFluid(fluidName).setDensity(density).setViscosity(3000).setLuminosity(0).setTemperature(temperature).setGaseous(isGaseous);
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            fluid = FluidRegistry.getFluid((String)fluidName);
        }
        if (!fluid.canBePlacedInWorld()) {
            BlockIUFluid blockIC2Fluid = new BlockIUFluid(internalName, fluid, temperature >= 3000 ? Material.field_151587_i : Material.field_151586_h, color);
            fluid.setBlock((Block)blockIC2Fluid);
            fluid.setUnlocalizedName(blockIC2Fluid.func_149739_a());
        } else {
            block = fluid.getBlock();
        }
        fluids.put(internalName, fluid);
        fluidBlocks.put(internalName, block);
    }

    public static void onMissingMappings(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (!mapping.name.startsWith("industrialupgrade:")) continue;
            String subName = mapping.name.substring("industrialupgrade".length() + 1);
            String newName = renames.get(subName);
            if (newName != null) {
                String name = "industrialupgrade:" + newName;
                if (mapping.type == GameRegistry.Type.BLOCK) {
                    mapping.remap((Block)GameData.getBlockRegistry().getRaw(name));
                    continue;
                }
                mapping.remap((Item)GameData.getItemRegistry().getRaw(name));
                continue;
            }
            if (!dropped.contains(subName)) continue;
            mapping.ignore();
        }
    }

    @SubscribeEvent
    public void textureHook(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            for (Map.Entry<String, Fluid> entry : fluids.entrySet()) {
                IIcon still = event.map.func_94245_a("industrialupgrade:blocks/" + entry.getKey().substring(entry.getKey().indexOf("d") + 1).toLowerCase() + "_still");
                IIcon flow = event.map.func_94245_a("industrialupgrade:blocks/" + entry.getKey().substring(entry.getKey().indexOf("d") + 1).toLowerCase() + "_flow");
                Fluid fluid = entry.getValue();
                fluid.setIcons(still, flow);
            }
        }
    }

    public static Fluid getFluid(String name) {
        return fluids.get(name);
    }

    public static Block getFluidBlock(String blockName) {
        return fluidBlocks.get(blockName);
    }
}

