/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.de;

import com.brandon3055.draconicevolution.client.render.IRenderTweak;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import com.denfop.IUCore;
import com.denfop.integration.de.DraconicIntegration;
import com.denfop.integration.de.MiningTool;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ChaosAxe
extends MiningTool
implements IInventoryTool,
IRenderTweak {
    public ChaosAxe() {
        super(DraconicIntegration.CHAOS);
        this.setHarvestLevel("axe", 15);
        this.func_77655_b("ChaosAxe");
        this.setCapacity((int)((double)BalanceConfigHandler.draconicToolsBaseStorage * 1.5));
        this.setMaxExtract(BalanceConfigHandler.draconicToolsMaxTransfer);
        this.setMaxReceive(BalanceConfigHandler.draconicToolsMaxTransfer);
        this.energyPerOperation = BalanceConfigHandler.draconicToolsEnergyPerAction;
        DraconicIntegration.register(this);
        this.func_77637_a(IUCore.tabssp2);
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        List<ItemConfigField> list = super.getFields(stack, slot);
        list.add(new ItemConfigField(2, slot, "ToolDigAOE").setMinMaxAndIncromente((Object)0, (Object)IUpgradableItem.EnumUpgrade.DIG_AOE.getUpgradePoints(stack), (Object)1).readFromItem(stack, (Object)0).setModifier("AOE"));
        list.add(new ItemConfigField(2, slot, "ToolDigDepth").setMinMaxAndIncromente((Object)1, (Object)IUpgradableItem.EnumUpgrade.DIG_DEPTH.getUpgradePoints(stack), (Object)1).readFromItem(stack, (Object)1));
        list.add(new ItemConfigField(6, slot, "AxeTreeMode").readFromItem(stack, (Object)Boolean.FALSE));
        return list;
    }

    @Override
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return true;
    }

    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryEnch.txt");
    }

    public int getInventorySlots() {
        return 0;
    }

    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.digger;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (IConfigurableItem.ProfileHelper.getBoolean((ItemStack)stack, (String)"AxeTreeMode", (boolean)false) && this.isTree(player.field_70170_p, x, y, z)) {
            this.trimLeavs(x, y, z, player.field_70170_p);
            for (int i = 0; i < 9; ++i) {
                player.field_70170_p.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)player.field_70170_p.func_147439_a(x, y, z)) + (player.field_70170_p.func_72805_g(x, y, z) << 12));
            }
            this.chopTree(x, y, z, player, player.field_70170_p, stack);
            return false;
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    public int getUpgradeCap(ItemStack itemstack) {
        return BalanceConfigHandler.draconicToolsMaxUpgrades;
    }

    public int getMaxTier(ItemStack itemstack) {
        return 3;
    }

    @Override
    public List<String> getUpgradeStats(ItemStack stack) {
        return super.getUpgradeStats(stack);
    }

    @Override
    public int getCapacity(ItemStack stack) {
        int points = IUpgradableItem.EnumUpgrade.RF_CAPACITY.getUpgradePoints(stack);
        return (int)((double)BalanceConfigHandler.draconicToolsBaseStorage * 1.5 + (double)(points * BalanceConfigHandler.draconicToolsStoragePerUpgrade));
    }

    public int getMaxUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.RF_CAPACITY.index) {
            return BalanceConfigHandler.draconicToolsMaxCapacityUpgradePoints;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_AOE.index) {
            return 4;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_DEPTH.index) {
            return 7;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_SPEED.index) {
            return 32;
        }
        return BalanceConfigHandler.draconicToolsMaxUpgradePoints;
    }

    public int getBaseUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_AOE.index) {
            return 2;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_DEPTH.index) {
            return 1;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_SPEED.index) {
            return 5;
        }
        return 0;
    }

    private boolean isTree(World world, int X, int Y, int Z) {
        Block wood = world.func_147439_a(X, Y, Z);
        if (wood == null || !wood.isWood((IBlockAccess)world, X, Y, Z)) {
            return false;
        }
        int top = Y;
        for (int y = Y; y <= Y + 50; ++y) {
            if (world.func_147439_a(X, y, Z).isWood((IBlockAccess)world, X, y, Z) || world.func_147439_a(X, y, Z).isLeaves((IBlockAccess)world, X, y, Z)) continue;
            top += y;
            break;
        }
        int leaves = 0;
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= top; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    if (!world.func_147439_a(xPos, yPos, zPos).isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                    ++leaves;
                }
            }
        }
        return leaves >= 3;
    }

    void chopTree(int X, int Y, int Z, EntityPlayer player, World world, ItemStack stack) {
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= Y + 1; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    Block block = world.func_147439_a(xPos, yPos, zPos);
                    int meta = world.func_72805_g(xPos, yPos, zPos);
                    if (!block.isWood((IBlockAccess)world, xPos, yPos, zPos)) continue;
                    world.func_147468_f(xPos, yPos, zPos);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (block.removedByPlayer(world, player, xPos, yPos, zPos, false)) {
                            block.func_149664_b(world, xPos, yPos, zPos, meta);
                        }
                        block.func_149636_a(world, player, xPos, yPos, zPos, meta);
                        block.func_149681_a(world, xPos, yPos, zPos, meta, player);
                        this.func_150894_a(stack, world, block, xPos, yPos, zPos, (EntityLivingBase)player);
                    }
                    this.chopTree(xPos, yPos, zPos, player, world, stack);
                }
            }
        }
    }

    void trimLeavs(int X, int Y, int Z, World world) {
        this.scedualUpdates(X, Y, Z, world);
    }

    void scedualUpdates(int X, int Y, int Z, World world) {
        for (int xPos = X - 15; xPos <= X + 15; ++xPos) {
            for (int yPos = Y; yPos <= Y + 50; ++yPos) {
                for (int zPos = Z - 15; zPos <= Z + 15; ++zPos) {
                    Block block = world.func_147439_a(xPos, yPos, zPos);
                    if (!block.isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                    world.func_147464_a(xPos, yPos, zPos, block, 2 + world.field_73012_v.nextInt(10));
                }
            }
        }
    }

    @Override
    public List<IUpgradableItem.EnumUpgrade> getUpgrades(ItemStack itemstack) {
        List<IUpgradableItem.EnumUpgrade> list = super.getUpgrades(itemstack);
        list.add(IUpgradableItem.EnumUpgrade.DIG_SPEED);
        list.add(IUpgradableItem.EnumUpgrade.DIG_DEPTH);
        list.add(IUpgradableItem.EnumUpgrade.DIG_AOE);
        list.add(IUpgradableItem.EnumUpgrade.RF_CAPACITY);
        return list;
    }

    public void tweakRender(IItemRenderer.ItemRenderType type) {
        GL11.glTranslated((double)0.34, (double)0.69, (double)0.1);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)140.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)11.0f, (float)11.0f, (float)11.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.3, (double)0.0, (double)-0.45);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)90.5f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.9);
        }
    }
}

