/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.denfop.api.IDoubleMolecularRecipeManager;
import com.denfop.utils.ModUtils;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public abstract class DoubleMolecularRecipeHandler
extends TemplateRecipeHandler {
    protected int ticks;

    public abstract String getRecipeName();

    public abstract String getRecipeId();

    public abstract String getGuiTexture();

    public abstract String getOverlayIdentifier();

    public abstract Map<IDoubleMolecularRecipeManager.Input, RecipeOutput> getRecipeList();

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)140, (int)65);
    }

    public void drawExtras(int i) {
        float f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(23, 26, 221, 7, 25, 20, f, 1);
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        String energyPerTick = I18n.func_135052_a((String)"gui.MolecularTransformer.energyPerOperation", (Object[])new Object[0]) + ": ";
        String input2 = I18n.func_135052_a((String)"gui.MolecularTransformer.input", (Object[])new Object[0]) + ": ";
        String output2 = I18n.func_135052_a((String)"gui.MolecularTransformer.output", (Object[])new Object[0]) + ": ";
        GuiDraw.drawString((String)(energyPerTick + ModUtils.getString(recipe.meta.func_74769_h("energy")) + " EU"), (int)55, (int)36, (int)0xCDCDCD);
        GuiDraw.drawString((String)(input2 + recipe.getIngredients().get((int)0).item.func_82833_r()), (int)55, (int)3, (int)0xCDCDCD);
        GuiDraw.drawString((String)(input2 + recipe.getIngredients().get((int)1).item.func_82833_r()), (int)55, (int)14, (int)0xCDCDCD);
        GuiDraw.drawString((String)(output2 + recipe.getResult().item.func_82833_r()), (int)55, (int)25, (int)0xCDCDCD);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<IDoubleMolecularRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new CachedIORecipe(entry.getKey().container, entry.getKey().fill, entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<IDoubleMolecularRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            for (ItemStack output : entry.getValue().items) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                this.arecipes.add(new CachedIORecipe(entry.getKey().container, entry.getKey().fill, entry.getValue()));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<IDoubleMolecularRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            if (!entry.getKey().container.matches(ingredient) && !entry.getKey().fill.matches(ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(entry.getKey().container, entry.getKey().fill, entry.getValue()));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        protected final List<PositionedStack> ingredients;
        protected final PositionedStack output;
        protected final List<PositionedStack> otherStacks;
        protected final NBTTagCompound meta;

        public CachedIORecipe(IRecipeInput container, IRecipeInput fill, RecipeOutput output1) {
            super((TemplateRecipeHandler)DoubleMolecularRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.otherStacks = new ArrayList<PositionedStack>();
            ArrayList<ItemStack> containerItems = new ArrayList<ItemStack>();
            ArrayList<ItemStack> fillItems = new ArrayList<ItemStack>();
            for (ItemStack item : container.getInputs()) {
                containerItems.add(StackUtil.copyWithSize((ItemStack)item, (int)container.getAmount()));
            }
            for (ItemStack item : fill.getInputs()) {
                fillItems.add(StackUtil.copyWithSize((ItemStack)item, (int)fill.getAmount()));
            }
            this.ingredients.add(new PositionedStack(containerItems, 11, 5));
            this.ingredients.add(new PositionedStack(fillItems, 29, 5));
            this.output = new PositionedStack(output1.items.get(0), 20, 46);
            this.meta = output1.metadata;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(DoubleMolecularRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.otherStacks;
        }
    }
}

