/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.denfop.api.IPlasticPlateRecipemanager;
import com.denfop.api.Recipes;
import com.denfop.gui.GUIPlasticPlateCreator;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.DrawUtil;
import ic2.core.util.GuiTooltipHelper;
import ic2.core.util.StackUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class NEIPlasticPlateMachine
extends TemplateRecipeHandler {
    int ticks;

    public Class<? extends GuiContainer> getGuiClass() {
        return GUIPlasticPlateCreator.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"iu.blockPlasticPlateCreator.name");
    }

    public String getRecipeId() {
        return "iu.blockPlasticPlateCreator";
    }

    public String getGuiTexture() {
        return "industrialupgrade:textures/gui/GUIPlasticPlate.png";
    }

    public String getOverlayIdentifier() {
        return "placticplatemachine";
    }

    public Map<IPlasticPlateRecipemanager.Input, RecipeOutput> getRecipeList() {
        return Recipes.plasticplate.getRecipes();
    }

    private void drawLiquid(FluidStack stack) {
        IIcon fluidIcon = new ItemStack(stack.getFluid().getBlock()).func_77954_c();
        GuiDraw.renderEngine.func_110577_a(TextureMap.field_110575_b);
        int liquidHeight = (int)((float)stack.amount / 12000.0f * 47.0f);
        DrawUtil.drawRepeated((IIcon)fluidIcon, (double)5.0, (double)(51 - liquidHeight), (double)12.0, (double)liquidHeight, (double)GuiDraw.gui.getZLevel());
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)5, (int)4, (int)176, (int)103, (int)12, (int)47);
    }

    private void drawLiquidTooltip(FluidStack stack, int recipe) {
        GuiRecipe gui = (GuiRecipe)Minecraft.func_71410_x().field_71462_r;
        Point mouse = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        String tooltip = stack.getLocalizedName() + " (" + stack.amount + "mb)";
        GuiTooltipHelper.drawAreaTooltip((int)(mouse.x - (gui.field_146294_l - 176) / 2 - offset.x), (int)(mouse.y - (gui.field_146295_m - 176) / 2 - offset.y), (String)tooltip, (int)5, (int)15, (int)17, (int)62);
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)5, (int)140, (int)75);
        ChemicalFactroryRecipe recipe = (ChemicalFactroryRecipe)((Object)this.arecipes.get(i));
        this.drawLiquid(recipe.fluidstack);
    }

    public void drawExtras(int i) {
        float f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(74, 30, 176, 14, 25, 16, f, 0);
        f = this.ticks <= 20 ? (float)this.ticks / 20.0f : 1.0f;
        this.drawProgressBar(52, 31, 176, 0, 14, 14, f, 3);
        ChemicalFactroryRecipe recipe = (ChemicalFactroryRecipe)((Object)this.arecipes.get(i));
        this.drawLiquidTooltip(recipe.fluidstack, i);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 19, 25, 14), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<IPlasticPlateRecipemanager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new ChemicalFactroryRecipe(entry.getKey().container, entry.getKey().fluidStack, entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<IPlasticPlateRecipemanager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            for (ItemStack output : entry.getValue().items) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                this.arecipes.add(new ChemicalFactroryRecipe(entry.getKey().container, entry.getKey().fluidStack, entry.getValue()));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<IPlasticPlateRecipemanager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            if (!entry.getKey().container.matches(ingredient)) continue;
            this.arecipes.add(new ChemicalFactroryRecipe(entry.getKey().container, entry.getKey().fluidStack, entry.getValue()));
        }
    }

    public class ChemicalFactroryRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final PositionedStack output;
        public final List<PositionedStack> ingredients;
        public final FluidStack fluidstack;

        public ChemicalFactroryRecipe(IRecipeInput container, FluidStack fluidstack, RecipeOutput output1) {
            super((TemplateRecipeHandler)NEIPlasticPlateMachine.this);
            this.ingredients = new ArrayList<PositionedStack>();
            ArrayList<ItemStack> containerItems = new ArrayList<ItemStack>();
            for (ItemStack item : container.getInputs()) {
                containerItems.add(StackUtil.copyWithSize((ItemStack)item, (int)container.getAmount()));
            }
            this.ingredients.add(new PositionedStack(containerItems, 51, 12));
            this.output = new PositionedStack(output1.items.get(0), 111, 29);
            this.fluidstack = fluidstack;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIPlasticPlateMachine.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

