/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.armour;

import cofh.api.energy.IEnergyContainerItem;
import com.denfop.Config;
import com.denfop.IUCore;
import com.denfop.proxy.CommonProxy;
import com.denfop.utils.Helpers;
import com.denfop.utils.ModUtils;
import com.denfop.utils.NBTData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemLappack
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor {
    private final int maxCharge;
    private final int transferLimit;
    private final int tier;
    private final String name;

    public ItemLappack(String name, ItemArmor.ArmorMaterial armorMaterial, int armortype, int MaxCharge, int Tier, int TransferLimit) {
        super(armorMaterial, IUCore.proxy.addArmor(name), armortype);
        this.maxCharge = MaxCharge;
        this.transferLimit = TransferLimit;
        this.func_77637_a(IUCore.tabssp2);
        this.func_77655_b(name);
        GameRegistry.registerItem((Item)this, (String)name);
        this.name = name;
        this.tier = Tier;
        this.func_77656_e(27);
    }

    public static int readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = ModUtils.nbt(itemstack);
        int toolMode = nbttagcompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 1) {
            toolMode = 0;
        }
        return toolMode;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * 0.0;
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getEnergyPerDamage() {
        return 10000;
    }

    private double getBaseAbsorptionRatio() {
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("industrialupgrade:" + this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "industrialupgrade:textures/armor/" + this.name + ".png";
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * 0.0);
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public void saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = ModUtils.nbt(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            int toolMode = ItemLappack.readToolMode(itemStack);
            if (++toolMode > 1) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("iu.message.text.powerSupply") + " " + EnumChatFormatting.RED + Helpers.formatMessage("iu.message.text.disabled"));
            }
            if (toolMode == 1) {
                CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("iu.message.text.powerSupply") + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("iu.message.text.enabled"));
            }
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        int toolMode = ItemLappack.readToolMode(par1ItemStack);
        if (toolMode == 0) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("iu.message.text.powerSupply") + ": " + EnumChatFormatting.RED + Helpers.formatMessage("iu.message.text.disabled"));
        }
        if (toolMode == 1) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("iu.message.text.powerSupply") + ": " + EnumChatFormatting.GREEN + Helpers.formatMessage("iu.message.text.enabled"));
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        int toolMode;
        NBTTagCompound nbtData = NBTData.getOrCreateNbtData(itemStack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        if (IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            toolMode = ItemLappack.readToolMode(itemStack);
            if (++toolMode > 1) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("iu.message.text.powerSupply") + " " + EnumChatFormatting.RED + Helpers.formatMessage("iu.message.text.disabled"));
            }
            if (toolMode == 1) {
                CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("iu.message.text.powerSupply") + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("iu.message.text.enabled"));
            }
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        toolMode = ItemLappack.readToolMode(itemStack);
        boolean ret = false;
        if (toolMode == 1) {
            double realSentEnergyRF;
            int amountRfCanBeReceivedIncludesLimit;
            for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                double sentPacket;
                if (player.field_71071_by.field_70460_b[i] != null && player.field_71071_by.field_70460_b[i].func_77973_b() instanceof IElectricItem && ElectricItem.manager.getCharge(itemStack) > 0.0 && (sentPacket = ElectricItem.manager.charge(player.field_71071_by.field_70460_b[i], ElectricItem.manager.getCharge(itemStack), Integer.MAX_VALUE, true, false)) > 0.0) {
                    ElectricItem.manager.discharge(itemStack, sentPacket, Integer.MAX_VALUE, true, false, false);
                    ret = true;
                }
                if (player.field_71071_by.field_70460_b[i] == null || !(player.field_71071_by.field_70460_b[i].func_77973_b() instanceof IEnergyContainerItem) || !(ElectricItem.manager.getCharge(itemStack) > 0.0)) continue;
                IEnergyContainerItem item = (IEnergyContainerItem)player.field_71071_by.field_70460_b[i].func_77973_b();
                amountRfCanBeReceivedIncludesLimit = item.receiveEnergy(player.field_71071_by.field_70460_b[i], Integer.MAX_VALUE, true);
                realSentEnergyRF = Math.min((double)amountRfCanBeReceivedIncludesLimit, ElectricItem.manager.getCharge(itemStack) * (double)Config.coefficientrf);
                item.receiveEnergy(player.field_71071_by.field_70460_b[i], (int)realSentEnergyRF, false);
                ElectricItem.manager.discharge(itemStack, realSentEnergyRF / (double)Config.coefficientrf, Integer.MAX_VALUE, true, false, false);
            }
            for (int j = 0; j < player.field_71071_by.field_70462_a.length; ++j) {
                double sentPacket;
                if (player.field_71071_by.field_70462_a[j] != null && player.field_71071_by.field_70462_a[j].func_77973_b() instanceof IElectricItem && ElectricItem.manager.getCharge(itemStack) > 0.0 && (sentPacket = ElectricItem.manager.charge(player.field_71071_by.field_70462_a[j], ElectricItem.manager.getCharge(itemStack), Integer.MAX_VALUE, true, false)) > 0.0) {
                    ElectricItem.manager.discharge(itemStack, sentPacket, Integer.MAX_VALUE, true, false, false);
                    ret = true;
                }
                if (player.field_71071_by.field_70462_a[j] == null || !(player.field_71071_by.field_70462_a[j].func_77973_b() instanceof IEnergyContainerItem) || !(ElectricItem.manager.getCharge(itemStack) > 0.0)) continue;
                IEnergyContainerItem item = (IEnergyContainerItem)player.field_71071_by.field_70462_a[j].func_77973_b();
                amountRfCanBeReceivedIncludesLimit = item.receiveEnergy(player.field_71071_by.field_70462_a[j], Integer.MAX_VALUE, true);
                realSentEnergyRF = Math.min((double)amountRfCanBeReceivedIncludesLimit, ElectricItem.manager.getCharge(itemStack) * (double)Config.coefficientrf);
                item.receiveEnergy(player.field_71071_by.field_70462_a[j], (int)realSentEnergyRF, false);
                ElectricItem.manager.discharge(itemStack, realSentEnergyRF / (double)Config.coefficientrf, Integer.MAX_VALUE, true, false, false);
            }
            if (ret) {
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

