/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.energy;

import com.denfop.Config;
import com.denfop.IUCore;
import com.denfop.proxy.CommonProxy;
import com.denfop.utils.EnumInfoUpgradeModules;
import com.denfop.utils.Helpers;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import com.denfop.utils.NBTData;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.lwjgl.input.Keyboard;

public class AdvancedMultiTool
extends ItemTool
implements IElectricItem {
    public static final Set<Block> mineableBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150334_T, Blocks.field_150333_U, Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150341_Y, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150365_q, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150432_aD, Blocks.field_150424_aL, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150439_ay, Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150431_aC, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150391_bh, Blocks.field_150426_aN, Blocks.field_150449_bY});
    private static final Set<Material> materials = Sets.newHashSet((Object[])new Material[]{Material.field_151573_f, Material.field_151574_g, Material.field_151576_e, Material.field_151592_s, Material.field_151588_w, Material.field_151598_x, Material.field_151575_d, Material.field_151584_j, Material.field_151589_v, Material.field_151570_A, Material.field_151585_k, Material.field_151582_l, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B});
    private static final Set<String> toolType = ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe");
    public final float energyPerultraLowPowerOperation1 = Config.energyPerultraLowPowerOperation1;
    private final float bigHolePower = Config.bigHolePower;
    private final float normalPower = Config.effPower;
    private final float lowPower = Config.lowPower;
    private final float ultraLowPower = Config.ultraLowPower;
    private final int maxCharge = Config.ultdrillmaxCharge;
    private final int tier = Config.ultdrilltier;
    private final int energyPerOperation = Config.energyPerOperation;
    private final int energyPerLowOperation = Config.energyPerLowOperation;
    private final int energyPerbigHolePowerOperation = Config.energyPerbigHolePowerOperation;
    private final int energyPerultraLowPowerOperation = Config.energyPerultraLowPowerOperation;
    private final int transferLimit = Config.ultdrilltransferLimit;
    private final float ultraLowPower1 = Config.ultraLowPower1;

    public AdvancedMultiTool(Item.ToolMaterial toolMaterial, String name) {
        super(0.0f, toolMaterial, new HashSet());
        this.func_77656_e(27);
        this.field_77864_a = this.normalPower;
        this.func_77637_a(IUCore.tabssp2);
        this.func_77655_b(name);
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public static int readToolMode(ItemStack itemstack) {
        NBTTagCompound nbt = NBTData.getOrCreateNbtData(itemstack);
        int toolMode = nbt.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 6) {
            toolMode = 0;
        }
        return toolMode;
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            y += 1.0;
        }
        Vec3 vec3 = Vec3.func_72443_a((double)x, (double)y, (double)z);
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        if (player instanceof EntityPlayerMP) {
            range = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c(range * (double)f7, range * (double)f6, range * (double)f8);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase damagee, EntityLivingBase damager) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return toolType;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean par5) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        for (int i = 0; i < 4; ++i) {
            if (!nbtData.func_74779_i("mode_module" + i).equals("silk")) continue;
            Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
            enchantmentMap.put(Enchantment.field_77348_q.field_77352_x, 1);
            EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)itemStack);
            break;
        }
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return Items.field_151056_x.canHarvestBlock(block, stack) || Items.field_151056_x.func_150893_a(stack, block) > 1.0f || Items.field_151046_w.canHarvestBlock(block, stack) || Items.field_151046_w.func_150893_a(stack, block) > 1.0f || Items.field_151047_v.canHarvestBlock(block, stack) || Items.field_151047_v.func_150893_a(stack, block) > 1.0f || mineableBlocks.contains(block);
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        NBTTagCompound nbt = ModUtils.nbt(tool);
        int energy = 0;
        int speed = 0;
        for (int i = 0; i < 4; ++i) {
            if (nbt.func_74779_i("mode_module" + i).equals("speed")) {
                ++speed;
            }
            if (!nbt.func_74779_i("mode_module" + i).equals("energy")) continue;
            ++energy;
        }
        energy = Math.min(energy, EnumInfoUpgradeModules.ENERGY.max);
        speed = Math.min(speed, EnumInfoUpgradeModules.EFFICIENCY.max);
        return !ElectricItem.manager.canUse(tool, (double)(this.energyPerOperation - (int)((double)this.energyPerOperation * 0.25 * (double)energy))) ? 1.0f : (this.canHarvestBlock(block, tool) ? this.field_77864_a + (float)((int)((double)this.field_77864_a * 0.2 * (double)speed)) : 1.0f);
    }

    public int getHarvestLevel(ItemStack stack, String toolType) {
        return !toolType.equals("pickaxe") && !toolType.equals("shovel") && !toolType.equals("axe") && !toolType.equals("shears") ? super.getHarvestLevel(stack, toolType) : this.field_77862_b.func_77996_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("industrialupgrade:ultDDrill");
    }

    private void ore_break(World world, int x, int y, int z, EntityPlayer player, boolean silktouch, int fortune, boolean lowPower, ItemStack stack, Block block1) {
        for (int Xx = x - 1; Xx <= x + 1; ++Xx) {
            block1: for (int Yy = y - 1; Yy <= y + 1; ++Yy) {
                for (int Zz = z - 1; Zz <= z + 1; ++Zz) {
                    if (ElectricItem.manager.canUse(stack, (double)this.energy(stack))) {
                        Block localBlock = world.func_147439_a(Xx, Yy, Zz);
                        if (!ModUtils.getore(localBlock, block1)) continue;
                        NBTTagCompound NBTTagCompound2 = stack.func_77978_p();
                        int ore = NBTTagCompound2.func_74762_e("ore");
                        if (ore < 16) {
                            if (player.field_71075_bZ.field_75098_d) continue block1;
                            int localMeta = world.func_72805_g(Xx, Yy, Zz);
                            if (localBlock.func_149712_f(world, Xx, Yy, Zz) > 0.0f) {
                                this.func_150894_a(stack, world, localBlock, Xx, Yy, Zz, (EntityLivingBase)player);
                            }
                            if (!silktouch) {
                                localBlock.func_149657_c(world, Xx, Yy, Zz, localBlock.getExpDrop((IBlockAccess)world, localMeta, fortune));
                            }
                            NBTTagCompound2.func_74768_a("ore", ++ore);
                            this.ore_break(world, Xx, Yy, Zz, player, silktouch, fortune, lowPower, stack, block1);
                        }
                        world.func_147479_m(Xx, Yy, Zz);
                        continue;
                    }
                    lowPower = true;
                    continue block1;
                }
            }
        }
    }

    void chopTree(int X, int Y, int Z, EntityPlayer player, World world, ItemStack stack) {
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= Y + 1; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    Block block = world.func_147439_a(xPos, yPos, zPos);
                    int meta = world.func_72805_g(xPos, yPos, zPos);
                    if (!block.isWood((IBlockAccess)world, xPos, yPos, zPos)) continue;
                    world.func_147468_f(xPos, yPos, zPos);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (block.removedByPlayer(world, player, xPos, yPos, zPos, false)) {
                            block.func_149664_b(world, xPos, yPos, zPos, meta);
                        }
                        ArrayList stacklist = block.getDrops(world, xPos, yPos, zPos, meta, fortune);
                        for (ItemStack item : stacklist) {
                            if (player.field_71071_by.func_70441_a(item)) continue;
                            float f = 0.7f;
                            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                            EntityItem entityitem = new EntityItem(world, (double)xPos + d0, (double)yPos + d1, (double)zPos + d2, item);
                            entityitem.field_145804_b = 10;
                            world.func_72838_d((Entity)entityitem);
                        }
                        block.func_149681_a(world, xPos, yPos, zPos, meta, player);
                        this.func_150894_a(stack, world, block, xPos, yPos, zPos, (EntityLivingBase)player);
                    }
                    this.chopTree(xPos, yPos, zPos, player, world, stack);
                }
            }
        }
    }

    private boolean isTree(World world, int X, int Y, int Z) {
        Block wood = world.func_147439_a(X, Y, Z);
        if (wood == null || !wood.isWood((IBlockAccess)world, X, Y, Z)) {
            return false;
        }
        int top = Y;
        for (int y = Y; y <= Y + 50; ++y) {
            if (world.func_147439_a(X, y, Z).isWood((IBlockAccess)world, X, y, Z) || world.func_147439_a(X, y, Z).isLeaves((IBlockAccess)world, X, y, Z)) continue;
            top += y;
            break;
        }
        int leaves = 0;
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= top; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    if (!world.func_147439_a(xPos, yPos, zPos).isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                    ++leaves;
                }
            }
        }
        return leaves >= 3;
    }

    void trimLeavs(int X, int Y, int Z, World world) {
        this.scedualUpdates(X, Y, Z, world);
    }

    void scedualUpdates(int X, int Y, int Z, World world) {
        for (int xPos = X - 15; xPos <= X + 15; ++xPos) {
            for (int yPos = Y; yPos <= Y + 50; ++yPos) {
                for (int zPos = Z - 15; zPos <= Z + 15; ++zPos) {
                    Block block = world.func_147439_a(xPos, yPos, zPos);
                    if (!block.isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                    world.func_147464_a(xPos, yPos, zPos, block, 2 + world.field_73012_v.nextInt(10));
                }
            }
        }
    }

    boolean break_block(World world, Block block, int meta, MovingObjectPosition mop, byte mode_item, EntityPlayer player, int x, int y, int z, ItemStack stack) {
        byte xRange = mode_item;
        byte yRange = mode_item;
        byte zRange = mode_item;
        switch (mop.field_72310_e) {
            case 0: 
            case 1: {
                yRange = 0;
                break;
            }
            case 2: 
            case 3: {
                zRange = 0;
                break;
            }
            case 4: 
            case 5: {
                xRange = 0;
            }
        }
        boolean lowPower = false;
        boolean silktouch = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        int Yy = yRange > 0 ? yRange - 1 : 0;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int dig_depth = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("dig_depth")) continue;
            dig_depth = (byte)(dig_depth + 1);
        }
        dig_depth = (byte)Math.min(dig_depth, EnumInfoUpgradeModules.DIG_DEPTH.max);
        zRange = zRange > 0 ? zRange : (byte)(zRange + dig_depth);
        xRange = xRange > 0 ? xRange : (byte)(xRange + dig_depth);
        nbt.func_74768_a("zRange", (int)zRange);
        nbt.func_74768_a("xRange", (int)xRange);
        nbt.func_74768_a("yRange", (int)yRange);
        boolean save = nbt.func_74767_n("save");
        if (!player.field_71075_bZ.field_75098_d) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                block7: for (int yPos = y - yRange + Yy; yPos <= y + yRange + Yy; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        if (ElectricItem.manager.canUse(stack, (double)this.energy(stack)) && materials.contains(block.func_149688_o())) {
                            Block localBlock = world.func_147439_a(xPos, yPos, zPos);
                            if (localBlock != null && this.canHarvestBlock(localBlock, stack) && localBlock.func_149712_f(world, xPos, yPos, zPos) >= 0.0f && (materials.contains(localBlock.func_149688_o()) || block == Blocks.field_150418_aU)) {
                                if (save && world.func_147438_o(xPos, yPos, zPos) != null) continue;
                                int localMeta = world.func_72805_g(xPos, yPos, zPos);
                                if (localBlock.func_149712_f(world, xPos, yPos, zPos) > 0.0f) {
                                    this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                                }
                                if (silktouch) continue;
                                localBlock.func_149657_c(world, xPos, yPos, zPos, localBlock.getExpDrop((IBlockAccess)world, localMeta, fortune));
                                continue;
                            }
                            if (!(localBlock.func_149712_f(world, xPos, yPos, zPos) > 0.0f) || !materials.contains(localBlock.func_149688_o())) continue;
                            return this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                        }
                        lowPower = true;
                        continue block7;
                    }
                }
            }
        } else if (ElectricItem.manager.canUse(stack, (double)this.energy(stack))) {
            Block localBlock = world.func_147439_a(x, y, z);
            if (localBlock != null && this.canHarvestBlock(localBlock, stack) && localBlock.func_149712_f(world, x, y, z) >= 0.0f && (materials.contains(localBlock.func_149688_o()) || block == Blocks.field_150418_aU)) {
                int localMeta = world.func_72805_g(x, y, z);
                if (localBlock.func_149712_f(world, x, y, z) > 0.0f) {
                    this.func_150894_a(stack, world, localBlock, x, y, z, (EntityLivingBase)player);
                }
                if (!silktouch) {
                    localBlock.func_149657_c(world, x, y, z, localBlock.getExpDrop((IBlockAccess)world, localMeta, fortune));
                }
            } else if (localBlock.func_149712_f(world, x, y, z) > 0.0f) {
                return this.func_150894_a(stack, world, localBlock, x, y, z, (EntityLivingBase)player);
            }
        }
        if (lowPower) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("message.text.noenergy", new Object[0]));
        } else if (!IUCore.isSimulating()) {
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        Block block;
        int i;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        byte aoe = 0;
        for (i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("AOE_dig")) continue;
            aoe = (byte)(aoe + 1);
        }
        aoe = (byte)Math.min(aoe, EnumInfoUpgradeModules.AOE_DIG.max);
        if (AdvancedMultiTool.readToolMode(stack) == 1 || AdvancedMultiTool.readToolMode(stack) == 0) {
            World world = player.field_70170_p;
            Block block2 = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (block2 == null) {
                return super.onBlockStartBreak(stack, x, y, z, player);
            }
            MovingObjectPosition mop = AdvancedMultiTool.raytraceFromEntity(world, (Entity)player, true, 4.5);
            return this.break_block(world, block2, meta, mop, aoe, player, x, y, z, stack);
        }
        if (AdvancedMultiTool.readToolMode(stack) == 5) {
            World world = player.field_70170_p;
            block = world.func_147439_a(x, y, z);
            if (block == null) {
                return super.onBlockStartBreak(stack, x, y, z, player);
            }
            MovingObjectPosition mop = AdvancedMultiTool.raytraceFromEntity(world, (Entity)player, true, 4.5);
            if (mop != null && (materials.contains(block.func_149688_o()) || block == Blocks.field_150418_aU)) {
                boolean silktouch = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
                int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
                NBTTagCompound NBTTagCompound2 = stack.func_77978_p();
                NBTTagCompound2.func_74768_a("ore", 1);
                Block block1 = world.func_147439_a(x, y, z);
                this.ore_break(world, x, y, z, player, silktouch, fortune, false, stack, block1);
            }
        }
        if (AdvancedMultiTool.readToolMode(stack) == 6 && this.isTree(player.field_70170_p, x, y, z)) {
            this.trimLeavs(x, y, z, player.field_70170_p);
            for (i = 0; i < 9; ++i) {
                player.field_70170_p.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)player.field_70170_p.func_147439_a(x, y, z)) + (player.field_70170_p.func_72805_g(x, y, z) << 12));
            }
            this.chopTree(x, y, z, player, player.field_70170_p, stack);
        }
        if (AdvancedMultiTool.readToolMode(stack) == 2) {
            World world = player.field_70170_p;
            block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (block == null) {
                return super.onBlockStartBreak(stack, x, y, z, player);
            }
            MovingObjectPosition mop = AdvancedMultiTool.raytraceFromEntity(world, (Entity)player, true, 4.5);
            if (mop != null && (materials.contains(block.func_149688_o()) || block == Blocks.field_150418_aU)) {
                return this.break_block(world, block, meta, mop, (byte)(1 + aoe), player, x, y, z, stack);
            }
        }
        if (AdvancedMultiTool.readToolMode(stack) == 3) {
            World world = player.field_70170_p;
            block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (block == null) {
                return super.onBlockStartBreak(stack, x, y, z, player);
            }
            MovingObjectPosition mop = AdvancedMultiTool.raytraceFromEntity(world, (Entity)player, true, 4.5);
            if (mop != null && (materials.contains(block.func_149688_o()) || block == Blocks.field_150418_aU)) {
                return this.break_block(world, block, meta, mop, (byte)(2 + aoe), player, x, y, z, stack);
            }
        }
        if (AdvancedMultiTool.readToolMode(stack) == 4) {
            World world = player.field_70170_p;
            block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (block == null) {
                return super.onBlockStartBreak(stack, x, y, z, player);
            }
            MovingObjectPosition mop = AdvancedMultiTool.raytraceFromEntity(world, (Entity)player, true, 4.5);
            if (mop != null && (materials.contains(block.func_149688_o()) || block == Blocks.field_150418_aU)) {
                return this.break_block(world, block, meta, mop, (byte)(3 + aoe), player, x, y, z, stack);
            }
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int xPos, int yPos, int zPos, EntityLivingBase entity) {
        float energy;
        if (block == null) {
            return false;
        }
        if (world.func_147437_c(xPos, yPos, zPos)) {
            return false;
        }
        if (block.func_149688_o() instanceof MaterialLiquid || block.func_149712_f(world, xPos, yPos, xPos) == -1.0f && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return false;
        }
        int meta = world.func_72805_g(xPos, yPos, zPos);
        if (!world.field_72995_K) {
            block.func_149681_a(world, xPos, yPos, zPos, meta, (EntityPlayer)((EntityPlayerMP)entity));
            if (block.removedByPlayer(world, (EntityPlayer)((EntityPlayerMP)entity), xPos, yPos, zPos, true)) {
                block.func_149664_b(world, xPos, yPos, zPos, meta);
                block.func_149636_a(world, (EntityPlayer)((EntityPlayerMP)entity), xPos, yPos, zPos, meta);
                NBTTagCompound nbt = ModUtils.nbt(stack);
                int xMin = nbt.func_74762_e("xRange");
                int xMax = nbt.func_74762_e("xRange");
                int yMin = nbt.func_74762_e("yRange");
                int yMax = nbt.func_74762_e("yRange");
                int zMin = nbt.func_74762_e("zRange");
                int zMax = nbt.func_74762_e("zRange");
                List items = entity.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(xPos - xMin), (double)(yPos - yMin), (double)(zPos - zMin), (double)(xPos + xMax + 1), (double)(yPos + yMax + 1), (double)(zPos + zMax + 1)));
                if (ModUtils.getore(block) || !Config.blacklist) {
                    for (EntityItem item : items) {
                        if (entity.field_70170_p.field_72995_K) continue;
                        item.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
                        ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new S18PacketEntityTeleport((Entity)item));
                        item.field_145804_b = 0;
                    }
                } else {
                    for (EntityItem item : items) {
                        if (entity.field_70170_p.field_72995_K || !ModUtils.getore(item.func_92059_d().func_77973_b())) continue;
                        item.func_70106_y();
                    }
                }
                ((EntityPlayerMP)entity).func_71020_j(-0.025f);
            }
            ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)world.func_72912_H().func_76077_q(), (EntityPlayerMP)((EntityPlayerMP)entity), (int)xPos, (int)yPos, (int)zPos);
            EntityPlayerMP mpPlayer = (EntityPlayerMP)entity;
            mpPlayer.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(xPos, yPos, zPos, world));
        } else {
            if (block.removedByPlayer(world, (EntityPlayer)entity, xPos, yPos, zPos, true)) {
                block.func_149664_b(world, xPos, yPos, zPos, meta);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, xPos, yPos, zPos, Minecraft.func_71410_x().field_71476_x.field_72310_e));
        }
        if (entity != null && (energy = this.energy(stack)) != 0.0f && block.func_149712_f(world, xPos, yPos, zPos) != 0.0f) {
            ElectricItem.manager.use(stack, (double)energy, entity);
        }
        return true;
    }

    public float energy(ItemStack stack) {
        float energy;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int energy1 = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("energy")) continue;
            ++energy1;
        }
        energy1 = Math.min(energy1, EnumInfoUpgradeModules.ENERGY.max);
        int toolMode = AdvancedMultiTool.readToolMode(stack);
        switch (toolMode) {
            case 1: {
                energy = (float)((double)this.energyPerLowOperation - (double)this.energyPerLowOperation * 0.25 * (double)energy1);
                break;
            }
            case 2: {
                energy = (float)((double)this.energyPerbigHolePowerOperation - (double)this.energyPerbigHolePowerOperation * 0.25 * (double)energy1);
                break;
            }
            case 3: {
                energy = (float)((double)this.energyPerultraLowPowerOperation - (double)this.energyPerultraLowPowerOperation * 0.25 * (double)energy1);
                break;
            }
            case 4: {
                energy = (float)((double)this.energyPerultraLowPowerOperation1 - (double)this.energyPerultraLowPowerOperation1 * 0.25 * (double)energy1);
                break;
            }
            default: {
                energy = (float)((double)this.energyPerOperation - (double)this.energyPerOperation * 0.25 * (double)energy1);
            }
        }
        return energy;
    }

    public void saveToolMode(ItemStack itemstack, int toolMode) {
        NBTTagCompound nbt = NBTData.getOrCreateNbtData(itemstack);
        nbt.func_74768_a("toolMode", toolMode);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Item item;
            ItemStack torchStack = player.field_71071_by.field_70462_a[i];
            if (torchStack == null || !torchStack.func_77977_a().toLowerCase().contains("torch") || !((item = torchStack.func_77973_b()) instanceof ItemBlock)) continue;
            int oldMeta = torchStack.func_77960_j();
            int oldSize = torchStack.field_77994_a;
            boolean result = torchStack.func_77943_a(player, world, x, y, z, side, xOffset, yOffset, zOffset);
            if (player.field_71075_bZ.field_75098_d) {
                torchStack.func_77964_b(oldMeta);
                torchStack.field_77994_a = oldSize;
            } else if (torchStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack);
                player.field_71071_by.field_70462_a[i] = null;
            }
            if (!result) continue;
            return true;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (IUCore.keyboard.isSaveModeKeyDown(player)) {
            NBTTagCompound nbt = ModUtils.nbt(itemStack);
            boolean save = !nbt.func_74767_n("save");
            CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GREEN + Helpers.formatMessage("message.savemode") + (save ? Helpers.formatMessage("message.allow") : Helpers.formatMessage("message.disallow")));
            nbt.func_74757_a("save", save);
        }
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            int toolMode = AdvancedMultiTool.readToolMode(itemStack) + 1;
            if (toolMode > 6) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            switch (toolMode) {
                case 0: {
                    CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.ultDDrill.mode.normal"));
                    this.field_77864_a = this.normalPower;
                    Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                    if (Config.enableefficiency) {
                        enchantmentMap.put(Enchantment.field_77349_p.field_77352_x, Config.efficiencylevel);
                    }
                    if (Config.enablefortune) {
                        enchantmentMap.remove(Enchantment.field_77346_s.field_77352_x, Config.fortunelevel);
                    }
                    if (!Config.enablefortune && !Config.enableefficiency) break;
                    EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)itemStack);
                    break;
                }
                case 1: {
                    Map enchantmentMap4 = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                    if (Config.enableefficiency) {
                        enchantmentMap4.remove(Enchantment.field_77349_p.field_77352_x, Config.efficiencylevel);
                    }
                    enchantmentMap4.put(Enchantment.field_77349_p.field_77352_x, Config.efficiencylevel1);
                    EnchantmentHelper.func_82782_a((Map)enchantmentMap4, (ItemStack)itemStack);
                    CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.ultDDrill.mode.lowPower"));
                    this.field_77864_a = this.lowPower;
                    break;
                }
                case 2: {
                    CommonProxy.sendPlayerMessage(player, EnumChatFormatting.AQUA + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.ultDDrill.mode.bigHoles"));
                    this.field_77864_a = this.bigHolePower;
                    Map enchantmentMap2 = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                    enchantmentMap2.remove(Enchantment.field_77349_p.field_77352_x, Config.efficiencylevel1);
                    if (Config.enablesilkTouch) {
                        enchantmentMap2.put(Enchantment.field_77348_q.field_77352_x, 1);
                    }
                    EnchantmentHelper.func_82782_a((Map)enchantmentMap2, (ItemStack)itemStack);
                    break;
                }
                case 3: {
                    CommonProxy.sendPlayerMessage(player, EnumChatFormatting.LIGHT_PURPLE + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.ultDDrill.mode.bigHoles1"));
                    this.field_77864_a = this.ultraLowPower;
                    Map enchantmentMap1 = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                    if (Config.enablesilkTouch) {
                        enchantmentMap1.remove(Enchantment.field_77348_q.field_77352_x, 1);
                    }
                    if (Config.enablefortune) {
                        enchantmentMap1.put(Enchantment.field_77346_s.field_77352_x, Config.fortunelevel);
                    }
                    if (!Config.enablefortune && !Config.enablesilkTouch) break;
                    EnchantmentHelper.func_82782_a((Map)enchantmentMap1, (ItemStack)itemStack);
                    break;
                }
                case 4: {
                    CommonProxy.sendPlayerMessage(player, EnumChatFormatting.DARK_PURPLE + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.ultDDrill.mode.bigHoles2"));
                    this.field_77864_a = this.ultraLowPower1;
                    break;
                }
                case 5: {
                    CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.ultDDrill.mode.pickaxe"));
                    this.field_77864_a = this.normalPower;
                    Map enchantmentMap3 = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                    if (Config.enableefficiency) {
                        enchantmentMap3.put(Enchantment.field_77349_p.field_77352_x, Config.efficiencylevel);
                    }
                    if (Config.enablefortune) {
                        enchantmentMap3.remove(Enchantment.field_77346_s.field_77352_x, Config.fortunelevel);
                    }
                    if (!Config.enablefortune && !Config.enableefficiency) break;
                    EnchantmentHelper.func_82782_a((Map)enchantmentMap3, (ItemStack)itemStack);
                    break;
                }
                case 6: {
                    CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.ultDDrill.mode.treemode"));
                    this.field_77864_a = this.normalPower;
                }
            }
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        int toolMode = AdvancedMultiTool.readToolMode(par1ItemStack);
        switch (toolMode) {
            case 0: {
                par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.ultDDrill.mode.normal"));
                par3List.add(Helpers.formatMessage("message.description.normal"));
                break;
            }
            case 1: {
                par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.ultDDrill.mode.lowPower"));
                par3List.add(Helpers.formatMessage("message.description.lowPower"));
                break;
            }
            case 2: {
                par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.ultDDrill.mode.bigHoles"));
                par3List.add(Helpers.formatMessage("message.description.bigHoles"));
                break;
            }
            case 3: {
                par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.ultDDrill.mode.bigHoles1"));
                par3List.add(Helpers.formatMessage("message.description.bigHoles1"));
                break;
            }
            case 4: {
                par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.ultDDrill.mode.bigHoles2"));
                par3List.add(Helpers.formatMessage("message.description.bigHoles2"));
                break;
            }
            case 5: {
                par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.ultDDrill.mode.pickaxe"));
                par3List.add(Helpers.formatMessage("message.description.pickaxe"));
                break;
            }
            case 6: {
                par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.ultDDrill.mode.treemode"));
                par3List.add(Helpers.formatMessage("message.description.treemode"));
            }
        }
        if (!Keyboard.isKeyDown((int)42)) {
            par3List.add(StatCollector.func_74838_a((String)"press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            par3List.add(StatCollector.func_74838_a((String)"iu.changemode_key") + Keyboard.getKeyName((int)KeyboardClient.changemode.func_151463_i()) + StatCollector.func_74838_a((String)"iu.changemode_rcm"));
            par3List.add(StatCollector.func_74838_a((String)"iu.savemode_key") + Keyboard.getKeyName((int)KeyboardClient.savemode.func_151463_i()) + StatCollector.func_74838_a((String)"iu.changemode_rcm"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subs) {
        ItemStack stack = new ItemStack((Item)this, 1);
        HashMap<Integer, Integer> enchantmentMap4 = new HashMap<Integer, Integer>();
        enchantmentMap4.put(Enchantment.field_77349_p.field_77352_x, 10);
        EnchantmentHelper.func_82782_a(enchantmentMap4, (ItemStack)stack);
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        subs.add(stack);
        ItemStack itemstack = new ItemStack((Item)this, 1, this.func_77612_l());
        EnchantmentHelper.func_82782_a(enchantmentMap4, (ItemStack)itemstack);
        subs.add(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

