/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.api.ITemperature;
import com.denfop.api.ITemperatureSourse;
import com.denfop.api.Recipes;
import ic2.api.Direction;
import ic2.core.IC2;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.network.NetworkManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBaseHeatMachine
extends TileEntityElectricMachine
implements IFluidHandler,
ITemperatureSourse {
    public final boolean hasFluid;
    public final FluidTank fluidTank;
    public final String name;
    public final short maxtemperature;
    public short temperature;

    public TileEntityBaseHeatMachine(String name, boolean hasFluid) {
        super(hasFluid ? 0 : 10000, 14, -1);
        this.hasFluid = hasFluid;
        this.fluidTank = new FluidTank(12000);
        this.name = name;
        this.maxtemperature = (short)5000;
        this.temperature = 0;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.temperature = nbttagcompound.func_74765_d("temperature");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        nbttagcompound.func_74777_a("temperature", this.temperature);
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "temperature");
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "fluidTank");
        this.setActive(Recipes.mechanism.process(this));
        for (Direction direction : Direction.directions) {
            TileEntity target = direction.applyToTileEntity((TileEntity)this);
            if (!(target instanceof ITemperature) || target instanceof TileEntityBaseHeatMachine) continue;
            Recipes.mechanism.transfer((ITemperature)target, this);
        }
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount == 0.0) {
            return 0.0;
        }
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        if (this.energy + amount >= (double)this.maxEnergy) {
            double p = (double)this.maxEnergy - this.energy;
            this.energy += p;
            return amount - p;
        }
        this.energy += amount;
        return 0.0;
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.getFluidTank().fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.getFluidTank().getFluid())) {
            return null;
        }
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.getFluidTank().drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from, null)) {
            return null;
        }
        return this.getFluidTank().drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.hasFluid && fluid.equals(FluidRegistry.LAVA);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.hasFluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getFluidTank().getInfo()};
    }

    @Override
    public short getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(short temperature) {
        this.temperature = temperature;
    }

    @Override
    public short getMaxTemperature() {
        return this.maxtemperature;
    }

    @Override
    public boolean isFluidTemperature() {
        return this.hasFluid;
    }

    @Override
    public FluidStack getFluid() {
        return this.fluidTank.getFluid();
    }

    @Override
    public TileEntityElectricMachine getTile() {
        return this;
    }
}

