/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.container.ContainerConverterSolidMatter;
import com.denfop.gui.GUIConverterSolidMatter;
import com.denfop.invslot.InvSlotConverterSolidMatter;
import com.denfop.invslot.InvSlotProcessableConverterSolidMatter;
import com.denfop.recipemanager.ConverterSolidMatterRecipeManager;
import com.denfop.tiles.base.TileEntityElectricMachine;
import com.denfop.utils.ModUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessable;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.network.NetworkManager;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityConverterSolidMatter
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener,
IUpgradableBlock {
    public final double[] quantitysolid = new double[8];
    public final InvSlotConverterSolidMatter MatterSlot = new InvSlotConverterSolidMatter(this, "input", 1);
    public final InvSlotProcessable inputSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 3, 3);
    public AudioSource audioSource;
    private double progress = 0.0;
    private double guiProgress = 0.0;
    public final int defaultOperationLength;
    public int energyConsume = 2;
    public final int defaultEnergyConsume;
    public double defaultEnergyStorage = 50000.0;
    public int operationLength = 100;
    public int operationsPerTick;

    public TileEntityConverterSolidMatter() {
        super(50000.0, 12, 0);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 2, 1);
        this.inputSlot = new InvSlotProcessableConverterSolidMatter(this, "inputA", 4, 1, Recipes.matterrecipe);
        this.defaultOperationLength = 100;
        this.defaultEnergyConsume = 2;
    }

    public static void init() {
        Recipes.matterrecipe = new ConverterSolidMatterRecipeManager();
        TileEntityConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150348_b), 0.5, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0, 0.0);
        TileEntityConverterSolidMatter.addrecipe(new ItemStack((Block)Blocks.field_150349_c), 0.5, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0, 0.0);
        TileEntityConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150351_n), 0.5, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0, 0.0);
        TileEntityConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150352_o), 1.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileEntityConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150365_q), 1.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0);
        TileEntityConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150340_R), 45.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileEntityConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150426_aN), 1.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0);
        TileEntityConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150359_w), 2.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileEntityConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150460_al), 2.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        TileEntityConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150377_bs), 0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0);
        for (int i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileEntityConverterSolidMatter.addrecipe(new ItemStack(IUItem.iuingot, 1, i), 1.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        }
    }

    public void setOverclockRates() {
        this.upgradeSlot.onChanged();
        double stackOpLen = (double)(this.defaultOperationLength + this.upgradeSlot.extraProcessTime) * 64.0 * this.upgradeSlot.processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = TileEntityConverterSolidMatter.applyModifier(this.defaultEnergyConsume, this.upgradeSlot.extraEnergyDemand, this.upgradeSlot.energyDemandMultiplier);
        this.setTier(TileEntityConverterSolidMatter.applyModifier(12, this.upgradeSlot.extraTier, 1.0));
        this.maxEnergy = TileEntityConverterSolidMatter.applyModifier((int)this.defaultEnergyStorage, this.upgradeSlot.extraEnergyStorage + this.operationLength * this.energyConsume, this.upgradeSlot.energyStorageMultiplier);
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    public static void addrecipe(ItemStack stack, double matter, double sunmatter, double aquamatter, double nethermatter, double nightmatter, double earthmatter, double endmatter, double aermatter) {
        NBTTagCompound nbt = new NBTTagCompound();
        double[] quantitysolid = new double[]{matter, sunmatter, aquamatter, nethermatter, nightmatter, earthmatter, endmatter, aermatter};
        for (int i = 0; i < quantitysolid.length; ++i) {
            ModUtils.SetDoubleWithoutItem(nbt, "quantitysolid_" + i, quantitysolid[i]);
        }
        Recipes.matterrecipe.addRecipe((IRecipeInput)new RecipeInputItemStack(stack), nbt, new ItemStack[]{stack});
    }

    @SideOnly(value=Side.CLIENT)
    public void onRender() {
    }

    @Override
    public void onNetworkUpdate(String field) {
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount == 0.0) {
            return 0.0;
        }
        if (this.energy >= this.maxEnergy) {
            return amount;
        }
        if (this.energy + amount >= this.maxEnergy) {
            double p = this.maxEnergy - this.energy;
            this.energy += p;
            return amount - p;
        }
        this.energy += amount;
        return 0.0;
    }

    public double getProgress() {
        return this.guiProgress;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.MatterSlot.getmatter();
        RecipeOutput output = this.getOutput();
        boolean needsInvUpdate = false;
        if (output != null) {
            double p;
            this.setActive(true);
            if (this.energy == 0.0) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
            }
            if (this.useEnergy(2.0, false) && this.getrequiredmatter(output)) {
                this.progress += 1.0;
                this.useEnergy(2.0, true);
                needsInvUpdate = true;
            }
            if ((p = this.progress / (double)this.operationLength) <= 1.0) {
                this.guiProgress = p;
            }
            if (p > 1.0) {
                this.guiProgress = 1.0;
            }
            if (this.progress >= (double)this.operationLength && this.getrequiredmatter(output)) {
                this.operate(output);
                this.progress = 0.0;
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
            }
        } else {
            if (this.getActive()) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
            }
            this.setActive(false);
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    private void useMatter(RecipeOutput output) {
        int i;
        if (this.inputSlot.isEmpty()) {
            return;
        }
        ItemStack stack = this.inputSlot.get(0);
        double quantity = ModUtils.NBTGetDouble(stack, "quantity");
        if (quantity == 0.0) {
            quantity = 1.0;
        }
        if ((quantity /= 2.0) < 9.765625E-4) {
            return;
        }
        NBTTagCompound nbt = output.metadata;
        double[] outputmatter = new double[9];
        for (i = 0; i < this.quantitysolid.length; ++i) {
            outputmatter[i] = nbt.func_74769_h("quantitysolid_" + i);
        }
        for (i = 0; i < this.quantitysolid.length; ++i) {
            int n = i;
            this.quantitysolid[n] = this.quantitysolid[n] - outputmatter[i];
        }
    }

    public boolean getrequiredmatter(RecipeOutput output) {
        int i;
        NBTTagCompound nbt = output.metadata;
        double[] outputmatter = new double[9];
        for (i = 0; i < this.quantitysolid.length; ++i) {
            outputmatter[i] = nbt.func_74769_h("quantitysolid_" + i);
        }
        for (i = 0; i < this.quantitysolid.length; ++i) {
            if (this.quantitysolid[i] >= outputmatter[i]) continue;
            return false;
        }
        return true;
    }

    public void operate(RecipeOutput output) {
        List processResult = output.items;
        this.operateOnce(processResult, output);
    }

    public void operateOnce(List<ItemStack> processResult, RecipeOutput output) {
        this.useMatter(output);
        this.outputSlot.add(processResult);
    }

    public RecipeOutput getOutput() {
        if (this.inputSlot.isEmpty()) {
            return null;
        }
        RecipeOutput output = this.inputSlot.process();
        if (output == null) {
            return null;
        }
        if (this.outputSlot.canAdd(output.items)) {
            return output;
        }
        return null;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            this.quantitysolid[i] = nbttagcompound.func_74769_h("quantitysolid_" + i);
        }
        this.progress = nbttagcompound.func_74769_h("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            nbttagcompound.func_74780_a("quantitysolid_" + i, this.quantitysolid[i]);
        }
        nbttagcompound.func_74780_a("progress", this.progress);
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount, boolean consume) {
        if (this.energy >= amount) {
            if (consume) {
                this.energy -= amount;
            }
            return true;
        }
        return false;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUIConverterSolidMatter(new ContainerConverterSolidMatter(entityPlayer, this));
    }

    public ContainerBase<? extends TileEntityConverterSolidMatter> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerConverterSolidMatter(entityPlayer, this);
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
    }

    public String getStartSoundFile() {
        return "Machines/MaceratorOp.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IC2.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing);
    }

    public String func_145825_b() {
        return null;
    }
}

