/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.audio.AudioSource;
import com.denfop.block.base.BlocksItems;
import com.denfop.container.ContainerHydrogenGenerator;
import com.denfop.gui.GUIHydrogenGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankInventory;
import ic2.core.block.invslot.InvSlotCharge;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.init.MainConfig;
import ic2.core.network.NetworkManager;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityHydrogenGenerator
extends TileEntityLiquidTankInventory
implements IEnergySource,
IHasGui,
INetworkTileEntityEventListener {
    public final InvSlotCharge chargeSlot = new InvSlotCharge((TileEntityInventory)this, 0, 1);
    public final InvSlotConsumableLiquid fluidSlot;
    public final InvSlotOutput outputSlot;
    public final double maxStorage;
    public final int production = Math.round(20.0f * ConfigUtil.getFloat((Config)MainConfig.get(), (String)"balance/energy/generator/geothermal"));
    private final double coef;
    private final String name;
    public double storage = 0.0;
    public boolean addedToEnergyNet = false;
    public AudioSource audioSource;

    public TileEntityHydrogenGenerator() {
        super(12);
        this.name = null;
        this.coef = 0.25;
        this.maxStorage = 32000.0 * this.coef;
        this.fluidSlot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "fluidSlot", 1, 1, new Fluid[]{BlocksItems.getFluid("fluidhyd")});
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 2, 1);
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.storage = nbttagcompound.func_74769_h("storage");
        }
        catch (Exception var3) {
            this.storage = nbttagcompound.func_74765_d("storage");
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("storage", this.storage);
    }

    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.needsFluid() && this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, output = new MutableObject(), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            needsInvUpdate = this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        boolean newActive = this.gainEnergy();
        if (this.storage > this.maxStorage) {
            this.storage = this.maxStorage;
        }
        if (this.storage >= 1.0 && this.chargeSlot.get() != null) {
            double used = ElectricItem.manager.charge(this.chargeSlot.get(), this.storage, 1, false, false);
            this.storage -= used;
            if (used > 0.0) {
                needsInvUpdate = true;
            }
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (this.getActive() != newActive) {
            this.setActive(newActive);
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 60L == 0L) {
            this.initiate(2);
        }
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IUCore.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public double getOfferedEnergy() {
        return Math.min(this.storage, 4096.0);
    }

    public int getSourceTier() {
        return 1;
    }

    public void drawEnergy(double amount) {
        this.storage -= amount;
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    private void initiate(int soundEvent) {
        ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, soundEvent, true);
    }

    public String getStartSoundFile() {
        return "Machines/hydrogen_generator.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IUCore.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IUCore.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public float getWrenchDropRate() {
        return 0.9f;
    }

    public boolean gainEnergy() {
        if (this.isConverting()) {
            this.storage += (double)this.production * this.coef;
            this.getFluidTank().drain(2, true);
            this.initiate(0);
            return true;
        }
        this.initiate(2);
        return false;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == BlocksItems.getFluid("fluidhyd");
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean isConverting() {
        return this.getTankAmount() > 0 && this.storage + (double)this.production <= this.maxStorage;
    }

    public int gaugeStorageScaled(int i) {
        return (int)(this.storage * (double)i / this.maxStorage);
    }

    public ContainerBase<TileEntityHydrogenGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerHydrogenGenerator(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUIHydrogenGenerator(new ContainerHydrogenGenerator(entityPlayer, this));
    }

    public void onBlockBreak(Block block, int meta) {
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(new FluidStack(BlocksItems.getFluid("fluidhyd"), 1000), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }
}

