/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.audio.AudioSource;
import com.denfop.container.ContainerKineticGenerator;
import com.denfop.gui.GUIKineticGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IKineticSource;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.init.MainConfig;
import ic2.core.network.NetworkManager;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityKineticGenerator
extends TileEntityInventory
implements IEnergySource,
IHasGui,
INetworkTileEntityEventListener {
    private final int tier;
    private final String name;
    private final int maxEUStorage = 200000;
    private final double productionpeerkineticunit = 0.25 * (double)ConfigUtil.getFloat((Config)MainConfig.get(), (String)"balance/energy/generator/Kinetic");
    public int updateTicker = IC2.random.nextInt(this.getTickRate());
    public double EUstorage = 0.0;
    public boolean addedToEnergyNet = false;
    public AudioSource audioSource;
    private double guiproduction = 0.0;
    private double production = 0.0;

    public TileEntityKineticGenerator(int tier, String name) {
        this.tier = tier;
        this.name = name;
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean newActive = this.gainEnergy();
        if (this.updateTicker++ >= this.getTickRate()) {
            this.guiproduction = this.production;
            this.updateTicker = 0;
        }
        if (this.EUstorage > (double)this.maxEUStorage) {
            this.EUstorage = this.maxEUStorage;
        }
        if (this.getActive() != newActive) {
            this.setActive(newActive);
        }
    }

    protected boolean gainEnergy() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (te instanceof IKineticSource) {
            int kineticbandwith = ((IKineticSource)te).maxrequestkineticenergyTick(dir.getOpposite());
            double freeEUstorage = (double)this.maxEUStorage - this.EUstorage;
            if (freeEUstorage > 0.0 && freeEUstorage < this.productionpeerkineticunit * (double)kineticbandwith) {
                freeEUstorage = this.productionpeerkineticunit * (double)kineticbandwith;
            }
            if (freeEUstorage >= this.productionpeerkineticunit * (double)kineticbandwith) {
                int receivedkinetic = ((IKineticSource)te).requestkineticenergy(dir.getOpposite(), kineticbandwith);
                if (receivedkinetic != 0) {
                    this.production = (double)receivedkinetic * this.productionpeerkineticunit;
                    this.initiate(0);
                    this.EUstorage += this.production;
                    return true;
                }
            } else {
                this.initiate(2);
            }
        }
        this.production = 0.0;
        return false;
    }

    public ContainerBase<TileEntityKineticGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerKineticGenerator(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUIKineticGenerator(new ContainerKineticGenerator(entityPlayer, this));
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.EUstorage = nbttagcompound.func_74769_h("EUstorage");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("EUstorage", this.EUstorage);
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public double getOfferedEnergy() {
        return Math.min(this.EUstorage, EnergyNet.instance.getPowerFromTier(this.getSourceTier()));
    }

    public int getSourceTier() {
        return this.tier;
    }

    public void drawEnergy(double amount) {
        this.EUstorage -= amount;
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int gaugeEUStorageScaled(int i) {
        return (int)(this.EUstorage * (double)i / (double)this.maxEUStorage);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    public void setFacing(short side) {
        super.setFacing(side);
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IUCore.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public float getWrenchDropRate() {
        return 0.9f;
    }

    public double getproduction() {
        return this.guiproduction;
    }

    public int getTickRate() {
        return 20;
    }

    public String getStartSoundFile() {
        return "Machines/kineticgenerator.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    private void initiate(int soundEvent) {
        ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, soundEvent, true);
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IUCore.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IUCore.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }
}

