/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.audio.AudioSource;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.network.NetworkManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMagnetGenerator
extends TileEntityInventory
implements INetworkTileEntityEventListener,
IEnergySource {
    private final double maxEnergy;
    private final double production;
    public AudioSource audioSource;
    public boolean addedToEnergyNet = false;
    private double energy = 0.0;

    public TileEntityMagnetGenerator() {
        this.maxEnergy = 500000.0;
        this.production = 0.5;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    public int getSourceTier() {
        return 1;
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.energy + this.production < this.maxEnergy) {
            this.energy += this.production;
            this.setActive(true);
            this.initiate(0);
        } else {
            this.initiate(2);
            this.setActive(false);
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 60L == 0L) {
            this.initiate(2);
        }
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IUCore.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public void drawEnergy(double amount) {
        this.energy -= amount;
    }

    public double getOfferedEnergy() {
        return Math.min(this.production, this.energy);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    private void initiate(int soundEvent) {
        ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, soundEvent, true);
    }

    public String getStartSoundFile() {
        return "Machines/magnet_generator.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IUCore.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IUCore.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public String func_145825_b() {
        return null;
    }
}

