/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.container.ContainerSolarGeneratorEnergy;
import com.denfop.gui.GUISolarGeneratorEnergy;
import com.denfop.invslot.InvSlotGenSunarrium;
import com.denfop.tiles.base.TileEntityElectricMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class TileSolarGeneratorEnergy
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener {
    public final InvSlotOutput outputSlot;
    public final ItemStack itemstack = new ItemStack(IUItem.sunnarium, 1, 4);
    public final double maxSunEnergy;
    public final double cof;
    public final String name;
    public final InvSlotGenSunarrium input;
    public AudioSource audioSource;
    public double sunenergy = 0.0;

    public TileSolarGeneratorEnergy(double cof, String name) {
        super(0.0, 10, 0);
        this.maxSunEnergy = 2500.0;
        this.cof = cof;
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 1, 1);
        this.name = name;
        this.input = new InvSlotGenSunarrium(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void onRender() {
    }

    @Override
    public void onNetworkUpdate(String field) {
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !this.field_145850_b.field_73011_w.field_76576_e) {
            this.energy();
            if (this.energy >= this.maxSunEnergy && this.outputSlot.canAdd(this.itemstack)) {
                this.outputSlot.add(this.itemstack);
                this.energy -= this.maxSunEnergy;
            }
        }
    }

    public void energy() {
        float celestialAngle;
        float angle;
        double k = 0.0;
        List<Double> lst = this.input.coefday();
        if (this.field_145850_b.field_73011_w.isDaytime()) {
            angle = this.field_145850_b.func_72826_c(1.0f) - 0.78469056f < 0.0f ? 0.21530944f : -0.78469056f;
            celestialAngle = (this.field_145850_b.func_72826_c(1.0f) + angle) * 360.0f;
            celestialAngle %= 360.0f;
            if ((celestialAngle += 12.0f) <= 90.0f) {
                k = celestialAngle / 90.0f;
            } else if (celestialAngle > 90.0f && celestialAngle < 180.0f) {
                k = 1.0f - (celestialAngle -= 90.0f) / 90.0f;
            }
            k *= 30.0 * this.cof * (1.0 + lst.get(0));
        }
        if (lst.get(2) > 0.0 && !this.field_145850_b.field_73011_w.isDaytime()) {
            angle = this.field_145850_b.func_72826_c(1.0f) - 0.78469056f < 0.0f ? 0.21530944f : -0.78469056f;
            celestialAngle = (this.field_145850_b.func_72826_c(1.0f) + angle) * 360.0f;
            celestialAngle %= 360.0f;
            if ((celestialAngle += 12.0f) > 180.0f && celestialAngle < 270.0f) {
                k = (celestialAngle -= 180.0f) / 90.0f;
            } else if (celestialAngle > 270.0f && celestialAngle < 360.0f) {
                k = 1.0f - (celestialAngle -= 270.0f) / 90.0f;
            }
            k *= 30.0 * this.cof * (lst.get(2) - 1.0) * (1.0 + lst.get(1));
        }
        this.energy += k;
        if (this.energy >= this.maxSunEnergy) {
            this.energy = this.maxSunEnergy;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.sunenergy = nbttagcompound.func_74769_h("sunenergy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("sunenergy", this.sunenergy);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IC2.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public ContainerBase<? extends TileSolarGeneratorEnergy> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSolarGeneratorEnergy(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUISolarGeneratorEnergy(new ContainerSolarGeneratorEnergy(entityPlayer, this));
    }
}

