/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.container.ContainerMagnet;
import com.denfop.gui.GUIMagnet;
import com.denfop.tiles.base.TileEntityElectricMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMagnet
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener {
    public final int energyconsume;
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 2, 24);
    public AudioSource audioSource;

    public TileEntityMagnet() {
        super(100000.0, 14, 1);
        this.energyconsume = 1000;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        ItemStack ret = super.getWrenchDrop(entityPlayer);
        for (int i = 0; i < 24; ++i) {
            if (this.outputSlot.get(i) == null) continue;
            double var8 = 0.7;
            double var10 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            double var12 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            double var14 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            EntityItem var16 = new EntityItem(this.field_145850_b, (double)this.field_145851_c + var10, (double)this.field_145848_d + var12, (double)this.field_145849_e + var14, this.outputSlot.get(i));
            var16.field_145804_b = 10;
            this.field_145850_b.func_72838_d((Entity)var16);
        }
        return ret;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        int radius = 10;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - radius), (double)(this.field_145848_d - radius), (double)(this.field_145849_e - radius), (double)(this.field_145851_c + radius), (double)(this.field_145848_d + radius), (double)(this.field_145849_e + radius));
        List list = this.field_145850_b.func_72872_a(EntityItem.class, axisalignedbb);
        if (this.field_145850_b.field_73011_w.getWorldTime() % 10L == 0L) {
            for (int x = this.field_145851_c - 10; x <= this.field_145851_c + 10; ++x) {
                for (int y = this.field_145848_d - 10; y <= this.field_145848_d + 10; ++y) {
                    for (int z = this.field_145849_e - 10; z <= this.field_145849_e + 10; ++z) {
                        if (this.field_145850_b.func_147438_o(x, y, z) == null || !(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityMagnet) || this.field_145850_b.func_147438_o(x, y, z) == this) continue;
                        return;
                    }
                }
            }
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 10L == 0L) {
            for (EntityItem item : list) {
                ItemStack stack;
                if (!(this.energy >= (double)this.energyconsume) || !this.outputSlot.canAdd(stack = item.func_92059_d())) continue;
                this.setActive(true);
                this.energy -= (double)this.energyconsume;
                this.outputSlot.add(stack);
                item.func_70106_y();
            }
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 40L == 0L && this.getActive()) {
            this.setActive(false);
        }
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount == 0.0) {
            return 0.0;
        }
        if (this.energy >= this.maxEnergy) {
            return amount;
        }
        if (this.energy + amount >= this.maxEnergy) {
            double p = this.maxEnergy - this.energy;
            this.energy += p;
            return amount - p;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    public int func_70302_i_() {
        return 24;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUIMagnet(new ContainerMagnet<TileEntityMagnet>(entityPlayer, this));
    }

    public ContainerBase<? extends TileEntityMagnet> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMagnet<TileEntityMagnet>(entityPlayer, this);
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
    }

    public String getStartSoundFile() {
        return "Machines/MaceratorOp.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IC2.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public String func_145825_b() {
        return null;
    }
}

