/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors;

import com.denfop.Config;
import com.denfop.container.ContainerBaseNuclearReactor;
import com.denfop.damagesource.IUDamageSource;
import com.denfop.gui.GUINuclearReactor;
import com.denfop.invslot.InvSlotReactor;
import com.denfop.item.armour.ItemArmorAdvHazmat;
import com.denfop.tiles.base.TileEntityRadiationPurifier;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.init.MainConfig;
import ic2.core.network.NetworkManager;
import ic2.core.util.ConfigUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityBaseNuclearReactorElectric
extends TileEntityInventory
implements IHasGui,
IReactor,
IEnergySource,
IMetaDelegate {
    public final int sizeX;
    public final int sizeY;
    public final double coef;
    public final InvSlotReactor reactorSlot;
    public boolean getblock;
    public float output = 0.0f;
    public int updateTicker = IC2.random.nextInt(this.getTickRate());
    public int heat = 0;
    public int maxHeat = 10000;
    public float hem = 1.0f;
    public String background;
    public AudioSource audioSourceMain;
    public AudioSource audioSourceGeiger;
    public boolean addedToEnergyNet = false;
    protected boolean redstone = false;
    protected float lastOutput = 0.0f;
    protected List<TileEntity> subTiles;

    public TileEntityBaseNuclearReactorElectric(int sizeX, int sizeY, String background, double coef) {
        this.reactorSlot = new InvSlotReactor(this, "reactor", 0, sizeX * sizeY);
        this.getblock = false;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.background = background;
        this.coef = coef;
    }

    abstract void setblock();

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.isFluidCooled()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isRendering()) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSourceMain = null;
            this.audioSourceGeiger = null;
        }
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public String func_145825_b() {
        return "Nuclear Reactor";
    }

    public int gaugeHeatScaled(int i) {
        return i * this.heat / (this.maxHeat / 100 * 85);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.heat = nbttagcompound.func_74762_e("heat");
        this.output = (float)nbttagcompound.func_74769_h("output");
        this.getblock = nbttagcompound.func_74767_n("getblock");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("heat", this.heat);
        nbttagcompound.func_74780_a("output", (double)this.getReactorEnergyOutput());
        nbttagcompound.func_74757_a("getblock", this.getblock);
    }

    public void setRedstoneSignal(boolean redstone) {
        this.redstone = redstone;
    }

    public void drawEnergy(double amount) {
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public double getOfferedEnergy() {
        return this.getReactorEnergyOutput() * 5.0f * ConfigUtil.getFloat((ic2.core.util.Config)MainConfig.get(), (String)"balance/energy/generator/nuclear");
    }

    public int getSourceTier() {
        return 4;
    }

    public double getReactorEUEnergyOutput() {
        return this.getOfferedEnergy();
    }

    public void refreshChambers() {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        this.subTiles = null;
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() && this.field_145850_b.field_73011_w.getWorldTime() % 200L == 0L) {
            for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
                for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                    for (int y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
                        if (this.getWorld().func_147438_o(x, y, z) instanceof TileEntityRadiationPurifier) {
                            TileEntityRadiationPurifier tile = (TileEntityRadiationPurifier)this.getWorld().func_147438_o(x, y, z);
                            if (tile.getActive()) {
                                this.getblock = true;
                                return;
                            }
                            this.getblock = false;
                            continue;
                        }
                        this.getblock = false;
                    }
                }
            }
        }
        if (this.getActive() && !this.getblock) {
            int radius = 5;
            AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - radius), (double)(this.field_145848_d - radius), (double)(this.field_145849_e - radius), (double)(this.field_145851_c + radius), (double)(this.field_145848_d + radius), (double)(this.field_145849_e + radius));
            List list = this.getWorld().func_72872_a(EntityPlayer.class, axisalignedbb);
            for (EntityPlayer player : list) {
                if (ItemArmorAdvHazmat.hasCompleteHazmat((EntityLivingBase)player)) continue;
                player.func_70097_a((DamageSource)IUDamageSource.radiation, 1.0f);
            }
        }
        if (this.updateTicker++ % this.getTickRate() == 0) {
            if (!this.field_145850_b.func_72873_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2)) {
                this.output = 0.0f;
            } else {
                this.output = 0.0f;
                this.maxHeat = 10000;
                this.hem = 1.0f;
                this.processChambers();
                if (this.calculateHeatEffects()) {
                    return;
                }
                this.setActive(this.heat >= 1000 || this.output > 0.0f);
                this.func_70296_d();
            }
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "output");
        }
    }

    public boolean isUsefulItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == null) {
            return false;
        }
        if (item instanceof IReactorComponent) {
            return true;
        }
        return item == Ic2Items.TritiumCell.func_77973_b() || item == Ic2Items.reactorDepletedUraniumSimple.func_77973_b() || item == Ic2Items.reactorDepletedUraniumDual.func_77973_b() || item == Ic2Items.reactorDepletedUraniumQuad.func_77973_b() || item == Ic2Items.reactorDepletedMOXSimple.func_77973_b() || item == Ic2Items.reactorDepletedMOXDual.func_77973_b() || item == Ic2Items.reactorDepletedMOXQuad.func_77973_b();
    }

    public boolean calculateHeatEffects() {
        if (this.heat >= 4000 && IC2.platform.isSimulating() && !(ConfigUtil.getFloat((ic2.core.util.Config)MainConfig.get(), (String)"protection/reactorExplosionPowerLimit") <= 0.0f)) {
            Material mat;
            Block block;
            int[] coord;
            float power = (float)this.heat / (float)this.maxHeat;
            if (power >= 1.0f) {
                if (Config.explode) {
                    this.explode();
                } else {
                    this.setblock();
                }
                return true;
            }
            if (power >= 0.85f && this.field_145850_b.field_73012_v.nextFloat() <= 0.2f * this.hem && (coord = this.getRandCoord(2)) != null) {
                block = this.field_145850_b.func_147439_a(coord[0], coord[1], coord[2]);
                if (block.isAir((IBlockAccess)this.field_145850_b, coord[0], coord[1], coord[2])) {
                    this.field_145850_b.func_147465_d(coord[0], coord[1], coord[2], (Block)Blocks.field_150480_ab, 0, 7);
                } else if (block.func_149712_f(this.field_145850_b, coord[0], coord[1], coord[2]) >= 0.0f && this.field_145850_b.func_147438_o(coord[0], coord[1], coord[2]) == null) {
                    mat = block.func_149688_o();
                    if (mat != Material.field_151576_e && mat != Material.field_151573_f && mat != Material.field_151587_i && mat != Material.field_151578_c && mat != Material.field_151571_B) {
                        this.field_145850_b.func_147465_d(coord[0], coord[1], coord[2], (Block)Blocks.field_150480_ab, 0, 7);
                    } else {
                        this.field_145850_b.func_147465_d(coord[0], coord[1], coord[2], (Block)Blocks.field_150356_k, 15, 7);
                    }
                }
            }
            if (power >= 0.7f) {
                List list1 = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 4)));
                for (Object o : list1) {
                    Entity ent = (Entity)o;
                    ent.func_70097_a((DamageSource)IC2DamageSource.radiation, (float)((int)((float)this.field_145850_b.field_73012_v.nextInt(4) * this.hem)));
                }
            }
            if (power >= 0.5f && this.field_145850_b.field_73012_v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && (block = this.field_145850_b.func_147439_a(coord[0], coord[1], coord[2])).func_149688_o() == Material.field_151586_h) {
                this.field_145850_b.func_147468_f(coord[0], coord[1], coord[2]);
            }
            if (power >= 0.4f && this.field_145850_b.field_73012_v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && this.field_145850_b.func_147438_o(coord[0], coord[1], coord[2]) == null && ((mat = (block = this.field_145850_b.func_147439_a(coord[0], coord[1], coord[2])).func_149688_o()) == Material.field_151575_d || mat == Material.field_151584_j || mat == Material.field_151580_n)) {
                this.field_145850_b.func_147465_d(coord[0], coord[1], coord[2], (Block)Blocks.field_150480_ab, 0, 7);
            }
            return false;
        }
        return false;
    }

    public int[] getRandCoord(int radius) {
        if (radius <= 0) {
            return null;
        }
        int[] c = new int[]{this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(2 * radius + 1) - radius, this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(2 * radius + 1) - radius, this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(2 * radius + 1) - radius};
        return (int[])(c[0] == this.field_145851_c && c[1] == this.field_145848_d && c[2] == this.field_145849_e ? null : c);
    }

    public void processChambers() {
        int size = this.getReactorSize();
        for (int pass = 0; pass < 2; ++pass) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int x = 0; x < size; ++x) {
                    ItemStack stack = this.reactorSlot.get(x, y);
                    if (stack == null || !(stack.func_77973_b() instanceof IReactorComponent)) continue;
                    IReactorComponent comp = (IReactorComponent)stack.func_77973_b();
                    comp.processChamber((IReactor)this, stack, x, y, pass == 0);
                }
            }
        }
    }

    public boolean produceEnergy() {
        return this.receiveredstone() && ConfigUtil.getFloat((ic2.core.util.Config)MainConfig.get(), (String)"balance/energy/generator/generator") > 0.0f;
    }

    public boolean receiveredstone() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || this.redstone;
    }

    public abstract short getReactorSize();

    public int getTickRate() {
        return 20;
    }

    public ContainerBase<TileEntityBaseNuclearReactorElectric> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBaseNuclearReactor(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUINuclearReactor(new ContainerBaseNuclearReactor(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("output")) {
            if (this.output > 0.0f) {
                if (this.lastOutput <= 0.0f) {
                    if (this.audioSourceMain == null) {
                        this.audioSourceMain = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/NuclearReactor/NuclearReactorLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSourceMain != null) {
                        this.audioSourceMain.play();
                    }
                }
                if (this.output < 40.0f) {
                    if (this.lastOutput <= 0.0f || this.lastOutput >= 40.0f) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/NuclearReactor/GeigerLowEU.ogg", true, false, IC2.audioManager.getDefaultVolume());
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output < 80.0f) {
                    if (this.lastOutput < 40.0f || this.lastOutput >= 80.0f) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/NuclearReactor/GeigerMedEU.ogg", true, false, IC2.audioManager.getDefaultVolume());
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output >= 80.0f && this.lastOutput < 80.0f) {
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.remove();
                    }
                    this.audioSourceGeiger = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/NuclearReactor/GeigerHighEU.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.play();
                    }
                }
            } else if (this.lastOutput > 0.0f) {
                if (this.audioSourceMain != null) {
                    this.audioSourceMain.stop();
                }
                if (this.audioSourceGeiger != null) {
                    this.audioSourceGeiger.stop();
                }
            }
            this.lastOutput = this.output;
        }
        super.onNetworkUpdate(field);
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ChunkCoordinates getPosition() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public int getHeat() {
        return this.heat;
    }

    public void setHeat(int heat1) {
        this.heat = heat1;
    }

    public int addHeat(int amount) {
        this.heat += amount;
        return this.heat;
    }

    public ItemStack getItemAt(int x, int y) {
        return x >= 0 && x < this.getReactorSize() && y >= 0 && y < this.sizeY ? this.reactorSlot.get(x, y) : null;
    }

    public void setItemAt(int x, int y, ItemStack item) {
        if (x >= 0 && x < this.getReactorSize() && y >= 0 && y < this.sizeY) {
            this.reactorSlot.put(x, y, item);
        }
    }

    public abstract void explode();

    public void addEmitHeat(int heat) {
    }

    public int getMaxHeat() {
        return this.maxHeat;
    }

    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    public float getHeatEffectModifier() {
        return this.hem;
    }

    public void setHeatEffectModifier(float newHEM) {
        this.hem = newHEM;
    }

    public float getReactorEnergyOutput() {
        return (float)((double)this.output * this.coef);
    }

    public float addOutput(float energy) {
        return this.output += energy;
    }

    public boolean isFluidCooled() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }
}

