/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.fsp.handlers;

import flaxbeard.steamcraft.api.SteamcraftRegistry;
import java.util.HashMap;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.MutablePair;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.fsp.Furnace")
public class Furnace {
    public static final String name = "FSP Furnace (Steamed Foods)";

    @ZenMethod
    public static void addSteamFood(IItemStack input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new AddSteamFood(InputHelper.toStack(input), (MutablePair<Item, Integer>)MutablePair.of((Object)InputHelper.toStack(input).func_77973_b(), (Object)InputHelper.toStack(input).func_77960_j()), (MutablePair<Item, Integer>)MutablePair.of((Object)InputHelper.toStack(output).func_77973_b(), (Object)InputHelper.toStack(output).func_77960_j())));
    }

    @ZenMethod
    public static void removeSteamFood(IIngredient input) {
        HashMap<MutablePair<Item, Integer>, MutablePair<Item, Integer>> recipes = new HashMap<MutablePair<Item, Integer>, MutablePair<Item, Integer>>();
        for (Map.Entry recipe : SteamcraftRegistry.steamedFoods.entrySet()) {
            if (!StackHelper.matches(input, InputHelper.toIItemStack(new ItemStack((Item)((MutablePair)recipe.getKey()).left, 1, ((Integer)((MutablePair)recipe.getKey()).right).intValue())))) continue;
            recipes.put((MutablePair<Item, Integer>)recipe.getKey(), (MutablePair<Item, Integer>)recipe.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveSteamFood(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, input.toString()));
        }
    }

    private static class RemoveSteamFood
    extends BaseMapRemoval<MutablePair<Item, Integer>, MutablePair<Item, Integer>> {
        public RemoveSteamFood(Map<MutablePair<Item, Integer>, MutablePair<Item, Integer>> recipes) {
            super(Furnace.name, SteamcraftRegistry.steamedFoods, recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<MutablePair<Item, Integer>, MutablePair<Item, Integer>> recipe) {
            return LogHelper.getStackDescription(new ItemStack((Item)recipe.getKey().left, 1, ((Integer)recipe.getKey().right).intValue()));
        }
    }

    private static class AddSteamFood
    extends BaseMapAddition<MutablePair<Item, Integer>, MutablePair<Item, Integer>> {
        public AddSteamFood(ItemStack stack, MutablePair<Item, Integer> key, MutablePair<Item, Integer> recipe) {
            super(Furnace.name, SteamcraftRegistry.steamedFoods);
            this.recipes.put(key, recipe);
        }

        @Override
        public String getRecipeInfo(Map.Entry<MutablePair<Item, Integer>, MutablePair<Item, Integer>> recipe) {
            return LogHelper.getStackDescription(new ItemStack((Item)recipe.getKey().left, 1, ((Integer)recipe.getKey().right).intValue()));
        }
    }
}

