/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mekanism.handlers;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.gas.GasStack;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mekanism.MekanismHelper;
import modtweaker2.mods.mekanism.gas.IGasStack;
import modtweaker2.mods.mekanism.gas.MCGasStack;
import modtweaker2.mods.mekanism.util.AddMekanismRecipe;
import modtweaker2.mods.mekanism.util.RemoveMekanismRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.chemical.Injection")
public class ChemicalInjection {
    public static final String name = "Mekanism Injection";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IGasStack gasInput, IItemStack itemOutput) {
        if (itemInput == null || gasInput == null || itemOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        AdvancedMachineInput input = new AdvancedMachineInput(InputHelper.toStack(itemInput), MekanismHelper.toGas(gasInput).getGas());
        ItemStackOutput output = new ItemStackOutput(InputHelper.toStack(itemOutput));
        InjectionRecipe recipe = new InjectionRecipe(input, output);
        MineTweakerAPI.apply((IUndoableAction)new AddMekanismRecipe(name, (Map<MachineInput, MachineRecipe>)RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get(), (MachineRecipe)recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient itemInput, @Optional IIngredient gasInput) {
        if (itemOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (itemInput == null) {
            itemInput = IngredientAny.INSTANCE;
        }
        if (gasInput == null) {
            gasInput = IngredientAny.INSTANCE;
        }
        HashMap<MachineInput, MachineRecipe> recipes = new HashMap<MachineInput, MachineRecipe>();
        for (Map.Entry entry : RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get().entrySet()) {
            IItemStack inputItem = InputHelper.toIItemStack(((AdvancedMachineInput)entry.getKey()).itemStack);
            MCGasStack inputGas = new MCGasStack(new GasStack(((AdvancedMachineInput)entry.getKey()).gasType, 1));
            IItemStack outputItem = InputHelper.toIItemStack(((ItemStackOutput)((InjectionRecipe)entry.getValue()).recipeOutput).output);
            if (!StackHelper.matches(itemOutput, outputItem) || !StackHelper.matches(itemInput, inputItem) || !StackHelper.matches(gasInput, inputGas)) continue;
            recipes.put((MachineInput)entry.getKey(), (MachineRecipe)entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMekanismRecipe(name, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get(), (Map<MachineInput, MachineRecipe>)recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s, %s and %s. Command ignored!", name, itemOutput.toString(), itemInput.toString(), gasInput.toString()));
        }
    }
}

