/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mekanism.handlers;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mekanism.MekanismHelper;
import modtweaker2.mods.mekanism.gas.IGasStack;
import modtweaker2.mods.mekanism.gas.MCGasStack;
import modtweaker2.mods.mekanism.util.AddMekanismRecipe;
import modtweaker2.mods.mekanism.util.RemoveMekanismRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.chemical.Oxidizer")
public class ChemicalOxidizer {
    public static final String name = "Mekanism Oxidizer";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IGasStack gasOutput) {
        if (itemInput == null || gasOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        OxidationRecipe recipe = new OxidationRecipe(InputHelper.toStack(itemInput), MekanismHelper.toGas(gasOutput));
        MineTweakerAPI.apply((IUndoableAction)new AddMekanismRecipe(name, (Map<MachineInput, MachineRecipe>)RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get(), (MachineRecipe)recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient gasOutput, @Optional IIngredient itemInput) {
        if (gasOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (itemInput == null) {
            itemInput = IngredientAny.INSTANCE;
        }
        HashMap<MachineInput, MachineRecipe> recipes = new HashMap<MachineInput, MachineRecipe>();
        for (Map.Entry entry : RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get().entrySet()) {
            IItemStack inputItem = InputHelper.toIItemStack(((ItemStackInput)entry.getKey()).ingredient);
            MCGasStack outputGas = new MCGasStack(((GasOutput)((OxidationRecipe)entry.getValue()).recipeOutput).output);
            if (!StackHelper.matches(itemInput, inputItem) || !StackHelper.matches(gasOutput, outputGas)) continue;
            recipes.put((MachineInput)entry.getKey(), (MachineRecipe)entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMekanismRecipe(name, RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get(), (Map<MachineInput, MachineRecipe>)recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s and %s. Command ignored!", name, gasOutput.toString(), itemInput.toString()));
        }
    }
}

