/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mekanism.handlers;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mekanism.util.AddMekanismRecipe;
import modtweaker2.mods.mekanism.util.RemoveMekanismRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.Infuser")
public class Infuser {
    public static final String name = "Mekanism Infuser";

    @ZenMethod
    public static void addRecipe(String infuseType, int infuseAmount, IItemStack itemInput, IItemStack itemOutput) {
        if (itemInput == null || itemOutput == null || infuseType == null || infuseType.isEmpty()) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        InfusionInput input = new InfusionInput(InfuseRegistry.get((String)infuseType), infuseAmount, InputHelper.toStack(itemInput));
        ItemStackOutput output = new ItemStackOutput(InputHelper.toStack(itemOutput));
        MetallurgicInfuserRecipe recipe = new MetallurgicInfuserRecipe(input, output);
        MineTweakerAPI.apply((IUndoableAction)new AddMekanismRecipe(name, (Map<MachineInput, MachineRecipe>)RecipeHandler.Recipe.METALLURGIC_INFUSER.get(), (MachineRecipe)recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient itemInput, @Optional String infuseType) {
        if (itemOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (itemInput == null) {
            itemInput = IngredientAny.INSTANCE;
        }
        if (infuseType == null) {
            infuseType = "";
        }
        HashMap<MachineInput, MachineRecipe> recipes = new HashMap<MachineInput, MachineRecipe>();
        for (Map.Entry entry : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().entrySet()) {
            IItemStack inputItem = InputHelper.toIItemStack(((InfusionInput)entry.getKey()).inputStack);
            String typeInfuse = ((InfusionInput)entry.getKey()).infuse.type.name;
            IItemStack outputItem = InputHelper.toIItemStack(((ItemStackOutput)((MetallurgicInfuserRecipe)entry.getValue()).recipeOutput).output);
            if (!StackHelper.matches(itemOutput, outputItem) || !StackHelper.matches(itemInput, inputItem) || !infuseType.isEmpty() && !infuseType.equalsIgnoreCase(typeInfuse)) continue;
            recipes.put((MachineInput)entry.getKey(), (MachineRecipe)entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMekanismRecipe(name, RecipeHandler.Recipe.METALLURGIC_INFUSER.get(), (Map<MachineInput, MachineRecipe>)recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s and %s. Command ignored!", name, itemInput.toString(), itemOutput.toString()));
        }
    }
}

